<?php //ccm.inc.php

// CCM COMPONENT
//
// Copyright (c) 2010 Nagios Enterprises, LLC.  All rights reserved.
//  
// $Id: ccm.inc.php 115 2010-08-16 16:15:26Z mguthrie $

//include the helper file
require_once(dirname(__FILE__).'/../componenthelper.inc.php');

// respect the name
$ccm_component_name="ccm";

// run the initialization function
ccm_component_init();

////////////////////////////////////////////////////////////////////////
// COMPONENT INIT FUNCTIONS
////////////////////////////////////////////////////////////////////////

function ccm_component_init(){
	global $ccm_component_name;
	
	//boolean to check for latest version
	$versionok=ccm_component_checkversion();
	
	//component description
	$desc="This component is a new revision of the Core Config Manager and is still considered to be a beta.  
	The Nagios CCM is not currently recommended for production environments.";
	
	if(!$versionok)
		$desc="<b>Error: This component requires Nagios XI 2011R2.1 or later.</b>";
	
	//all components require a few arguments to be initialized correctly.  
	$args=array(

		// need a name
		COMPONENT_NAME => $ccm_component_name,
		COMPONENT_VERSION => '0.4', 
		COMPONENT_DATE => '06/12/2012',

		// informative information
		COMPONENT_AUTHOR => "Mike Guthrie. Nagios Enterprises, LLC",
		COMPONENT_DESCRIPTION => $desc,
		COMPONENT_TITLE => "Nagios CCM",

		// configuration function (optional)
		//COMPONENT_CONFIGFUNCTION => "ccm_component_config_func",
		);
	
	//register this component with XI 
	register_component($ccm_component_name,$args);
	
	// register the addmenu function
	if($versionok) {
		register_callback(CALLBACK_MENUS_INITIALIZED,'ccm_component_addmenu');
		register_callback(CALLBACK_CONFIG_SPLASH_SCREEN,'ccm_component_addsplash');
		//new CCM menu 
		define('MENU_CCM','ccm'); 
		add_ccm_menu(); 
	}
}	



function ccm_component_checkversion(){

	if(!function_exists('get_product_release'))
		return false;
	//requires greater than 2011R2.1
	if(get_product_release()<210)
		return false;

	return true;
	}
	

function ccm_component_addmenu($arg=null){
	global $autodiscovery_component_name;
	
	$mi=find_menu_item(MENU_CONFIGURE,"menu-configure-coreconfigmanager","id");
	if($mi==null)
		return;
		
	$order=grab_array_var($mi,"order","");
	if($order=="")
		return;
		
	$neworder=$order+0.1;

	add_menu_item(MENU_CONFIGURE,array(
		"type" => "link",
		"title" => "Nagios CCM BETA",
		"id" => "menu-configure-ccm",
		"order" => $neworder,
		"opts" => array(
			"href" => get_base_url().'includes/components/ccm/xi-index.php',
			"img" => theme_image("menuredirect.png"),
			"target" => "_top"
			)
		));
	
	}

function ccm_component_addsplash($arg=null){

	$url=get_base_url().'includes/components/ccm/';

	$output='
	<br clear="all">
	<p>
	<a href="'.$url.'xi-index.php" target="_top"><img src="'.$url.'ccm.jpg" style="float: left; margin-right: 10px;"> Nagios CCM <strong>BETA</strong></a><br>
	Nagios Core Config Manager: Advanced Nagios Configuration management tool.
	</p>
	';

	echo $output;
	}


// BUILD NEW CCM MENU To overlay the old one 

function add_ccm_menu()
{
	add_menu(MENU_CCM);	
	$ccm_home = get_base_url()."/includes/components/ccm/"; 
	$corecfg_path=get_base_url()."/includes/components/nagioscorecfg/";
	
	add_menu_item(MENU_CCM,array(
		"type" => "html",
		"title" => "Nagios Core Config Manager",
		"id" => "menu-ccm-logo",
		"order" => 100,
		"opts" => array(
			"html" => "<img src='".$ccm_home."ccm.jpg' title='Nagios Core Config Manager'><br><br>",
			"target" => "_top"
			)
		));
	
	// Quick Tools
	add_menu_item(MENU_CCM,array(
		"type" => "menusection",
		"title" => "Quick Tools",
		"id" => "menu-ccm-section-quicktools",
		"order" => 200,
		"opts" => array(
			"id" => "quicktools",
			"expanded" => true,
			"url" => $ccm_home,
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Legacy Core Config Manager",
		"id" => "menu-ccm-configmanagerhome",
		"order" => 201,
		"opts" => array(
			"href" => get_base_url()."/config/nagioscorecfg/",
			"target" => "_top",
			)
		));
		
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "CCM Home (BETA)",
		"id" => "menu-ccm-configmanagerhome",
		"order" => 201,
		"opts" => array(
			"href" => $ccm_home,
			)
		));		
	
	
	add_menu_item(MENU_CCM,array(
		"type" => "linkspacer",
		"order" => 202,
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Apply Configuration",
		"id" => "menu-ccm-applyconfiguration",
		"order" => 210,
		"opts" => array(
			"href" => $corecfg_path."applyconfig.php?cmd=confirm",
			//"target" => "_top",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "linkspacer",
		"order" => 211,
		));

	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Configuration Snapshots",
		"id" => "menu-ccm-configsnapshots",
		"order" => 220,
		"opts" => array(
			"img" => theme_image("menuredirect.png"),
			"href" => get_base_url()."admin/?xiwindow=coreconfigsnapshots.php",
			"target" => "_parent",
			),
		"function" => "is_admin",
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Monitoring Plugins",
		"id" => "menu-ccm-monitoringplugins",
		"order" => 221,
		"opts" => array(
			"img" => theme_image("menuredirect.png"),
			"href" => get_base_url()."admin/?xiwindow=monitoringplugins.php",
			"target" => "_parent",
			),
		"function" => "is_admin",
		));

	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Configuration Wizards",
		"id" => "menu-ccm-configwizards",
		"order" => 222,
		"opts" => array(
			"img" => theme_image("menuredirect.png"),
			"href" => get_base_url()."config/",
			"target" => "_parent",
			)
		));

	add_menu_item(MENU_CCM,array(
		"type" => "menusectionend",
		"id" => "menu-ccm-sectionend-quicktools",
		"order" => 223,
		"title" => "",
		"opts" => ""
		));
	
	/////////////////////////////////////////////////////////////////////	
	// Monitoring
	add_menu_item(MENU_CCM,array(
		"type" => "menusection",
		"title" => "Monitoring",
		"id" => "menu-ccm-section-monitoring",
		"order" => 300,
		"opts" => array(
			"id" => "monitoring",
			"expanded" => true,
			//"url" => $nagiosql_path."/admin/monitoring.php",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Hosts",
		"id" => "menu-ccm-hosts",
		"order" => 301,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=host',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Services",
		"id" => "menu-ccm-services",
		"order" => 302,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=service',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Host Groups",
		"id" => "menu-ccm-hostgroups",
		"order" => 303,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=hostgroup',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Service Groups",
		"id" => "menu-ccm-servicegroups",
		"order" => 304,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=servicegroup',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "menusectionend",
		"title" => "",
		"id" => "menu-ccm-sectionend-monitoring",
		"order" => 305,
		"opts" => ""
		));


	// Alerting
	add_menu_item(MENU_CCM,array(
		"type" => "menusection",
		"title" => "Alerting",
		"id" => "menu-ccm-section-alerting",
		"order" => 400,
		"opts" => array(
			"id" => "alerting",
			"expanded" => true,
			//"url" => $nagiosql_path."/admin/alarming.php",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Contacts",
		"id" => "menu-ccm-contacts",
		"order" => 401,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=contact',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Contact Groups",
		"id" => "menu-ccm-contactgroups",
		"order" => 402,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=contactgroup',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Time Periods",
		"id" => "menu-ccm-timeperiods",
		"order" => 403,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=timeperiod',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Host Escalations",
		"id" => "menu-ccm-hostescalations",
		"order" => 404,
		"opts" => array(
			"href" => $ccm_home."?cmd=view&type=hostescalation",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Service Escalations",
		"id" => "menu-ccm-serviceescalations",
		"order" => 405,
		"opts" => array(
			"href" => $ccm_home."?cmd=view&type=serviceescalation",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "menusectionend",
		"title" => "",
		"id" => "menu-ccm-sectionend-alerting",
		"order" => 406,
		"opts" => ""
		));

	// Templates
	add_menu_item(MENU_CCM,array(
		"type" => "menusection",
		"title" => "Templates",
		"id" => "menu-ccm-section-templates",
		"order" => 500,
		"opts" => array(
			"id" => "templates",
			"expanded" => false,
			//"url" => $nagiosql_path."/admin/hosttemplates.php",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Host Templates",
		"id" => "menu-ccm-hosttemplates",
		"order" => 501,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=hosttemplate',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Service Templates",
		"id" => "menu-ccm-servicetemplates",
		"order" => 502,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=servicetemplate',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Contact Templates",
		"id" => "menu-ccm-contacttemplates",
		"order" => 503,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=contacttemplate',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "menusectionend",
		"title" => "",
		"id" => "menu-ccm-sectionend-templates",
		"order" => 504,
		"opts" => ""
		));

	// Commands
	add_menu_item(MENU_CCM,array(
		"type" => "menusection",
		"title" => "Commands",
		"id" => "menu-ccm-section-commands",
		"order" => 600,
		"opts" => array(
			"id" => "commands",
			"expanded" => false,
			//"url" => $nagiosql_path."/admin/checkcommands.php",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Commands",
		"id" => "menu-ccm-commands",
		"order" => 601,
		"opts" => array(
			"href" => $ccm_home.'?cmd=view&type=command',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "menusectionend",
		"title" => "",
		"id" => "menu-ccm-sectionend-commands",
		"order" => 602,
		"opts" => ""
		));


	// Advanced
	add_menu_item(MENU_CCM,array(
		"type" => "menusection",
		"title" => "Advanced",
		"id" => "menu-ccm-section-advanced",
		"order" => 700,
		"opts" => array(
			"id" => "advanced",
			"expanded" => false,
			//"url" => $nagiosql_path."/admin/specials.php",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Host Dependencies",
		"id" => "menu-ccm-hostdependencies",
		"order" => 701,
		"opts" => array(
			"href" => $ccm_home."?cmd=view&type=hostdependency",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Service Dependencies",
		"id" => "menu-ccm-servicedependencies",
		"order" => 702,
		"opts" => array(
			"href" => $ccm_home."?cmd=view&type=servicedependency",
			)
		));
		
		
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Nagios Core Main Config",
		"id" => "menu-ccm-coremainconfig",
		"order" => 703,
		"opts" => array(
			"href" => $ccm_home."?cmd=admin&type=corecfg",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Nagios Core CGI Config",
		"id" => "menu-ccm-corecgiconfig",
		"order" => 704,
		"opts" => array(
			"href" => $ccm_home."?cmd=admin&type=cgicfg",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "menusectionend",
		"title" => "",
		"id" => "menu-ccm-sectionend-advanced",
		"order" => 705,
		"opts" => ""
		));

	// Tools
	add_menu_item(MENU_CCM,array(
		"type" => "menusection",
		"title" => "Tools",
		"id" => "menu-ccm-section-tools",
		"order" => 800,
		"opts" => array(
			"id" => "tools",
			"expanded" => false,
			//"url" => $nagiosql_path."/admin/tools.php",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Static Configurations",
		"id" => "menu-ccm-staticconfigurations",
		"order" => 801,
		"opts" => array(
			"href" => $ccm_home."?cmd=admin&type=static",
			)
		));			
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Bulk Modifications",
		"id" => "menu-ccm-bulkmodifications",
		"order" => 802,
		"opts" => array(
			"href" => $ccm_home."?cmd=admin&type=bulk",
			)
		));		
		
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Import Config Files",
		"id" => "menu-ccm-importconfigfiles",
		"order" => 803,
		"opts" => array(
			"href" => $ccm_home."?cmd=admin&type=import",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Write Config Files",
		"id" => "menu-ccm-writeconfigfiles",
		"order" => 804,
		"opts" => array(
			"href" => $ccm_home.'?cmd=apply',
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "menusectionend",
		"title" => "",
		"id" => "menu-ccm-sectionend-tools",
		"order" => 810,
		"opts" => ""
		));


	// NagiosQL Admin
	add_menu_item(MENU_CCM,array(
		"type" => "menusection",
		"title" => "Config Manager Admin",
		"id" => "menu-ccm-section-admin",
		"order" => 900,
		"opts" => array(
			"id" => "nagiosqladmin",
			"expanded" => false,
			//"url" => $nagiosql_path."/admin/user.php",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Manage Config Access",
		"id" => "menu-ccm-manageconfigaccess",
		"order" => 901,
		"opts" => array(
			"href" => $ccm_home."?cmd=admin&type=user",
			)
		));

	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Config Manager Log",
		"id" => "menu-ccm-configmanagerlog",
		"order" => 903,
		"opts" => array(
			"href" => $ccm_home."?cmd=admin&type=log",
			)
		));
	add_menu_item(MENU_CCM,array(
		"type" => "link",
		"title" => "Config Manager Settings",
		"id" => "menu-ccm-configmanagersettings",
		"order" => 904,
		"opts" => array(
			"href" => $ccm_home."?cmd=admin&type=settings",
			)
		));

	add_menu_item(MENU_CCM,array(
		"type" => "menusectionend",
		"title" => "",
		"id" => "menu-ccm-sectionend-admin",
		"order" => 910,
		"opts" => ""
		));
	

}	//end build_ccm_menu()  



?>