<?php  //common_functions.inc.php and melting pot of misc functions for the CCM 



/** function default_page() 
*
*	displays the default home page message for the CCM 
*	@return string $html html content for default page 
*/
function default_page()
{
	$html = "
	<div id='contentWrapper'>
		<h3>Nagios CCM ".CCMVERSION."</h3>
		<ul>
			<li>The Nagios CCM (Core Configuration Manager) is a front-end interface 
		for managing Nagios object configuration files.</li> 
			<li>Changes made in the CCM are
		written to a database, and when configurations are applied, they are written to
		physical configuration files.  </li>
		<li>All configuration changes need to be verified for 
		logical and syntax errors before Nagios can utilize them and restart successfully.</li>
		<li>No changes will take place until the configurations are written to file and Nagios 
		is restarted with a valid configuration.</li><br />
		<br />
		<span class='deselect'>Nagios CCM is based on the NagiosQL project. </span> 		
		</ul>
	</div>
	"; 

	return $html;  
}




/** function verify_token() 
*
*	security measure to protect against form spoofing for commands that modify configs 
*	@param string $cmd REFERENCE variable to string command 
*	@param string $token token submitted from the ccm form 
*	@return null modifies referenced $cmd variable if token is bad 
*/
function verify_token(&$cmd,$token)
{
	//commands that require a token check 
	$required = array('delete','copy','delete_multi','copy_multi','add','modify','insert','info','download'); 
	if(in_array($cmd,$required)) {
		//echo "SESSION: ".$_SESSION['token']." TOKEN: ".$token ;
		if($token != $_SESSION['token']){
			 $cmd='login'; 
			 $_SESSION['loginMessage'] = "Unauthorized action! Login required."; 
			 unset($_SESSION['ccm_username']); 
			 unset($_SESSION['ccm_login']); 
		}	 
	}	
}



/** function verify_type() 
*
*	security measure to protect against form spoofing for commands that modify configs 
*	@param string $cmd REFERENCE variable to string command 
*	@param string $type nagios object type (host,service,contact, etc) 
*	@return null modifies referenced $cmd variable if type is bad 
*/
function verify_type(&$cmd,$type)
{
	//valid $types 
	$matches = array('','host','service','hosttemplate','servicetemplate',
						'contact','contactgroup','contacttemplate','hostgroup',
						'servicegroup', 'contactgroup','command','timeperiod',
						'hosttemplate','servicetemplate','serviceescalation','hostescalation',
						'servicedependency','hostdependency',
						'writeConfig','verify','restart',
						'import','corecfg','cgicfg','user',
						'password','log','settings','bulk','static',
						); 
	//bail to home page if a bad type is entered (hacks) 					
	if(!in_array(trim($type),$matches)) $cmd = 'default'; 					

}



/* function check() 
*	used for preloading checkboxes on CCM forms, returns or prints checked="checked" based on $return  
*	@param string $tbl_val checks against a few special form/table values that have multiple values in single field
*	@param string $form_val checks to see if the $FIELDS[$form_val] array item is set
*	@param bool $return output will be printed unless this is set to true 
*	return null | string checked='checked' 
*/
function check($tbl_val, $form_val,$return=false)
{
	global $FIELDS;
	if($tbl_val =='') return; 
	//check for multiple values in single field 
	$exceptions = array('notification_options','stalking_options',
						'escalation_options','flap_detection_options',
						'host_notification_options','service_notification_options',
						'execution_failure_criteria','notification_failure_criteria');
						
	if(in_array($tbl_val,$exceptions)) {
		$parts = explode(',', $FIELDS[$tbl_val]);
		foreach($parts as $part) {
			if(trim($part==$form_val)) {
				 if($return == false ) echo 'checked="checked"'; 
				 else return 'checked="checked"';
			}	 
		}
	}
	//any other field 
	if(trim($FIELDS[$tbl_val]) == trim($form_val)) {		 
		 if($return == false) echo 'checked="checked"'; 
		 else return 'checked="checked"';	
	}	 
}




/**  function: is_selected()
*
*	checks to see if a select list item should be preselected, prints selected='selected' upon true 
*
*	@param string $tbl_val the DB table's field name
*	@param string/int $form_val the value of the select option 
*	@return null  
*/
function ccm_is_selected($tbl_val,$form_val)
{
	global $FIELDS;

	if(!isset($FIELDS[$tbl_val]) ) return; 
	
	if(is_array($FIELDS[$tbl_val])) {
		if(in_array($form_val, $FIELDS[$tbl_val])) echo " selected='selected' "; 		
	}
	else 
		if(trim($FIELDS[$tbl_val]) == trim($form_val)) echo " selected='selected' ";

}

/**function checkNull()  
*	handles null value from checkboxes for insertion into DB 
*	@param string $strKey input from form. 
*	@return string $strKey potentially modifed string value 
*/
function checkNull($strKey) {
 // If the transfer is null
 if($strKey=='' || $strKey == 'NULL') return 'NULL'; 
 if (strtoupper($strKey) == "NULL") return("-1");   
 return($strKey);
}

/**function is_active 
*	simple wrapper function for main ccm_table function, turns a bool into a string for table display 
*	@param int $int (0 | 1) active or inactive?
*	@return string 'Yes' | 'No' 
*/
function is_active($int,$id,$name)
{
	if($int==1) return "<a href='javascript:actionPic(\"deactivate\",\"{$id}\",\"{$name}\");' title='Deactivate'>Yes</a>";
	else return "<strong><a class='urgent' href='javascript:actionPic(\"activate\",\"{$id}\",\"{$name}\");' title='Activate'>No</a></strong>"; 
}



/** function sql_output () 
*	debugging function to dump sql results into a human readable formar into the browser 
*/ 
function sql_output($query='')
{
	global $myVisClass;
	global $myDataClass;
	global $myConfigClass; 	
	global $myDBClass;
	
	if($query == '') print "<p>QUERY INFO: ".mysql_info()."</p>"; 
	else print "<p>QUERY RUN: $query</p>"; 
	print "<p>SQL Response: ".mysql_error()."<br /> Rows affected: ".$myDBClass->intAffectedRows."</p>";  
}

/**
*	function to dump a formatted array into the webbrowser
*	@param mixed $array 
*/
function array_dump($array) 
{	
	print "<pre>".print_r($array,true)."</pre>";
}

/**function dump_request() 
*	debugging function to print $_REQUEST variables in a readable format in the browser 
*/
function dump_request()
{
	foreach($_REQUEST as $type => $value) print "$type => $value <br />";	
}

/* function do_login_div()
*	displays a login div with the $_SESSION['loginMessage'] variable in it. 
*/ 
function do_login_div()
{
	if(isset($_SESSION['loginMessage'])) 
		echo "<div id='loginDiv'><span class='deselect'>".$_SESSION['loginMessage']."</span></div>";  
}


/**
*	wrapper function that only prints a value if it exists
*	@param mixed $value the form value to check for
*	@param bool $print defaults to printing output, else returns it 
*	@return null | string $output 
*/ 
function val($value,$print=true)
{
	$output = isset($value) ? $value : "";
	if($print==false) 
		return $output;	
	else print $output; 	
}


/*
*	returns the appropriate page title based on the object or table type 
*
*/
function get_page_title($type,$plural=false) 
{
	$titles = array(
	'host' => 'Host',
	'service' => 'Service',
	'hosttemplate' => 'Host Template',
	'servicetemplate' => 'Service Template',						
	'contact' => 'Contact',
	'contactgroup' => 'Contact Group',
	'contacttemplate' => 'Contact Template',
	'hostgroup' => 'Host Group',
	'servicegroup' => 'Service Group', 
	'contactgroup' => 'Contact Group',
	'command' => 'Command',
	'timeperiod' => 'Timeperiod',
	'hosttemplate' => 'Host Template',
	'servicetemplate' => 'Service Template',
	'serviceescalation' => 'Service Escalation',
	'hostescalation' => 'Host Escalation',
	'servicedependency' => 'Service Dependency',
	'hostdependency' => 'Host Dependency',
	'user'	=> 'User',

	); 
	//hack
	if($plural) {
		$title['hostdependency'] = 'Host Dependencie';
		$title['servicedependency'] = 'Service Dependencie';
	}
	
	if(isset($titles[$type]))
		return $titles[$type];
}


/**
*	get names for table, name, description based on object $type 
*	@param string $type nagios object type
*	@return mixed $array($table,$name,$description) 
*/
function get_table_and_fields($type) {

	//determine SQL fields that we need to grab for the main table 		
		switch($type)
		{
			case 'host':
			case 'hostgroup':
			case 'servicegroup':
			case 'contact':
			case 'contactgroup':
			case 'timeperiod':				
			//define table and sql args
			$table = 'tbl_'.$type;				
			$typeName = $type.'_name';
			$typeDesc = 'alias';				
			break;
			
			case 'service':
			//define table and sql args
			$table = 'tbl_service';
			$typeName = 'config_name';
			$typeDesc = 'service_description';
			break;
							
			case 'command':
			$table = 'tbl_command';
			$typeName = 'command_name';
			$typeDesc = 'command_line';
			break;	
			
			case 'servicetemplate':
			case 'hosttemplate';
			case 'contacttemplate';
			//define table and sql args
			$table = 'tbl_'.$type;
			$typeName = 'template_name';
			$typeDesc = 'alias';
			if($type=='servicetemplate') $typeDesc='display_name'; 
			break;
			
			
			case 'serviceescalation':
			//define table and sql args
			$table = 'tbl_'.$type; 
			$typeName = 'config_name';
			$typeDesc = 'service_description'; 			
			//return $return_args;
			break;	
			
			case 'hostescalation':
			//define table and sql args
			$table = 'tbl_'.$type; 
			$typeName = 'config_name';
			$typeDesc = 'host_name'; 			
			//return $return_args;
			break;	
			
			case 'hostdependency':
			$table = 'tbl_'.$type; 
			$typeName = 'config_name';
			$typeDesc = 'host_name'; 
			break;
			
			case 'servicedependency':
			$table = 'tbl_'.$type; 
			$typeName = 'config_name';
			$typeDesc = 'service_description'; 			
			//return $return_args;
			break;	
			
			default:
			//show "statical data" for counts 
			//define table and sql args
			echo '<div class="error" style="width:300px; margin:10px auto; text-align:center;">ROUTE VIEW: Invalid object type: '.$type.' specified</div>'; 
			echo default_page();
			die();
				
		}// end $arg switch
		 	
	return array($table,$typeName,$typeDesc); 	
}


/////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////the following functions are written by Ethan Galstad, Nagios Enterprises 
///////////////////////////////////////////////////////////////////////////////////////////////////
// grabs POST and GET variables
/**
*	grabs and preprocesses all GET and POST request variables
*	@author Ethan Galstad 
*
*/
function grab_request_vars($preprocess=true,$type=""){
	global $escape_request_vars;
	global $request;
	
	// do we need to strip slashes?
	$strip=false;
	if((function_exists("get_magic_quotes_gpc") && get_magic_quotes_gpc()) || (ini_get('magic_quotes_sybase') && (strtolower(ini_get('magic_quotes_sybase'))!= "off")))
		$strip=true;
		
	$request=array();

	if($type=="" || $type=="get"){
		foreach ($_GET as $var => $val){
			if($escape_request_vars==true){
				if(is_array($val)){
					$request[$var]=array_map('map_htmlentities',$val);
					}
				else
					$request[$var]=mysql_real_escape_string(htmlentities($val,ENT_QUOTES));
				}
			else
				$request[$var]=$val;
			//echo "GET: $var = \n";
			//print_r($val);
			//echo "<BR>";
			}
		}
	if($type=="" || $type=="post"){
		foreach ($_POST as $var => $val){
			if($escape_request_vars==true){
				if(is_array($val)){
					//echo "PROCESSING ARRAY $var<BR>";
					$request[$var]=array_map('map_htmlentities',$val);
					}
				else
					$request[$var]=mysql_real_escape_string(htmlentities($val,ENT_QUOTES));
				}
			else
				$request[$var]=$val;
			//echo "POST: $var = ";
			//print_r($val);
			//echo "<BR>\n";
			//if(is_array($val)){
			//	echo "ARR=>";
			//	print_r($val);
			//	echo "<BR>";
			//	}
			}
		}
		
	// strip slashes - we escape them later in sql queries
	if($strip==true){
		foreach($request as $var => $val)
			$request[$var]=stripslashes($val);
		}
	
		
	if($preprocess==true)
		preprocess_request_vars();
	}


/**
*	grabs and preprocess a single GET and POST request variable
*	@author Ethan Galstad 
*	@param string $varname the GET or POST variable to grab
*	@param mixed $default set an optional default value for the request var 
*	@return mixed returns either the value found or the default value 
*/
function grab_request_var($varname,$default=""){
	global $request;
	global $escape_request_vars;
	global $request_vars_decoded;
	
	$v=$default;
	if(isset($request[$varname])){
		if($escape_request_vars==true && $request_vars_decoded==false){
			if(is_array($request[$varname])){
				//echo "PROCESSING ARRAY [$varname] =><BR>";
				//print_r($request[$varname]);
				//echo "<BR>";
				$v=array_map('map_htmlentitydecode',$request[$varname]);
				}
			else
				$v=html_entity_decode($request[$varname],ENT_QUOTES);
			}
		else
			$v=$request[$varname];
		}
	//echo "VAR $varname = $v<BR>";
	return $v;
	}

/**
*	grabs and preprocess array variable
*	@author Ethan Galstad 
*	@param string $varname the array index to grab 
*	@param mixed $default set an optional default value for the request var 
*	@return mixed returns either the value found or the default value 
*/
// gets value from array using default
function grab_array_var($arr,$varname,$default=""){
	global $request;
	
	$v=$default;
	if(is_array($arr)){
		if(array_key_exists($varname,$arr))
			$v=$arr[$varname];
		}
	return $v;
	}
	
	
	function decode_request_vars(){
	global $request;
	global $request_vars_decoded;
	
	$newarr=array();
	foreach($request as $var => $val){
		$newarr[$var]=grab_request_var($var);
		}
		
	$request_vars_decoded=true;
		
	$request=$newarr;
	}



/**
*	does nothing at this time 
*/ 
function preprocess_request_vars(){
	global $request;
	
	// set new language
	//if(isset($request['language']))
	//	set_language($request['language']);
	// set new theme
	//if(isset($request['theme']))
	//	set_theme($request['theme']);
	}


// generates a random alpha-numeric string (password or backend ticket)
// @author Ethan Galstad 
function random_string($len=6){
	$chars="023456789abcdefghijklmnopqrstuv";
	$rnd="";
	$charlen=strlen($chars);

	srand((double)microtime()*1000000);
	
	for($x=0;$x<$len;$x++){
		$num=rand()%$charlen;
		$ch=substr($chars,$num,1);
		$rnd.=$ch;
		}
		
	return $rnd;
	}




?>