<?php  //delete_object.php




/** function delete_object() 
*	deletes a single object configuration from the nagiosql database, also removes relations 
*	@param string $table the appropriate object database table
*	@param int $id the object id/primary key for the nagios object 
*	@global object $myDataClass nagiosql data handler
*	@return array array(int $intReturn, string $strMessage) return data for browser output 
*/ 
function delete_object($table,$id) 
{
	global $myDataClass;
	//bail if missing id 
	if(!$id) 
		return "Cannot delete data, no object ID specified!<br />"; 
	
	if($table=='log') $table = 'logbook'; 	

	$strMessage = ''; 
	$intReturn = $myDataClass->dataDeleteFull("tbl_".$table,$id);
	$strMessage .= $myDataClass->strDBMessage;
	//return success or failure message 
	return array($intReturn,$strMessage); 

}



/** function delete_multi() 
*	deletes multiple object configurations from the nagiosql database, also removes relations 
*	@param string $table the appropriate object database table
*	@global array $_REQUEST['checked'] array of $ids of the objects, id/primary key for the nagios object 
*	@return array array(int $intReturn, string $strMessage) return data for browser output 
*/ 
function delete_multi($table)
{
	$checks = grab_request_var('checked',array()); 
	//print_r($checks); 
	//delete all checked objects 
	$failMessage= ''; 
	$itemsDeleted = 0; 
	$itemsFailed = 0; 
	foreach($checks as $c)
	{
		$r = delete_object($table,$c); 
		if($r[0]==0) $itemsDeleted++; 
		else 
		{
			$itemsFailed++; 
			$failMessage .= $r[1]; //append DB return messages 	
		}	
	}	
	
	$intReturn = 0;
	$returnMessage = ''; 
	if($itemsFailed ==0 && $itemsDeleted==0) $returnMessage .= "No items were deleted from the database.<br />"; 
	if ($itemsDeleted > 0) $returnMessage .= $itemsDeleted." items deleted from database<br />"; 
	if($itemsFailed > 0) 
	{
		$returnMessage .= "<strong>".$itemsFailed." items failed to delete.</strong><br />
													Items may have dependent relationships that prevent deletion.<br /> 
													Use the 'info'  button to see all relationships.
													<img src='/nagiosql/images/info.gif' alt='' /><br />   
													$failMessage"; 
		$intReturn = 1; 	
	}	
	//return success or failure message 
	return array($intReturn,$returnMessage); 
}




?>