/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.classloader;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.xbib.classloader.ResourceHandle;
import org.xbib.classloader.ResourceLocation;

public class ResourceEnumeration
implements Enumeration<URL> {
    private Iterator iterator;
    private final String resourceName;
    private URL next;

    public ResourceEnumeration(Collection resourceLocations, String resourceName) {
        this.iterator = resourceLocations.iterator();
        this.resourceName = resourceName;
    }

    @Override
    public boolean hasMoreElements() {
        this.fetchNext();
        return this.next != null;
    }

    @Override
    public URL nextElement() {
        this.fetchNext();
        URL next = this.next;
        this.next = null;
        if (next == null) {
            throw new NoSuchElementException();
        }
        return next;
    }

    private void fetchNext() {
        if (this.iterator == null) {
            return;
        }
        if (this.next != null) {
            return;
        }
        try {
            while (this.iterator.hasNext()) {
                ResourceLocation resourceLocation = (ResourceLocation)this.iterator.next();
                ResourceHandle resourceHandle = resourceLocation.getResourceHandle(this.resourceName);
                if (resourceHandle == null) continue;
                this.next = resourceHandle.getUrl();
                return;
            }
            this.iterator = null;
        }
        catch (IllegalStateException e) {
            this.iterator = null;
            throw e;
        }
    }
}

