/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.classloader.directory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.jar.Manifest;
import org.xbib.classloader.AbstractURLResourceLocation;
import org.xbib.classloader.ResourceHandle;
import org.xbib.classloader.directory.DirectoryResourceHandle;

public class DirectoryResourceLocation
extends AbstractURLResourceLocation {
    private final File baseDir;
    private boolean manifestLoaded = false;
    private Manifest manifest;

    public DirectoryResourceLocation(File baseDir) throws MalformedURLException {
        super(baseDir.toURI().toURL());
        this.baseDir = baseDir;
    }

    @Override
    public ResourceHandle getResourceHandle(String resourceName) {
        File file = new File(this.baseDir, resourceName);
        if (!file.exists() || !this.isLocal(file)) {
            return null;
        }
        try {
            return new DirectoryResourceHandle(resourceName, file, this.baseDir, this.getManifestSafe());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private boolean isLocal(File file) {
        try {
            String base = this.baseDir.getCanonicalPath();
            String relative = file.getCanonicalPath();
            return relative.startsWith(base);
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        if (!this.manifestLoaded) {
            File manifestFile = new File(this.baseDir, "META-INF/MANIFEST.MF");
            if (manifestFile.isFile() && manifestFile.canRead()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(manifestFile);
                    this.manifest = new Manifest(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.manifestLoaded = true;
        }
        return this.manifest;
    }

    private Manifest getManifestSafe() {
        Manifest m = null;
        try {
            m = this.getManifest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return m;
    }
}

