/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.classloader.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarFileUrlConnection
extends JarURLConnection {
    public static final URL DUMMY_JAR_URL;
    private final URL url;
    private final JarFile jarFile;
    private final JarEntry jarEntry;
    private final URL jarFileUrl;

    public JarFileUrlConnection(URL url, JarFile jarFile, JarEntry jarEntry) throws MalformedURLException {
        super(DUMMY_JAR_URL);
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        if (jarFile == null) {
            throw new NullPointerException("jarFile is null");
        }
        if (jarEntry == null) {
            throw new NullPointerException("jarEntry is null");
        }
        this.url = url;
        this.jarFile = jarFile;
        this.jarEntry = jarEntry;
        this.jarFileUrl = new File(jarFile.getName()).toURI().toURL();
    }

    @Override
    public JarFile getJarFile() throws IOException {
        if (this.getUseCaches()) {
            return this.jarFile;
        }
        return new JarFile(this.jarFile.getName());
    }

    @Override
    public synchronized void connect() {
    }

    @Override
    public URL getJarFileURL() {
        return this.jarFileUrl;
    }

    @Override
    public String getEntryName() {
        return this.getJarEntry().getName();
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    @Override
    public JarEntry getJarEntry() {
        if (this.getUseCaches()) {
            return this.jarEntry;
        }
        return this.jarFile.getJarEntry(this.jarEntry.getName());
    }

    @Override
    public Attributes getAttributes() throws IOException {
        return this.getJarEntry().getAttributes();
    }

    @Override
    public Attributes getMainAttributes() throws IOException {
        return this.getManifest().getMainAttributes();
    }

    @Override
    public Certificate[] getCertificates() throws IOException {
        return this.getJarEntry().getCertificates();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public int getContentLength() {
        long size = this.getJarEntry().getSize();
        if (size > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)size;
    }

    @Override
    public long getLastModified() {
        return this.getJarEntry().getTime();
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        return this.jarFile.getInputStream(this.jarEntry);
    }

    @Override
    public Permission getPermission() throws IOException {
        URL jarFileUrl = new File(this.jarFile.getName()).toURI().toURL();
        return jarFileUrl.openConnection().getPermission();
    }

    @Override
    public String toString() {
        return JarFileUrlConnection.class.getName() + ":" + this.url;
    }

    static {
        try {
            DUMMY_JAR_URL = new URL("jar", "", -1, "file:dummy!/", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

