/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.classloader.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.xbib.classloader.AbstractResourceHandle;
import org.xbib.classloader.AbstractURLResourceLocation;
import org.xbib.classloader.ResourceHandle;
import org.xbib.classloader.jar.JarResourceHandle;

public class JarResourceLocation
extends AbstractURLResourceLocation {
    private JarFile jarFile;
    private byte[] content;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarResourceLocation(URL codeSource, File cacheFile) throws IOException {
        super(codeSource);
        try {
            this.jarFile = new JarFile(cacheFile);
        }
        catch (ZipException ze) {
            try (FileInputStream is = null;){
                int bytesRead;
                is = new FileInputStream(cacheFile);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                this.content = baos.toByteArray();
            }
        }
    }

    @Override
    public ResourceHandle getResourceHandle(String resourceName) {
        if (this.jarFile != null) {
            JarEntry jarEntry = this.jarFile.getJarEntry(resourceName);
            if (jarEntry != null) {
                try {
                    return new JarResourceHandle(this.jarFile, jarEntry, this.getCodeSource());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                JarEntry jarEntry;
                JarInputStream is = new JarInputStream(new ByteArrayInputStream(this.content));
                while ((jarEntry = is.getNextJarEntry()) != null) {
                    if (!jarEntry.getName().equals(resourceName)) continue;
                    try {
                        return new JarEntryResourceHandle(jarEntry, is);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Manifest getManifest() throws IOException {
        if (this.jarFile != null) {
            return this.jarFile.getManifest();
        }
        try {
            JarInputStream is = new JarInputStream(new ByteArrayInputStream(this.content));
            return is.getManifest();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() {
        if (this.jarFile != null) {
            try {
                this.jarFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class JarEntryResourceHandle
    extends AbstractResourceHandle {
        private final JarEntry jarEntry2;
        private final JarInputStream is;

        public JarEntryResourceHandle(JarEntry jarEntry2, JarInputStream is) {
            this.jarEntry2 = jarEntry2;
            this.is = is;
        }

        @Override
        public String getName() {
            return this.jarEntry2.getName();
        }

        @Override
        public URL getUrl() {
            try {
                return new URL("jar", "", -1, JarResourceLocation.this.getCodeSource() + "!/" + this.jarEntry2.getName());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isDirectory() {
            return this.jarEntry2.isDirectory();
        }

        @Override
        public URL getCodeSourceUrl() {
            return JarResourceLocation.this.getCodeSource();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.is;
        }

        @Override
        public int getContentLength() {
            return (int)this.jarEntry2.getSize();
        }
    }
}

