/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.classloader.uri;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.xbib.classloader.ResourceHandle;
import org.xbib.classloader.uri.URIResourceFinder;

public final class URIClassLoader
extends URLClassLoader {
    private final URIResourceFinder finder = new URIResourceFinder();
    private final AccessControlContext acc = AccessController.getContext();

    public URIClassLoader() {
        this((ClassLoader)null);
    }

    public URIClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public URIClassLoader addURI(URI uri) {
        this.finder.addURI(uri);
        return this;
    }

    public URI[] getURIs() {
        return this.finder.getURIs();
    }

    @Override
    @Deprecated
    protected void addURL(URL url) {
        try {
            this.finder.addURI(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    ResourceHandle h = URIClassLoader.this.finder.getResource(path);
                    if (h != null) {
                        try {
                            return URIClassLoader.this.defineClass(name, h);
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    throw new ClassNotFoundException(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    @Override
    public URL findResource(final String name) {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URIClassLoader.this.finder.findResource(name);
            }
        }, this.acc);
    }

    @Override
    public Enumeration<URL> findResources(final String name) throws IOException {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URIClassLoader.this.finder.findResources(name);
            }
        }, this.acc);
    }

    @Override
    protected String findLibrary(String libname) {
        ResourceHandle md = this.getLibraryHandle(libname);
        if (md == null) {
            return null;
        }
        URL url = md.getUrl();
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        return new File(URI.create(url.toString())).getPath();
    }

    private ResourceHandle getResourceHandle(final String name) {
        return (ResourceHandle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URIClassLoader.this.finder.getResource(name);
            }
        }, this.acc);
    }

    private ResourceHandle getLibraryHandle(String name) {
        String simplename;
        String path;
        int idx = name.lastIndexOf(47);
        if (idx == -1) {
            path = "";
            simplename = name;
        } else {
            if (idx == name.length() - 1) {
                throw new IllegalArgumentException(name);
            }
            path = name.substring(0, idx + 1);
            simplename = name.substring(idx + 1);
        }
        return this.getResourceHandle(path + System.mapLibraryName(simplename));
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    private Class defineClass(String name, ResourceHandle h) throws IOException {
        int i = name.lastIndexOf(46);
        URL url = h.getCodeSourceUrl();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = h.getManifest();
            if (pkg != null) {
                boolean ok;
                if (pkg.isSealed()) {
                    ok = pkg.isSealed(url);
                } else {
                    boolean bl = ok = man == null || !this.isSealed(pkgname, man);
                }
                if (!ok) {
                    throw new SecurityException("sealing violation: " + name);
                }
            } else if (man != null) {
                this.definePackage(pkgname, man, url);
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        byte[] b = h.getBytes();
        Certificate[] certs = h.getCertificates();
        CodeSource cs = new CodeSource(url, certs);
        return this.defineClass(name, b, 0, b.length, cs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassLoader:");
        for (URI uri : this.getURIs()) {
            sb.append("[").append(uri).append("]");
        }
        return sb.toString();
    }
}

