/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.classloader.uri;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.xbib.classloader.ResourceEnumeration;
import org.xbib.classloader.ResourceFinder;
import org.xbib.classloader.ResourceHandle;
import org.xbib.classloader.ResourceLocation;
import org.xbib.classloader.directory.DirectoryResourceLocation;
import org.xbib.classloader.jar.JarResourceLocation;

public class URIResourceFinder
implements ResourceFinder {
    private final Object lock = new Object();
    private final Set<URI> uris = new LinkedHashSet<URI>();
    private final Map<URI, ResourceLocation> classPath = new LinkedHashMap<URI, ResourceLocation>();
    private final Set<File> watchedFiles = new LinkedHashSet<File>();
    private boolean destroyed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            this.uris.clear();
            for (ResourceLocation resourceLocation : this.classPath.values()) {
                resourceLocation.close();
            }
            this.classPath.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceHandle getResource(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return null;
            }
            Map<URI, ResourceLocation> path = this.getClassPath();
            for (Map.Entry<URI, ResourceLocation> entry : path.entrySet()) {
                ResourceLocation resourceLocation = entry.getValue();
                ResourceHandle resourceHandle = resourceLocation.getResourceHandle(resourceName);
                if (resourceHandle == null || resourceHandle.isDirectory()) continue;
                return resourceHandle;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return null;
            }
            for (Map.Entry<URI, ResourceLocation> entry : this.getClassPath().entrySet()) {
                ResourceLocation resourceLocation = entry.getValue();
                ResourceHandle resourceHandle = resourceLocation.getResourceHandle(resourceName);
                if (resourceHandle == null) continue;
                return resourceHandle.getUrl();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            return new ResourceEnumeration(new ArrayList<ResourceLocation>(this.getClassPath().values()), resourceName);
        }
    }

    public void addURI(URI uri) {
        this.add(Arrays.asList(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI[] getURIs() {
        Object object = this.lock;
        synchronized (object) {
            return this.uris.toArray(new URI[this.uris.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(List<URI> uris) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                throw new IllegalStateException("UriResourceFinder has been destroyed");
            }
            boolean shouldRebuild = this.uris.addAll(uris);
            if (shouldRebuild) {
                this.rebuildClassPath();
            }
        }
    }

    private Map<URI, ResourceLocation> getClassPath() {
        assert (Thread.holdsLock(this.lock)) : "This method can only be called while holding the lock";
        for (File file : this.watchedFiles) {
            if (!file.canRead()) continue;
            this.rebuildClassPath();
            break;
        }
        return this.classPath;
    }

    private void rebuildClassPath() {
        assert (Thread.holdsLock(this.lock)) : "This method can only be called while holding the lock";
        LinkedHashMap<URI, ResourceLocation> existingJarFiles = new LinkedHashMap<URI, ResourceLocation>(this.classPath);
        this.classPath.clear();
        LinkedList<URI> locationStack = new LinkedList<URI>(this.uris);
        try {
            while (!locationStack.isEmpty()) {
                URI uri = locationStack.removeFirst();
                if (this.classPath.containsKey(uri)) continue;
                ResourceLocation resourceLocation = (ResourceLocation)existingJarFiles.remove(uri);
                if (resourceLocation == null) {
                    try {
                        resourceLocation = this.createResourceLocation(uri.toURL(), this.cacheUri(uri));
                    }
                    catch (FileNotFoundException e) {
                        if ("file".equals(uri.getScheme())) {
                            File file = new File(uri.getPath());
                            this.watchedFiles.add(file);
                            continue;
                        }
                    }
                    catch (IOException ignored) {
                        continue;
                    }
                    catch (UnsupportedOperationException ex) {
                        continue;
                    }
                }
                try {
                    if (resourceLocation != null && resourceLocation.getCodeSource() != null) {
                        this.classPath.put(resourceLocation.getCodeSource().toURI(), resourceLocation);
                    }
                }
                catch (URISyntaxException ex) {
                    // empty catch block
                }
                List<URI> manifestClassPath = this.getManifestClassPath(resourceLocation);
                locationStack.addAll(0, manifestClassPath);
            }
        }
        catch (Error e) {
            this.destroy();
            throw e;
        }
        for (ResourceLocation resourceLocation : existingJarFiles.values()) {
            resourceLocation.close();
        }
    }

    protected File cacheUri(URI uri) throws IOException {
        if (!"file".equals(uri.getScheme())) {
            throw new UnsupportedOperationException("Only local file jars are supported " + uri);
        }
        File file = new File(uri.getPath());
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("File is not readable: " + file.getAbsolutePath());
        }
        return file;
    }

    protected ResourceLocation createResourceLocation(URL codeSource, File cacheFile) throws IOException {
        if (!cacheFile.exists()) {
            throw new FileNotFoundException(cacheFile.getAbsolutePath());
        }
        if (!cacheFile.canRead()) {
            throw new IOException("File is not readable: " + cacheFile.getAbsolutePath());
        }
        return cacheFile.isDirectory() ? new DirectoryResourceLocation(cacheFile) : new JarResourceLocation(codeSource, cacheFile);
    }

    private List<URI> getManifestClassPath(ResourceLocation resourceLocation) {
        LinkedList<URI> classPathUrls = new LinkedList<URI>();
        try {
            Manifest manifest = resourceLocation.getManifest();
            if (manifest == null) {
                return classPathUrls;
            }
            String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (manifestClassPath == null) {
                return classPathUrls;
            }
            URL codeSource = resourceLocation.getCodeSource();
            StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken();
                try {
                    URL entryUrl = new URL(codeSource, entry);
                    classPathUrls.add(entryUrl.toURI());
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return classPathUrls;
        }
        catch (IOException ignored) {
            return classPathUrls;
        }
    }
}

