/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.abort;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.xbib.elasticsearch.action.knapsack.abort.KnapsackAbortAction;
import org.xbib.elasticsearch.action.knapsack.abort.KnapsackAbortRequest;
import org.xbib.elasticsearch.action.knapsack.abort.KnapsackAbortResponse;
import org.xbib.elasticsearch.knapsack.KnapsackService;

public class TransportKnapsackAbortAction
extends TransportAction<KnapsackAbortRequest, KnapsackAbortResponse> {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)KnapsackAbortAction.class.getSimpleName());
    private final KnapsackService knapsack;

    @Inject
    public TransportKnapsackAbortAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, KnapsackService knapsack) {
        super(settings, "org.xbib.elasticsearch.knapsack.abort", threadPool, actionFilters);
        this.knapsack = knapsack;
    }

    protected void doExecute(KnapsackAbortRequest request, ActionListener<KnapsackAbortResponse> listener) {
        KnapsackAbortResponse response = new KnapsackAbortResponse();
        try {
            int aborted = this.knapsack.abort();
            response.setAbortedTasks(aborted);
            listener.onResponse((Object)response);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
            listener.onFailure(e);
        }
    }
}

