/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.exp;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.xbib.elasticsearch.knapsack.KnapsackRequest;

public class KnapsackExportRequest
extends SingleCustomOperationRequest<KnapsackExportRequest>
implements KnapsackRequest {
    private Path path;
    private TimeValue timeout;
    private int limit;
    private Map<String, Object> indexTypeNames = Maps.newHashMap();
    private String index = "_all";
    private String type;
    private SearchRequest searchRequest;
    private boolean withMetadata;
    private boolean overwrite;
    private boolean encodeEntry;
    private boolean withAliases;
    private ByteSizeValue bytesToTransfer = ByteSizeValue.parseBytesSizeValue((String)"0");

    @Override
    public String getCluster() {
        return null;
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public TimeValue getTimeout() {
        return null;
    }

    @Override
    public boolean getSniff() {
        return false;
    }

    public KnapsackExportRequest setPath(Path path) {
        this.path = path;
        return this;
    }

    public Path getPath() {
        return this.path;
    }

    public KnapsackExportRequest setIndex(String index) {
        this.index = index;
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public KnapsackExportRequest setType(String type) {
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public KnapsackExportRequest setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public KnapsackExportRequest setIndexTypeNames(Map<String, Object> indexTypeNames) {
        this.indexTypeNames = indexTypeNames;
        return this;
    }

    @Override
    public Map<String, Object> getIndexTypeNames() {
        return this.indexTypeNames;
    }

    public KnapsackExportRequest setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        return this;
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public KnapsackExportRequest setBytesToTransfer(ByteSizeValue bytesToTransfer) {
        this.bytesToTransfer = bytesToTransfer;
        return this;
    }

    public ByteSizeValue getBytesToTransfer() {
        return this.bytesToTransfer;
    }

    public KnapsackExportRequest withMetadata(boolean withMetadata) {
        this.withMetadata = withMetadata;
        return this;
    }

    public boolean isWithMetadata() {
        return this.withMetadata;
    }

    public KnapsackExportRequest setOverwriteAllowed(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public boolean isOverwriteAllowed() {
        return this.overwrite;
    }

    public KnapsackExportRequest setEncodeEntry(boolean encodeEntry) {
        this.encodeEntry = encodeEntry;
        return this;
    }

    public boolean isEncodeEntry() {
        return this.encodeEntry;
    }

    public KnapsackExportRequest withAliases(boolean withAliases) {
        this.withAliases = withAliases;
        return this;
    }

    public boolean isWithAliases() {
        return this.withAliases;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.path.toUri().toString());
        if (this.timeout != null) {
            out.writeBoolean(true);
            this.timeout.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.limit);
        out.writeMap(this.indexTypeNames);
        out.writeBoolean(this.withMetadata);
        out.writeBoolean(this.overwrite);
        out.writeBoolean(this.encodeEntry);
        out.writeBoolean(this.withAliases);
        out.writeString(this.index);
        out.writeString(this.type);
        if (this.searchRequest != null) {
            out.writeBoolean(true);
            this.searchRequest.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        this.bytesToTransfer.writeTo(out);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.path = Paths.get(URI.create(in.readString()));
        if (in.readBoolean()) {
            this.timeout = TimeValue.readTimeValue((StreamInput)in);
        }
        this.limit = in.readInt();
        this.indexTypeNames = in.readMap();
        this.withMetadata = in.readBoolean();
        this.overwrite = in.readBoolean();
        this.encodeEntry = in.readBoolean();
        this.withAliases = in.readBoolean();
        this.index = in.readString();
        this.type = in.readString();
        if (in.readBoolean()) {
            this.searchRequest = new SearchRequest();
            this.searchRequest.readFrom(in);
        }
        this.bytesToTransfer.readFrom(in);
    }
}

