/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.exp;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.threadpool.ThreadPool;
import org.xbib.elasticsearch.action.knapsack.exp.KnapsackExportAction;
import org.xbib.elasticsearch.action.knapsack.exp.KnapsackExportRequest;
import org.xbib.elasticsearch.action.knapsack.exp.KnapsackExportResponse;
import org.xbib.elasticsearch.knapsack.KnapsackHelper;
import org.xbib.elasticsearch.knapsack.KnapsackService;
import org.xbib.elasticsearch.knapsack.KnapsackState;
import org.xbib.io.BytesProgressWatcher;
import org.xbib.io.Session;
import org.xbib.io.StringPacket;
import org.xbib.io.archive.ArchiveService;
import org.xbib.io.archive.ArchiveSession;
import org.xbib.io.archive.esbulk.EsBulkSession;

public class TransportKnapsackExportAction
extends TransportAction<KnapsackExportRequest, KnapsackExportResponse> {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)KnapsackExportAction.class.getSimpleName());
    private final SettingsFilter settingsFilter;
    private final Client client;
    private final NodeService nodeService;
    private final KnapsackService knapsack;

    @Inject
    public TransportKnapsackExportAction(Settings settings, ThreadPool threadPool, SettingsFilter settingsFilter, Client client, NodeService nodeService, ActionFilters actionFilters, KnapsackService knapsack) {
        super(settings, "org.xbib.elasticsearch.knapsack.export", threadPool, actionFilters);
        this.settingsFilter = settingsFilter;
        this.client = client;
        this.nodeService = nodeService;
        this.knapsack = knapsack;
    }

    protected void doExecute(final KnapsackExportRequest request, ActionListener<KnapsackExportResponse> listener) {
        final KnapsackState state = new KnapsackState().setMode("export").setNodeName(this.nodeService.nodeName());
        KnapsackExportResponse response = new KnapsackExportResponse().setState(state);
        try {
            Path path = request.getPath();
            if (path == null) {
                path = new File("_all.tar.gz").toPath();
            }
            ByteSizeValue bytesToTransfer = request.getBytesToTransfer();
            BytesProgressWatcher watcher = new BytesProgressWatcher(bytesToTransfer.bytes());
            final ArchiveSession session = ArchiveService.newSession(path, watcher);
            EnumSet<Session.Mode> mode = EnumSet.of(request.isOverwriteAllowed() ? Session.Mode.OVERWRITE : Session.Mode.WRITE, request.isEncodeEntry() ? Session.Mode.URI_ENCODED : Session.Mode.NONE);
            session.open(mode, path, path.toFile());
            if (session.isOpen()) {
                state.setPath(path).setTimestamp(new DateTime());
                response.setRunning(true);
                this.knapsack.submit(new Thread(){

                    @Override
                    public void run() {
                        TransportKnapsackExportAction.this.performExport(request, state, session);
                    }
                });
                this.knapsack.addExport(this.client, state);
            } else {
                response.setRunning(false).setReason("session can not be opened: mode=" + mode + " path=" + path);
            }
            listener.onResponse((Object)response);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
            listener.onFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void performExport(KnapsackExportRequest request, KnapsackState state, ArchiveSession session) {
        try {
            SearchRequest searchRequest;
            logger.info("start of export: {}", new Object[]{state});
            HashMap indices = Maps.newHashMap();
            for (String string : Strings.commaDelimitedListToSet((String)request.getIndex())) {
                indices.put(string, Strings.commaDelimitedListToSet((String)request.getType()));
            }
            if (request.isWithMetadata() && !(session instanceof EsBulkSession)) {
                if (request.getIndexTypeNames() != null) {
                    for (Object object : request.getIndexTypeNames().keySet()) {
                        String type;
                        if (object == null) continue;
                        String[] s = object.toString().split("/");
                        String index = s[0];
                        String string = type = s.length > 1 ? s[1] : null;
                        if ("_all".equals(index)) continue;
                        Set types = (Set)indices.get(index);
                        if (types == null) {
                            types = Sets.newHashSet();
                        }
                        if (type != null) {
                            types.add(type);
                        }
                        indices.put(index, types);
                    }
                }
                logger.info("getting settings for indices {}", new Object[]{indices.keySet()});
                HashSet settingsIndices = Sets.newHashSet(indices.keySet());
                settingsIndices.remove("_all");
                Map<String, String> map = KnapsackHelper.getSettings(this.client, this.settingsFilter, settingsIndices.toArray(new String[settingsIndices.size()]));
                logger.info("found indices: {}", new Object[]{map.keySet()});
                for (String index : map.keySet()) {
                    CreateIndexRequest createIndexRequest = Requests.createIndexRequest((String)KnapsackHelper.mapIndex(request, index));
                    StringPacket packet = new StringPacket();
                    packet.meta("index", KnapsackHelper.mapIndex(request, index));
                    packet.meta("type", "_settings");
                    packet.payload(map.get(index));
                    session.write(packet);
                    Set types = (Set)indices.get(index);
                    createIndexRequest.settings(map.get(index));
                    logger.info("getting mappings for index {} and types {}", new Object[]{index, types});
                    Map<String, String> mappings = KnapsackHelper.getMapping(this.client, index, (Set<String>)(types != null ? ImmutableSet.copyOf((Collection)types) : null));
                    logger.info("found mappings: {}", new Object[]{mappings.keySet()});
                    for (String type : mappings.keySet()) {
                        packet = new StringPacket();
                        packet.meta("index", KnapsackHelper.mapIndex(request, index));
                        packet.meta("type", KnapsackHelper.mapType(request, index, type));
                        packet.meta("id", "_mapping");
                        packet.payload(mappings.get(type));
                        session.write(packet);
                        logger.info("adding mapping: {}", new Object[]{KnapsackHelper.mapType(request, index, type)});
                        createIndexRequest.mapping(KnapsackHelper.mapType(request, index, type), mappings.get(type));
                    }
                    if (!request.isWithAliases()) continue;
                    logger.info("getting aliases for index {}", new Object[]{index});
                    Map<String, String> aliases = KnapsackHelper.getAliases(this.client, index);
                    logger.info("found {} aliases", new Object[]{aliases.size()});
                    for (String alias : aliases.keySet()) {
                        packet = new StringPacket();
                        packet.meta("index", KnapsackHelper.mapIndex(request, index));
                        packet.meta("type", alias);
                        packet.meta("id", "_alias");
                        packet.payload(aliases.get(alias));
                        session.write(packet);
                    }
                }
            }
            if ((searchRequest = request.getSearchRequest()) == null) {
                searchRequest = new SearchRequestBuilder(this.client).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).request();
            }
            for (String index : indices.keySet()) {
                long hits;
                Set types;
                searchRequest.searchType(SearchType.SCAN).scroll(request.getTimeout());
                if (!"_all".equals(index)) {
                    searchRequest.indices(new String[]{index});
                }
                if ((types = (Set)indices.get(index)) != null) {
                    searchRequest.types(types.toArray(new String[types.size()]));
                }
                SearchResponse searchResponse = (SearchResponse)this.client.search(searchRequest).actionGet();
                long total = 0L;
                while (searchResponse.getScrollId() != null && !Thread.interrupted() && (hits = (long)(searchResponse = (SearchResponse)this.client.prepareSearchScroll(searchResponse.getScrollId()).setScroll(request.getTimeout()).execute().actionGet()).getHits().getHits().length) != 0L) {
                    logger.debug("total={} hits={} took={}", new Object[]{total += hits, hits, searchResponse.getTookInMillis()});
                    for (SearchHit hit : searchResponse.getHits()) {
                        for (String f : hit.getFields().keySet()) {
                            StringPacket packet = new StringPacket();
                            packet.meta("index", KnapsackHelper.mapIndex(request, hit.getIndex()));
                            packet.meta("type", KnapsackHelper.mapType(request, hit.getIndex(), hit.getType()));
                            packet.meta("id", hit.getId());
                            packet.meta("field", f);
                            packet.payload(((SearchHitField)hit.getFields().get(f)).getValue().toString());
                            session.write(packet);
                        }
                        if (hit.getFields().keySet().contains("_source")) continue;
                        StringPacket packet = new StringPacket();
                        packet.meta("index", KnapsackHelper.mapIndex(request, hit.getIndex()));
                        packet.meta("type", KnapsackHelper.mapType(request, hit.getIndex(), hit.getType()));
                        packet.meta("id", hit.getId());
                        packet.meta("field", "_source");
                        packet.payload(hit.getSourceAsString());
                        session.write(packet);
                    }
                }
            }
            session.close();
            logger.info("end of export: {}, packets = {}, total bytes transferred = {}, rate = {}", new Object[]{state, session.getPacketCounter(), session.getWatcher().getTotalBytesInAllTransfers(), String.format("%f", session.getWatcher().getRecentByteRatePerSecond())});
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
        }
        finally {
            try {
                this.knapsack.removeExport(this.client, state);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
    }
}

