/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.imp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.threadpool.ThreadPool;
import org.xbib.elasticsearch.action.knapsack.imp.KnapsackImportAction;
import org.xbib.elasticsearch.action.knapsack.imp.KnapsackImportRequest;
import org.xbib.elasticsearch.action.knapsack.imp.KnapsackImportResponse;
import org.xbib.elasticsearch.knapsack.KnapsackHelper;
import org.xbib.elasticsearch.knapsack.KnapsackService;
import org.xbib.elasticsearch.knapsack.KnapsackState;
import org.xbib.elasticsearch.support.client.Ingest;
import org.xbib.elasticsearch.support.client.node.BulkNodeClient;
import org.xbib.io.BytesProgressWatcher;
import org.xbib.io.Session;
import org.xbib.io.StringPacket;
import org.xbib.io.archive.ArchiveService;
import org.xbib.io.archive.ArchiveSession;

public class TransportKnapsackImportAction
extends TransportAction<KnapsackImportRequest, KnapsackImportResponse> {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)KnapsackImportAction.class.getSimpleName());
    private final Client client;
    private final NodeService nodeService;
    private final KnapsackService knapsack;

    @Inject
    public TransportKnapsackImportAction(Settings settings, ThreadPool threadPool, Client client, NodeService nodeService, ActionFilters actionFilters, KnapsackService knapsack) {
        super(settings, "org.xbib.elasticsearch.knapsack.import", threadPool, actionFilters);
        this.client = client;
        this.nodeService = nodeService;
        this.knapsack = knapsack;
    }

    protected void doExecute(final KnapsackImportRequest request, ActionListener<KnapsackImportResponse> listener) {
        final KnapsackState state = new KnapsackState().setMode("import").setNodeName(this.nodeService.nodeName());
        KnapsackImportResponse response = new KnapsackImportResponse().setState(state);
        try {
            Path path = request.getPath();
            if (path == null) {
                path = new File("_all.tar.gz").toPath();
            }
            ByteSizeValue bytesToTransfer = request.getBytesToTransfer();
            BytesProgressWatcher watcher = new BytesProgressWatcher(bytesToTransfer.bytes());
            final ArchiveSession session = ArchiveService.newSession(path, watcher);
            EnumSet<Session.Mode> mode = EnumSet.of(Session.Mode.READ, request.isDecodeEntry() ? Session.Mode.URI_ENCODED : Session.Mode.NONE);
            session.open(mode, path, path.toFile());
            if (session.isOpen()) {
                final BulkNodeClient bulkClient = new BulkNodeClient();
                bulkClient.flushIngestInterval(TimeValue.timeValueSeconds((long)5L)).maxActionsPerBulkRequest(request.getMaxActionsPerBulkRequest()).maxConcurrentBulkRequests(request.getMaxBulkConcurrency()).newClient(this.client);
                state.setTimestamp(new DateTime()).setPath(path);
                response.setRunning(true);
                this.knapsack.submit(new Thread(){

                    @Override
                    public void run() {
                        TransportKnapsackImportAction.this.performImport(request, state, session, bulkClient);
                    }
                });
                this.knapsack.addImport(this.client, state);
            } else {
                response.setRunning(false).setReason("session can not be opened: mode=" + mode + " path=" + path);
            }
            listener.onResponse((Object)response);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
            listener.onFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void performImport(KnapsackImportRequest request, KnapsackState state, Session<StringPacket> session, Ingest bulkClient) {
        try {
            StringPacket packet;
            logger.info("start of import: {}", new Object[]{state});
            HashMap indexRequestMap = Maps.newHashMap();
            HashSet indexCreated = Sets.newHashSet();
            HashMap indexReplicaMap = Maps.newHashMap();
            HashMap aliasRequestMap = Maps.newHashMap();
            LinkedHashMap packets = Maps.newLinkedHashMap();
            String lastCoord = null;
            long count = 0L;
            while ((packet = session.read()) != null && !Thread.interrupted()) {
                CreateIndexRequest createIndexRequest;
                InputStreamReader reader;
                ++count;
                String index = (String)packet.meta().get("index");
                String type = (String)packet.meta().get("type");
                String id = (String)packet.meta().get("id");
                String field = (String)packet.meta().get("field");
                if (field == null) {
                    field = "_source";
                }
                if ("_settings".equals(type)) {
                    String settingsStr;
                    if (request.hasIndexSettings(index = KnapsackHelper.mapIndex(request, index))) {
                        reader = new InputStreamReader((InputStream)new FileInputStream(request.getIndexSettings(index)), "UTF-8");
                        settingsStr = Streams.copyToString((Reader)reader);
                        reader.close();
                    } else {
                        settingsStr = packet.payload();
                    }
                    if ("_all".equals(index)) continue;
                    logger.info("index {}: found settings {}", new Object[]{index, settingsStr});
                    createIndexRequest = (CreateIndexRequest)indexRequestMap.get(index);
                    if (createIndexRequest == null) {
                        createIndexRequest = Requests.createIndexRequest((String)index);
                        indexRequestMap.put(index, createIndexRequest);
                    }
                    ImmutableSettings.Builder indexSettingsBuilder = ImmutableSettings.settingsBuilder().loadFromSource(settingsStr);
                    indexReplicaMap.put(index, indexSettingsBuilder.get("index.number_of_replicas"));
                    Settings indexSettings = indexSettingsBuilder.put("index.refresh_interval", -1).put("index.number_of_replicas", 0).build();
                    logger.info("switching index {} for bulk indexing: {}", new Object[]{index, indexSettings.getAsMap()});
                    createIndexRequest.settings(indexSettings);
                    continue;
                }
                if ("_mapping".equals(id)) {
                    String mapping;
                    type = KnapsackHelper.mapType(request, index, type);
                    if (request.hasIndexTypeMapping(index = KnapsackHelper.mapIndex(request, index), type)) {
                        reader = new InputStreamReader((InputStream)new FileInputStream(request.getIndexTypeMapping(index, type)), "UTF-8");
                        mapping = Streams.copyToString((Reader)reader);
                        reader.close();
                    } else {
                        mapping = packet.payload();
                    }
                    if ("_all".equals(index)) continue;
                    logger.info("index {}: found mapping {}", new Object[]{index, mapping});
                    createIndexRequest = (CreateIndexRequest)indexRequestMap.get(index);
                    if (createIndexRequest == null) {
                        createIndexRequest = Requests.createIndexRequest((String)index);
                        indexRequestMap.put(index, createIndexRequest);
                    }
                    createIndexRequest.mapping(type, mapping);
                    continue;
                }
                if ("_alias".equals(id)) {
                    Map aliases = Maps.newHashMap();
                    if (aliasRequestMap.containsKey(index)) {
                        aliases = (Map)aliasRequestMap.get(index);
                    }
                    aliases.put(type, packet.payload());
                    aliasRequestMap.put(index, aliases);
                    continue;
                }
                if (index == null || type == null || id == null || packet.payload() == null || type.startsWith(".") || id.startsWith(".")) continue;
                String coord = index + File.separator + type + File.separator + id;
                if (!coord.equals(lastCoord) && !packets.isEmpty()) {
                    this.indexPackets(bulkClient, indexRequestMap, indexCreated, aliasRequestMap, request, packets);
                    packets.clear();
                }
                packets.put(field, packet);
                lastCoord = coord;
            }
            if (!packets.isEmpty()) {
                this.indexPackets(bulkClient, indexRequestMap, indexCreated, aliasRequestMap, request, packets);
            }
            bulkClient.flushIngest();
            bulkClient.waitForResponses(TimeValue.timeValueSeconds((long)60L));
            for (String index : indexReplicaMap.keySet()) {
                try {
                    logger.info("resetting refresh rate for index {}", new Object[]{index});
                    bulkClient.stopBulk(index);
                    Integer replica = Integer.parseInt((String)indexReplicaMap.get(index));
                    logger.info("resetting replica level {} for index {}", new Object[]{replica, index});
                    bulkClient.updateReplicaLevel(index, replica);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e, new Object[0]);
                }
            }
            for (String index : indexCreated) {
                bulkClient.refresh(index);
            }
            bulkClient.shutdown();
            logger.info("end of import: {}, count = {}", new Object[]{state, count});
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
        }
        finally {
            try {
                this.knapsack.removeImport(this.client, state);
                session.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
    }

    private void indexPackets(Ingest bulkClient, Map<String, CreateIndexRequest> indexRequestMap, Set<String> indexCreated, Map<String, Map<String, String>> aliasRequestMap, KnapsackImportRequest request, Map<String, StringPacket> packets) {
        StringPacket packet = packets.values().iterator().next();
        String index = (String)packet.meta().get("index");
        String type = (String)packet.meta().get("type");
        String id = (String)packet.meta().get("id");
        if (indexRequestMap.containsKey(index)) {
            CreateIndexRequest createIndexRequest = indexRequestMap.remove(index);
            if (request.withMetadata()) {
                logger.info("creating index {}", new Object[]{index});
                createIndexRequest.timeout(request.getTimeout());
                try {
                    CreateIndexResponse response = (CreateIndexResponse)bulkClient.client().admin().indices().create(createIndexRequest).actionGet();
                    if (!response.isAcknowledged()) {
                        logger.warn("index creation was not acknowledged", new Object[0]);
                    }
                    indexCreated.add(index);
                }
                catch (IndexAlreadyExistsException e) {
                    logger.warn("index already exists: {}", new Object[]{index});
                }
            }
        } else {
            indexCreated.add(index);
        }
        if (aliasRequestMap.containsKey(index)) {
            Map<String, String> aliases = aliasRequestMap.remove(index);
            if (request.withMetadata()) {
                IndicesAliasesRequestBuilder requestBuilder = bulkClient.client().admin().indices().prepareAliases();
                for (String alias : aliases.keySet()) {
                    requestBuilder.addAlias(index, alias, aliases.get(alias));
                }
                logger.info("creating {} aliases for index {}", new Object[]{aliases.size(), index});
                requestBuilder.execute().actionGet();
            }
        }
        IndexRequest indexRequest = new IndexRequest(KnapsackHelper.mapIndex(request, index), KnapsackHelper.mapType(request, index, type), id);
        block17: for (String f : packets.keySet()) {
            if (f == null) continue;
            String o = packets.get(f).payload();
            if (o == null) {
                logger.error("empty payload detected", new Object[0]);
                continue;
            }
            String payload = o.toString();
            switch (f) {
                case "_parent": {
                    indexRequest.parent(payload);
                    continue block17;
                }
                case "_routing": {
                    indexRequest.routing(payload);
                    continue block17;
                }
                case "_timestamp": {
                    indexRequest.timestamp(payload);
                    continue block17;
                }
                case "_version": {
                    indexRequest.versionType(VersionType.EXTERNAL).version(Long.parseLong(payload));
                    continue block17;
                }
                case "_source": {
                    indexRequest.source(payload);
                    continue block17;
                }
            }
            indexRequest.source(f, (Object)payload);
        }
        bulkClient.bulkIndex(indexRequest);
    }
}

