/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.pull;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.xbib.elasticsearch.knapsack.KnapsackRequest;

public class KnapsackPullRequest
extends SingleCustomOperationRequest<KnapsackPullRequest>
implements KnapsackRequest {
    private Path path;
    private String host;
    private int port;
    private String cluster;
    private boolean sniff;
    private TimeValue timeout;
    private int maxActionsPerBulkRequest = 1000;
    private int maxBulkConcurrency = 2 * Runtime.getRuntime().availableProcessors();
    private Map indexTypeNames = Maps.newHashMap();
    private Map indexTypeDefinitions = Maps.newHashMap();
    private String index = "_all";
    private String type;
    private SearchRequest searchRequest;
    private boolean withMetadata;
    private boolean decodeEntry;
    private ByteSizeValue bytesToTransfer = ByteSizeValue.parseBytesSizeValue((String)"0");

    public KnapsackPullRequest setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public KnapsackPullRequest setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public KnapsackPullRequest setCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    @Override
    public String getCluster() {
        return this.cluster;
    }

    public KnapsackPullRequest setSniff(boolean sniff) {
        this.sniff = sniff;
        return this;
    }

    @Override
    public boolean getSniff() {
        return this.sniff;
    }

    public KnapsackPullRequest setIndex(String index) {
        this.index = index;
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public KnapsackPullRequest setType(String type) {
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public KnapsackPullRequest setTimeout(TimeValue timeValue) {
        this.timeout = timeValue;
        return this;
    }

    @Override
    public TimeValue getTimeout() {
        return this.timeout;
    }

    public KnapsackPullRequest setMaxActionsPerBulkRequest(int maxActionsPerBulkRequest) {
        this.maxActionsPerBulkRequest = maxActionsPerBulkRequest;
        return this;
    }

    public int getMaxActionsPerBulkRequest() {
        return this.maxActionsPerBulkRequest;
    }

    public KnapsackPullRequest setMaxBulkConcurrency(int maxBulkConcurrency) {
        this.maxBulkConcurrency = maxBulkConcurrency;
        return this;
    }

    public int getMaxBulkConcurrency() {
        return this.maxBulkConcurrency;
    }

    public KnapsackPullRequest setIndexTypeNames(Map indexTypeNames) {
        this.indexTypeNames = indexTypeNames;
        return this;
    }

    @Override
    public Map getIndexTypeNames() {
        return this.indexTypeNames;
    }

    public KnapsackPullRequest addIndexSettings(String index, String settingsSpec) {
        this.indexTypeDefinitions.put(index, settingsSpec);
        return this;
    }

    public KnapsackPullRequest addIndexTypeMapping(String indexType, String mappingSpec) {
        this.indexTypeDefinitions.put(indexType, mappingSpec);
        return this;
    }

    public boolean hasIndexSettings(String index) {
        return this.indexTypeDefinitions.containsKey(index + "_settings");
    }

    public String getIndexSettings(String index) {
        return (String)this.indexTypeDefinitions.get(index + "_settings");
    }

    public boolean hasIndexTypeMapping(String index, String type) {
        return this.indexTypeDefinitions.containsKey(index + "_" + type + "_mapping");
    }

    public String getIndexTypeMapping(String index, String type) {
        return (String)this.indexTypeDefinitions.get(index + "_" + type + "_mapping");
    }

    public KnapsackPullRequest setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        return this;
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public KnapsackPullRequest withMetadata(boolean withMetadata) {
        this.withMetadata = withMetadata;
        return this;
    }

    public boolean withMetadata() {
        return this.withMetadata;
    }

    public KnapsackPullRequest setPath(Path path) {
        this.path = path;
        return this;
    }

    public Path getPath() {
        return this.path;
    }

    public KnapsackPullRequest setDecodeEntry(boolean decodeEntry) {
        this.decodeEntry = decodeEntry;
        return this;
    }

    public boolean isDecodeEntry() {
        return this.decodeEntry;
    }

    public KnapsackPullRequest setBytesToTransfer(ByteSizeValue bytesToTransfer) {
        this.bytesToTransfer = bytesToTransfer;
        return this;
    }

    public ByteSizeValue getBytesToTransfer() {
        return this.bytesToTransfer;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.path.toUri().toString());
        out.writeString(this.host);
        out.writeInt(this.port);
        out.writeString(this.cluster);
        out.writeBoolean(this.sniff);
        if (this.timeout != null) {
            out.writeBoolean(true);
            this.timeout.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.maxActionsPerBulkRequest);
        out.writeInt(this.maxBulkConcurrency);
        out.writeMap(this.indexTypeDefinitions);
        out.writeMap(this.indexTypeNames);
        out.writeBoolean(this.withMetadata);
        out.writeBoolean(this.decodeEntry);
        out.writeString(this.index);
        out.writeString(this.type);
        if (this.searchRequest != null) {
            out.writeBoolean(true);
            this.searchRequest.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        this.bytesToTransfer.writeTo(out);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.path = Paths.get(URI.create(in.readString()));
        this.host = in.readString();
        this.port = in.readInt();
        this.cluster = in.readString();
        this.sniff = in.readBoolean();
        if (in.readBoolean()) {
            this.timeout = TimeValue.readTimeValue((StreamInput)in);
        }
        this.maxActionsPerBulkRequest = in.readInt();
        this.maxBulkConcurrency = in.readInt();
        this.indexTypeDefinitions = in.readMap();
        this.indexTypeNames = in.readMap();
        this.withMetadata = in.readBoolean();
        this.decodeEntry = in.readBoolean();
        this.index = in.readString();
        this.type = in.readString();
        if (in.readBoolean()) {
            this.searchRequest = new SearchRequest();
            this.searchRequest.readFrom(in);
        }
        this.bytesToTransfer.readFrom(in);
    }
}

