/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.pull;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.threadpool.ThreadPool;
import org.xbib.elasticsearch.action.knapsack.pull.KnapsackPullAction;
import org.xbib.elasticsearch.action.knapsack.pull.KnapsackPullRequest;
import org.xbib.elasticsearch.action.knapsack.pull.KnapsackPullResponse;
import org.xbib.elasticsearch.knapsack.KnapsackHelper;
import org.xbib.elasticsearch.knapsack.KnapsackService;
import org.xbib.elasticsearch.knapsack.KnapsackState;
import org.xbib.elasticsearch.support.client.Ingest;
import org.xbib.elasticsearch.support.client.bulk.BulkTransportClient;
import org.xbib.elasticsearch.support.client.node.BulkNodeClient;

public class TransportKnapsackPullAction
extends TransportAction<KnapsackPullRequest, KnapsackPullResponse> {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)KnapsackPullAction.class.getSimpleName());
    private final Environment environment;
    private final SettingsFilter settingsFilter;
    private final Client client;
    private final NodeService nodeService;
    private final KnapsackService knapsack;

    @Inject
    public TransportKnapsackPullAction(Settings settings, Environment environment, SettingsFilter settingsFilter, ThreadPool threadPool, Client client, NodeService nodeService, ActionFilters actionFilters, KnapsackService knapsack) {
        super(settings, "org.xbib.elasticsearch.knapsack.pull", threadPool, actionFilters);
        this.environment = environment;
        this.settingsFilter = settingsFilter;
        this.client = client;
        this.nodeService = nodeService;
        this.knapsack = knapsack;
    }

    protected void doExecute(final KnapsackPullRequest request, ActionListener<KnapsackPullResponse> listener) {
        final KnapsackState state = new KnapsackState().setMode("pull").setNodeName(this.nodeService.nodeName());
        KnapsackPullResponse response = new KnapsackPullResponse().setState(state);
        try {
            final BulkTransportClient transportClient = new BulkTransportClient();
            transportClient.flushIngestInterval(TimeValue.timeValueSeconds((long)5L)).maxActionsPerBulkRequest(request.getMaxActionsPerBulkRequest()).maxConcurrentBulkRequests(request.getMaxBulkConcurrency()).newClient(KnapsackHelper.clientSettings(this.client, this.environment, request));
            if (transportClient.getConnectedNodes().isEmpty()) {
                response.setRunning(false);
                transportClient.shutdown();
            } else {
                final BulkNodeClient nodeClient = new BulkNodeClient();
                nodeClient.flushIngestInterval(TimeValue.timeValueSeconds((long)5L)).maxActionsPerBulkRequest(request.getMaxActionsPerBulkRequest()).maxConcurrentBulkRequests(request.getMaxBulkConcurrency()).newClient(this.client);
                state.setTimestamp(new DateTime());
                response.setRunning(true);
                this.knapsack.submit(new Thread(){

                    @Override
                    public void run() {
                        TransportKnapsackPullAction.this.performPull(request, state, transportClient, nodeClient);
                    }
                });
            }
            listener.onResponse((Object)response);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
            listener.onFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void performPull(KnapsackPullRequest request, KnapsackState state, Ingest transportClient, Ingest nodeClient) {
        try {
            SearchRequest searchRequest;
            logger.info("start of pull: {}", new Object[]{state});
            long count = 0L;
            HashMap indices = Maps.newHashMap();
            for (String s : Strings.commaDelimitedListToSet((String)request.getIndex())) {
                indices.put(s, Strings.commaDelimitedListToSet((String)request.getType()));
            }
            if (request.withMetadata()) {
                Set types;
                if (request.getIndexTypeNames() != null) {
                    for (Object spec : request.getIndexTypeNames().keySet()) {
                        String type;
                        if (spec == null) continue;
                        String[] s = spec.toString().split("/");
                        String index = s[0];
                        String string = type = s.length > 1 ? s[1] : null;
                        if ("_all".equals(index)) continue;
                        types = (Set)indices.get(index);
                        if (types == null) {
                            types = Sets.newHashSet();
                        }
                        if (type != null) {
                            types.add(type);
                        }
                        indices.put(index, types);
                    }
                }
                logger.info("getting settings for indices {}", new Object[]{indices.keySet()});
                HashSet settingsIndices = Sets.newHashSet(indices.keySet());
                settingsIndices.remove("_all");
                Map<String, String> settings = KnapsackHelper.getSettings(transportClient.client(), this.settingsFilter, settingsIndices.toArray(new String[settingsIndices.size()]));
                logger.info("found indices: {}", new Object[]{settings.keySet()});
                for (String index : settings.keySet()) {
                    CreateIndexRequest createIndexRequest = Requests.createIndexRequest((String)KnapsackHelper.mapIndex(request, index));
                    types = (Set)indices.get(index);
                    createIndexRequest.settings(settings.get(index));
                    logger.info("getting mappings for index {} and types {}", new Object[]{index, types});
                    Map<String, String> mappings = KnapsackHelper.getMapping(transportClient.client(), index, (Set<String>)(types != null ? ImmutableSet.copyOf((Collection)types) : null));
                    logger.info("found mappings: {}", new Object[]{mappings.keySet()});
                    for (String type : mappings.keySet()) {
                        logger.info("adding mapping: {}", new Object[]{KnapsackHelper.mapType(request, index, type)});
                        createIndexRequest.mapping(KnapsackHelper.mapType(request, index, type), mappings.get(type));
                    }
                    logger.info("creating index: {}", new Object[]{KnapsackHelper.mapIndex(request, index)});
                    nodeClient.client().admin().indices().create(createIndexRequest).actionGet();
                    logger.info("index created: {}", new Object[]{KnapsackHelper.mapIndex(request, index)});
                    logger.info("getting aliases for index {}", new Object[]{index});
                    Map<String, String> aliases = KnapsackHelper.getAliases(this.client, index);
                    logger.info("found {} aliases", new Object[]{aliases.size()});
                    if (aliases.isEmpty()) continue;
                    IndicesAliasesRequestBuilder requestBuilder = nodeClient.client().admin().indices().prepareAliases();
                    for (String alias : aliases.keySet()) {
                        if (aliases.get(alias).isEmpty()) {
                            requestBuilder.addAlias(index, alias);
                            continue;
                        }
                        requestBuilder.addAlias(index, alias, aliases.get(alias));
                    }
                    requestBuilder.execute().actionGet();
                    logger.info("aliases created", new Object[]{aliases.size()});
                }
            }
            if ((searchRequest = request.getSearchRequest()) == null) {
                searchRequest = new SearchRequestBuilder(transportClient.client()).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).request();
            }
            for (String index : indices.keySet()) {
                long hits;
                Set types;
                searchRequest.searchType(SearchType.SCAN).scroll(request.getTimeout());
                if (!"_all".equals(index)) {
                    searchRequest.indices(new String[]{index});
                }
                if ((types = (Set)indices.get(index)) != null) {
                    searchRequest.types(types.toArray(new String[types.size()]));
                }
                SearchResponse searchResponse = (SearchResponse)transportClient.client().search(searchRequest).actionGet();
                long total = 0L;
                while (searchResponse.getScrollId() != null && !Thread.interrupted() && (hits = (long)(searchResponse = (SearchResponse)transportClient.client().prepareSearchScroll(searchResponse.getScrollId()).setScroll(request.getTimeout()).execute().actionGet()).getHits().getHits().length) != 0L) {
                    logger.debug("total={} hits={} took={}", new Object[]{total += hits, hits, searchResponse.getTookInMillis()});
                    for (SearchHit hit : searchResponse.getHits()) {
                        this.indexSearchHit(nodeClient, request, hit);
                        ++count;
                    }
                }
            }
            nodeClient.flushIngest();
            nodeClient.waitForResponses(TimeValue.timeValueSeconds((long)60L));
            for (String index : indices.keySet()) {
                nodeClient.refresh(index);
            }
            nodeClient.shutdown();
            transportClient.shutdown();
            logger.info("end of pull: {}, count = {}", new Object[]{state, count});
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
        }
        finally {
            try {
                this.knapsack.removeImport(this.client, state);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
    }

    private void indexSearchHit(Ingest nodeBulkClient, KnapsackPullRequest request, SearchHit hit) throws IOException {
        IndexRequest indexRequest = new IndexRequest(KnapsackHelper.mapIndex(request, hit.getIndex()), KnapsackHelper.mapType(request, hit.getIndex(), hit.getType()), hit.getId());
        Iterator iterator = hit.getFields().keySet().iterator();
        block14: while (iterator.hasNext()) {
            String f;
            switch (f = (String)iterator.next()) {
                case "_parent": {
                    indexRequest.parent(((SearchHitField)hit.getFields().get(f)).getValue().toString());
                    continue block14;
                }
                case "_routing": {
                    indexRequest.routing(((SearchHitField)hit.getFields().get(f)).getValue().toString());
                    continue block14;
                }
                case "_timestamp": {
                    indexRequest.timestamp(((SearchHitField)hit.getFields().get(f)).getValue().toString());
                    continue block14;
                }
                case "_version": {
                    indexRequest.versionType(VersionType.EXTERNAL).version(Long.parseLong(((SearchHitField)hit.getFields().get(f)).getValue().toString()));
                    continue block14;
                }
                case "_source": {
                    indexRequest.source(hit.getSourceAsString());
                    continue block14;
                }
            }
            indexRequest.source(f, (Object)((SearchHitField)hit.getFields().get(f)).getValue().toString());
        }
        if (!hit.getFields().keySet().contains("_source")) {
            indexRequest.source(hit.getSourceAsString());
        }
        nodeBulkClient.bulkIndex(indexRequest);
    }
}

