/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.push;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.xbib.elasticsearch.knapsack.KnapsackRequest;

public class KnapsackPushRequest
extends SingleCustomOperationRequest<KnapsackPushRequest>
implements KnapsackRequest {
    private String host;
    private int port;
    private String cluster;
    private boolean sniff;
    private TimeValue timeout;
    private int limit;
    private int maxActionsPerBulkRequest = 1000;
    private int maxBulkConcurrency = 2 * Runtime.getRuntime().availableProcessors();
    private Map<String, Object> indexTypeNames = Maps.newHashMap();
    private boolean withMetadata;
    private String index = "_all";
    private String type;
    private SearchRequest searchRequest;

    public KnapsackPushRequest setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public KnapsackPushRequest setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public KnapsackPushRequest setCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    @Override
    public String getCluster() {
        return this.cluster;
    }

    public KnapsackPushRequest setSniff(boolean sniff) {
        this.sniff = sniff;
        return this;
    }

    @Override
    public boolean getSniff() {
        return this.sniff;
    }

    public KnapsackPushRequest setIndex(String index) {
        this.index = index;
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public KnapsackPushRequest setType(String type) {
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public KnapsackPushRequest setTimeout(TimeValue timeValue) {
        this.timeout = timeValue;
        return this;
    }

    @Override
    public TimeValue getTimeout() {
        return this.timeout;
    }

    public KnapsackPushRequest setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public KnapsackPushRequest setMaxActionsPerBulkRequest(int maxActionsPerBulkRequest) {
        this.maxActionsPerBulkRequest = maxActionsPerBulkRequest;
        return this;
    }

    public int getMaxActionsPerBulkRequest() {
        return this.maxActionsPerBulkRequest;
    }

    public KnapsackPushRequest setMaxBulkConcurrency(int maxBulkConcurrency) {
        this.maxBulkConcurrency = maxBulkConcurrency;
        return this;
    }

    public int getMaxBulkConcurrency() {
        return this.maxBulkConcurrency;
    }

    public KnapsackPushRequest setIndexTypeNames(Map<String, Object> indexTypeNames) {
        this.indexTypeNames = indexTypeNames;
        return this;
    }

    @Override
    public Map<String, Object> getIndexTypeNames() {
        return this.indexTypeNames;
    }

    public KnapsackPushRequest withMetadata(boolean withMetadata) {
        this.withMetadata = withMetadata;
        return this;
    }

    public boolean withMetadata() {
        return this.withMetadata;
    }

    public KnapsackPushRequest setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        return this;
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.host);
        out.writeInt(this.port);
        out.writeString(this.cluster);
        out.writeBoolean(this.sniff);
        if (this.timeout != null) {
            out.writeBoolean(true);
            this.timeout.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.limit);
        out.writeInt(this.maxActionsPerBulkRequest);
        out.writeInt(this.maxBulkConcurrency);
        out.writeMap(this.indexTypeNames);
        out.writeBoolean(this.withMetadata);
        out.writeString(this.index);
        out.writeString(this.type);
        if (this.searchRequest != null) {
            out.writeBoolean(true);
            this.searchRequest.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.host = in.readString();
        this.port = in.readInt();
        this.cluster = in.readString();
        this.sniff = in.readBoolean();
        if (in.readBoolean()) {
            this.timeout = TimeValue.readTimeValue((StreamInput)in);
        }
        this.limit = in.readInt();
        this.maxActionsPerBulkRequest = in.readInt();
        this.maxBulkConcurrency = in.readInt();
        this.indexTypeNames = in.readMap();
        this.withMetadata = in.readBoolean();
        this.index = in.readString();
        this.type = in.readString();
        if (in.readBoolean()) {
            this.searchRequest = new SearchRequest();
            this.searchRequest.readFrom(in);
        }
    }
}

