/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.push;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.threadpool.ThreadPool;
import org.xbib.elasticsearch.action.knapsack.push.KnapsackPushAction;
import org.xbib.elasticsearch.action.knapsack.push.KnapsackPushRequest;
import org.xbib.elasticsearch.action.knapsack.push.KnapsackPushResponse;
import org.xbib.elasticsearch.knapsack.KnapsackHelper;
import org.xbib.elasticsearch.knapsack.KnapsackService;
import org.xbib.elasticsearch.knapsack.KnapsackState;
import org.xbib.elasticsearch.support.client.bulk.BulkTransportClient;

public class TransportKnapsackPushAction
extends TransportAction<KnapsackPushRequest, KnapsackPushResponse> {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)KnapsackPushAction.class.getSimpleName());
    private final Environment environment;
    private final SettingsFilter settingsFilter;
    private final Client client;
    private final NodeService nodeService;
    private final KnapsackService knapsack;

    @Inject
    public TransportKnapsackPushAction(Settings settings, Environment environment, ThreadPool threadPool, SettingsFilter settingsFilter, Client client, NodeService nodeService, ActionFilters actionFilters, KnapsackService knapsack) {
        super(settings, "org.xbib.elasticsearch.knapsack.push", threadPool, actionFilters);
        this.environment = environment;
        this.settingsFilter = settingsFilter;
        this.client = client;
        this.nodeService = nodeService;
        this.knapsack = knapsack;
    }

    protected void doExecute(final KnapsackPushRequest request, ActionListener<KnapsackPushResponse> listener) {
        final KnapsackState state = new KnapsackState().setMode("push").setNodeName(this.nodeService.nodeName());
        KnapsackPushResponse response = new KnapsackPushResponse().setState(state);
        try {
            final BulkTransportClient bulkClient = new BulkTransportClient();
            bulkClient.flushIngestInterval(TimeValue.timeValueSeconds((long)5L)).maxActionsPerBulkRequest(request.getMaxActionsPerBulkRequest()).maxConcurrentBulkRequests(request.getMaxBulkConcurrency()).newClient(KnapsackHelper.clientSettings(this.client, this.environment, request));
            if (bulkClient.getConnectedNodes().isEmpty()) {
                response.setRunning(false);
                bulkClient.shutdown();
            } else {
                state.setTimestamp(new DateTime());
                response.setRunning(true);
                this.knapsack.submit(new Thread(){

                    @Override
                    public void run() {
                        TransportKnapsackPushAction.this.performPush(request, state, bulkClient);
                    }
                });
            }
            this.knapsack.addExport(this.client, state);
            listener.onResponse((Object)response);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
            listener.onFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void performPush(KnapsackPushRequest request, KnapsackState state, BulkTransportClient bulkClient) {
        try {
            SearchRequest searchRequest;
            logger.info("start of push: {}", new Object[]{state});
            long count = 0L;
            HashMap indices = Maps.newHashMap();
            for (String string : Strings.commaDelimitedListToSet((String)request.getIndex())) {
                indices.put(string, Strings.commaDelimitedListToSet((String)request.getType()));
            }
            if (request.withMetadata()) {
                Set types;
                logger.info("map={}", new Object[]{request.getIndexTypeNames()});
                if (request.getIndexTypeNames() != null) {
                    for (Object object : request.getIndexTypeNames().keySet()) {
                        String type;
                        if (object == null) continue;
                        String[] s = object.toString().split("/");
                        String index = s[0];
                        String string = type = s.length > 1 ? s[1] : null;
                        if ("_all".equals(index)) continue;
                        types = (Set)indices.get(index);
                        if (types == null) {
                            types = Sets.newHashSet();
                        }
                        if (type != null) {
                            types.add(type);
                        }
                        indices.put(index, types);
                    }
                }
                logger.info("getting settings for indices {}", new Object[]{indices.keySet()});
                HashSet settingsIndices = Sets.newHashSet(indices.keySet());
                settingsIndices.remove("_all");
                Map<String, String> map = KnapsackHelper.getSettings(this.client, this.settingsFilter, settingsIndices.toArray(new String[settingsIndices.size()]));
                logger.info("found indices: {}", new Object[]{map.keySet()});
                for (String index : map.keySet()) {
                    block46: {
                        CreateIndexRequest createIndexRequest = Requests.createIndexRequest((String)KnapsackHelper.mapIndex(request, index));
                        types = (Set)indices.get(index);
                        createIndexRequest.settings(map.get(index));
                        logger.info("getting mappings for index {} and types {}", new Object[]{index, types});
                        Map<String, String> mappings = KnapsackHelper.getMapping(this.client, index, (Set<String>)(types != null ? ImmutableSet.copyOf((Collection)types) : null));
                        logger.info("found mappings: {}", new Object[]{mappings.keySet()});
                        for (String type : mappings.keySet()) {
                            logger.info("adding mapping: {}", new Object[]{KnapsackHelper.mapType(request, index, type)});
                            createIndexRequest.mapping(KnapsackHelper.mapType(request, index, type), mappings.get(type));
                        }
                        logger.info("creating index: {}", new Object[]{KnapsackHelper.mapIndex(request, index)});
                        try {
                            bulkClient.client().admin().indices().create(createIndexRequest).actionGet();
                            logger.info("index created: {}", new Object[]{KnapsackHelper.mapIndex(request, index)});
                        }
                        catch (Exception e) {
                            CountResponse countResponse = (CountResponse)bulkClient.client().count(new CountRequest(new String[]{KnapsackHelper.mapIndex(request, index)})).actionGet();
                            logger.info("count={} status={}", new Object[]{countResponse.getCount(), countResponse.status()});
                            if (countResponse.getCount() <= 0L) break block46;
                            throw e;
                        }
                    }
                    logger.info("getting aliases for index {}", new Object[]{index});
                    Map<String, String> aliases = KnapsackHelper.getAliases(this.client, index);
                    logger.info("found {} aliases", new Object[]{aliases.size()});
                    if (aliases.isEmpty()) continue;
                    IndicesAliasesRequestBuilder requestBuilder = bulkClient.client().admin().indices().prepareAliases();
                    for (String alias : aliases.keySet()) {
                        if (aliases.get(alias).isEmpty()) {
                            requestBuilder.addAlias(index, alias);
                            continue;
                        }
                        requestBuilder.addAlias(index, alias, aliases.get(alias));
                    }
                    requestBuilder.execute().actionGet();
                    logger.info("aliases created", new Object[]{aliases.size()});
                }
            }
            if ((searchRequest = request.getSearchRequest()) == null) {
                searchRequest = new SearchRequestBuilder(this.client).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).request();
            }
            for (String index : indices.keySet()) {
                long hits;
                Set types;
                searchRequest.searchType(SearchType.SCAN).scroll(request.getTimeout());
                if (!"_all".equals(index)) {
                    searchRequest.indices(new String[]{index});
                }
                if ((types = (Set)indices.get(index)) != null) {
                    searchRequest.types(types.toArray(new String[types.size()]));
                }
                SearchResponse searchResponse = (SearchResponse)this.client.search(searchRequest).actionGet();
                long total = 0L;
                while (searchResponse.getScrollId() != null && !Thread.interrupted() && (hits = (long)(searchResponse = (SearchResponse)this.client.prepareSearchScroll(searchResponse.getScrollId()).setScroll(request.getTimeout()).execute().actionGet()).getHits().getHits().length) != 0L) {
                    logger.debug("total={} hits={} took={}", new Object[]{total += hits, hits, searchResponse.getTookInMillis()});
                    for (SearchHit hit : searchResponse.getHits()) {
                        IndexRequest indexRequest = new IndexRequest(KnapsackHelper.mapIndex(request, hit.getIndex()), KnapsackHelper.mapType(request, hit.getIndex(), hit.getType()), hit.getId());
                        Iterator iterator = hit.getFields().keySet().iterator();
                        while (iterator.hasNext()) {
                            String f;
                            switch (f = (String)iterator.next()) {
                                case "_parent": {
                                    indexRequest.parent(((SearchHitField)hit.getFields().get(f)).getValue().toString());
                                    break;
                                }
                                case "_routing": {
                                    indexRequest.routing(((SearchHitField)hit.getFields().get(f)).getValue().toString());
                                    break;
                                }
                                case "_timestamp": {
                                    indexRequest.timestamp(((SearchHitField)hit.getFields().get(f)).getValue().toString());
                                    break;
                                }
                                case "_version": {
                                    indexRequest.versionType(VersionType.EXTERNAL).version(Long.parseLong(((SearchHitField)hit.getFields().get(f)).getValue().toString()));
                                    break;
                                }
                                case "_source": {
                                    indexRequest.source(hit.getSourceAsString());
                                    break;
                                }
                                default: {
                                    indexRequest.source(f, (Object)((SearchHitField)hit.getFields().get(f)).getValue().toString());
                                }
                            }
                            ++count;
                        }
                        if (!hit.getFields().keySet().contains("_source")) {
                            indexRequest.source(hit.getSourceAsString());
                            ++count;
                        }
                        bulkClient.bulkIndex(indexRequest);
                    }
                }
            }
            bulkClient.flushIngest();
            bulkClient.waitForResponses(TimeValue.timeValueSeconds((long)60L));
            for (String index : indices.keySet()) {
                bulkClient.refresh(index);
            }
            bulkClient.shutdown();
            logger.info("end of push: {}, count = {}", new Object[]{state, count});
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
        }
        finally {
            try {
                this.knapsack.removeExport(this.client, state);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
    }
}

