/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.state;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.xbib.elasticsearch.knapsack.KnapsackState;

public class KnapsackStateResponse
extends ActionResponse
implements ToXContent {
    private List<KnapsackState> states = Lists.newLinkedList();

    public KnapsackStateResponse addState(KnapsackState state) {
        this.states.add(state);
        return this;
    }

    public List<KnapsackState> getStates() {
        return this.states;
    }

    public boolean isExportActive(Path path) {
        if (this.states != null && path != null) {
            for (KnapsackState ks : this.states) {
                if (ks == null || !"export".equals(ks.getMode()) || ks.getPath() == null || !path.toString().equals(ks.getPath().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isImportActive(Path path) {
        if (this.states != null && path != null) {
            for (KnapsackState ks : this.states) {
                if (ks == null || !"import".equals(ks.getMode()) || ks.getPath() == null || !path.toString().equals(ks.getPath().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPushActive() {
        if (this.states != null) {
            for (KnapsackState ks : this.states) {
                if (ks == null || !"push".equals(ks.getMode())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPullActive() {
        if (this.states != null) {
            for (KnapsackState ks : this.states) {
                if (ks == null || !"pull".equals(ks.getMode())) continue;
                return true;
            }
        }
        return false;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("count", this.states.size()).startArray("states");
        for (KnapsackState ks : this.states) {
            ks.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.states = Lists.newLinkedList();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            KnapsackState ks = new KnapsackState();
            ks.readFrom(in);
            this.states.add(ks);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.states != null) {
            out.writeInt(this.states.size());
            for (KnapsackState state : this.states) {
                state.writeTo(out);
            }
        }
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder = this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "";
        }
    }
}

