/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.action.knapsack.state;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.xbib.elasticsearch.action.knapsack.state.KnapsackStateAction;
import org.xbib.elasticsearch.action.knapsack.state.KnapsackStateRequest;
import org.xbib.elasticsearch.action.knapsack.state.KnapsackStateResponse;
import org.xbib.elasticsearch.knapsack.KnapsackService;
import org.xbib.elasticsearch.knapsack.KnapsackState;

public class TransportKnapsackStateAction
extends TransportAction<KnapsackStateRequest, KnapsackStateResponse> {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)KnapsackStateAction.class.getSimpleName());
    private final Client client;
    private final KnapsackService knapsack;

    @Inject
    public TransportKnapsackStateAction(Settings settings, ThreadPool threadPool, Client client, ActionFilters actionFilters, KnapsackService knapsack) {
        super(settings, "org.xbib.elasticsearch.knapsack.state", threadPool, actionFilters);
        this.client = client;
        this.knapsack = knapsack;
    }

    protected void doExecute(KnapsackStateRequest request, ActionListener<KnapsackStateResponse> listener) {
        KnapsackStateResponse response = new KnapsackStateResponse();
        try {
            for (KnapsackState state : this.knapsack.getExports(this.client)) {
                response.addState(state);
            }
            for (KnapsackState state : this.knapsack.getImports(this.client)) {
                response.addState(state);
            }
            listener.onResponse((Object)response);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
            listener.onFailure(e);
        }
    }
}

