/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.knapsack;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.Environment;
import org.xbib.classloader.uri.URIClassLoader;
import org.xbib.elasticsearch.knapsack.KnapsackRequest;

public class KnapsackHelper {
    private KnapsackHelper() {
    }

    public static Map<String, Object> toMap(String s, ESLogger logger) throws IOException {
        HashMap<String, Object> map;
        Map<String, Object> map2 = map = s == null ? new HashMap<String, Object>() : XContentFactory.xContent((XContentType)XContentType.JSON).createParser(s).mapAndClose();
        if (map.isEmpty() && s != null && s.length() > 0) {
            logger.warn("can not parse map, check URI escape, got param: {}", new Object[]{s});
        }
        return map;
    }

    public static Map<String, String> getSettings(Client client, SettingsFilter settingsFilter, String ... index) throws IOException {
        HashMap settings = Maps.newHashMap();
        ClusterStateRequestBuilder request = client.admin().cluster().prepareState().setIndices(index);
        ClusterStateResponse response = (ClusterStateResponse)request.execute().actionGet();
        MetaData metaData = response.getState().metaData();
        if (!metaData.getIndices().isEmpty()) {
            for (IndexMetaData indexMetaData : metaData) {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.startObject();
                for (Map.Entry entry : settingsFilter.filterSettings(indexMetaData.getSettings()).getAsMap().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
                settings.put(indexMetaData.getIndex(), builder.string());
            }
        }
        return settings;
    }

    public static Map<String, String> getMapping(Client client, String index, Set<String> types) throws IOException {
        ClusterStateResponse response;
        MetaData metaData;
        HashMap mappings = Maps.newHashMap();
        ClusterStateRequestBuilder request = client.admin().cluster().prepareState();
        if (!"_all".equals(index)) {
            request.setIndices(new String[]{index});
        }
        if (!(metaData = (response = (ClusterStateResponse)request.execute().actionGet()).getState().getMetaData()).getIndices().isEmpty()) {
            for (IndexMetaData indexMetaData : metaData) {
                for (ObjectCursor c : indexMetaData.getMappings().values()) {
                    MappingMetaData mappingMetaData = (MappingMetaData)c.value;
                    if (types != null && !types.isEmpty() && !types.contains(mappingMetaData.type())) continue;
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    builder.startObject();
                    builder.field(mappingMetaData.type());
                    builder.map(mappingMetaData.sourceAsMap());
                    builder.endObject();
                    mappings.put(mappingMetaData.type(), builder.string());
                }
            }
        }
        return mappings;
    }

    public static Map<String, String> getAliases(Client client, String index) throws IOException {
        ClusterStateResponse response;
        MetaData metaData;
        HashMap aliases = Maps.newHashMap();
        ClusterStateRequestBuilder request = client.admin().cluster().prepareState();
        if (!"_all".equals(index)) {
            request.setIndices(new String[]{index});
        }
        if (!(metaData = (response = (ClusterStateResponse)request.execute().actionGet()).getState().getMetaData()).getIndices().isEmpty()) {
            for (IndexMetaData indexMetaData : metaData) {
                for (ObjectCursor c : indexMetaData.getAliases().values()) {
                    AliasMetaData aliasMetaData = (AliasMetaData)c.value;
                    String alias = aliasMetaData.getAlias();
                    if (aliasMetaData.getFilter() != null) {
                        aliases.put(alias, new String(aliasMetaData.getFilter().uncompressed()));
                        continue;
                    }
                    aliases.put(alias, "");
                }
            }
        }
        return aliases;
    }

    public static String mapIndex(KnapsackRequest request, String index) {
        return request.getIndexTypeNames().containsKey(index) ? request.getIndexTypeNames().get(index).toString() : index;
    }

    public static String mapType(KnapsackRequest request, String index, String type) {
        String s = index + "/" + type;
        return request.getIndexTypeNames().containsKey(s) ? request.getIndexTypeNames().get(s).toString() : type;
    }

    public static Settings clientSettings(Client client, Environment environment, KnapsackRequest request) {
        NodesInfoResponse response;
        String cluster = request.getCluster();
        String host = request.getHost();
        int port = request.getPort();
        if (host == null) {
            response = (NodesInfoResponse)client.admin().cluster().nodesInfo(new NodesInfoRequest().transport(true)).actionGet();
            InetSocketTransportAddress address = (InetSocketTransportAddress)((NodeInfo)response.iterator().next()).getTransport().getAddress().publishAddress();
            host = address.address().getAddress().getHostAddress();
            port = address.address().getPort();
            if (cluster == null) {
                cluster = response.getClusterName().value();
            }
        }
        if (cluster == null) {
            response = (NodesInfoResponse)client.admin().cluster().nodesInfo(new NodesInfoRequest().transport(true)).actionGet();
            cluster = response.getClusterName().value();
        }
        return ImmutableSettings.settingsBuilder().put("host", host).put("port", port).put("cluster.name", cluster).put(new Object[]{"timeout", request.getTimeout()}).put("client.transport.sniff", request.getSniff()).put(new Object[]{"client.transport.ping_timeout", request.getTimeout()}).put("client.transport.ignore_cluster_name", true).put("path.plugins", ".dontexist").classLoader(KnapsackHelper.getClassLoader(environment)).build();
    }

    private static ClassLoader getClassLoader(Environment environment) {
        URIClassLoader classLoader = new URIClassLoader();
        File[] libs = new File(environment.homeFile() + "/lib").listFiles();
        if (libs != null) {
            for (File file : libs) {
                if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                classLoader.addURI(file.toURI());
            }
        }
        return classLoader;
    }
}

