/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.knapsack;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.xbib.elasticsearch.knapsack.KnapsackState;

public class KnapsackService
extends AbstractLifecycleComponent<KnapsackService> {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)KnapsackService.class.getSimpleName());
    public static final String EXPORT_STATE_SETTING_NAME = "plugin.knapsack.export.state";
    public static final String IMPORT_STATE_SETTING_NAME = "plugin.knapsack.import.state";
    private final ClusterService clusterService;
    private ExecutorService executor;
    private List<Future<?>> tasks;

    @Inject
    public KnapsackService(Settings settings, ClusterService clusterService) {
        super(settings);
        this.clusterService = clusterService;
        this.tasks = Lists.newArrayList();
        this.executor = Executors.newSingleThreadExecutor();
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ElasticsearchException(e.getMessage());
        }
    }

    protected void doClose() throws ElasticsearchException {
    }

    public List<KnapsackState> getImports(Client client) throws IOException {
        return this.get(IMPORT_STATE_SETTING_NAME);
    }

    public void addImport(Client client, KnapsackState newImport) throws IOException {
        this.add(client, IMPORT_STATE_SETTING_NAME, this.getImports(client), newImport);
    }

    public void removeImport(Client client, KnapsackState targetImport) throws IOException {
        this.remove(client, IMPORT_STATE_SETTING_NAME, this.getImports(client), targetImport);
    }

    public void updateImport(Client client, KnapsackState targetImport) throws IOException {
        this.update(client, IMPORT_STATE_SETTING_NAME, this.getImports(client), targetImport);
    }

    public List<KnapsackState> getExports(Client client) throws IOException {
        return this.get(EXPORT_STATE_SETTING_NAME);
    }

    public void addExport(Client client, KnapsackState newExport) throws IOException {
        this.add(client, EXPORT_STATE_SETTING_NAME, this.getExports(client), newExport);
    }

    public void removeExport(Client client, KnapsackState targetExport) throws IOException {
        this.remove(client, EXPORT_STATE_SETTING_NAME, this.getExports(client), targetExport);
    }

    public void updateExport(Client client, KnapsackState targetExport) throws IOException {
        this.update(client, EXPORT_STATE_SETTING_NAME, this.getExports(client), targetExport);
    }

    private List<KnapsackState> get(String name) throws IOException {
        return KnapsackService.parseStates(this.getClusterSetting(name));
    }

    private void add(Client client, String name, List<KnapsackState> values, KnapsackState targetValue) throws IOException {
        logger.info("add: {} -> {}", new Object[]{name, values});
        this.updateClusterSettings(client, name, KnapsackService.generateSetting((List<KnapsackState>)ImmutableList.builder().addAll(values).add((Object)targetValue).build()));
    }

    private void remove(Client client, String name, List<KnapsackState> values, KnapsackState targetValue) throws IOException {
        logger.info("remove: {} -> {}", new Object[]{name, values});
        ImmutableList.Builder updatedValues = ImmutableList.builder();
        for (KnapsackState value : values) {
            if (value.equals(targetValue)) continue;
            updatedValues.add((Object)value);
        }
        this.updateClusterSettings(client, name, KnapsackService.generateSetting((List<KnapsackState>)updatedValues.build()));
    }

    private void update(Client client, String name, List<KnapsackState> values, KnapsackState targetValue) throws IOException {
        ImmutableList.Builder updatedValues = ImmutableList.builder();
        for (KnapsackState value : values) {
            if (value.equals(targetValue)) {
                updatedValues.add((Object)targetValue);
                continue;
            }
            updatedValues.add((Object)value);
        }
        this.updateClusterSettings(client, name, KnapsackService.generateSetting((List<KnapsackState>)updatedValues.build()));
    }

    private String getClusterSetting(String name) {
        return this.getClusterSettings().get(name, "[]");
    }

    private Settings getClusterSettings() {
        return this.clusterService.state().getMetaData().transientSettings();
    }

    private void updateClusterSettings(Client client, String name, String value) {
        logger.info("update cluster settings: {} -> {}", new Object[]{name, value});
        client.admin().cluster().prepareUpdateSettings().setTransientSettings(ImmutableSettings.settingsBuilder().put(this.getClusterSettings()).put(name, value).build()).execute().actionGet();
    }

    private static List<KnapsackState> parseStates(String value) throws IOException {
        XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(value);
        ImmutableList.Builder builder = ImmutableList.builder();
        parser.nextToken();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            KnapsackState state = new KnapsackState();
            builder.add((Object)state.fromXContent(parser));
        }
        return builder.build();
    }

    private static String generateSetting(List<KnapsackState> values) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startArray();
        for (KnapsackState value : values) {
            value.toXContent(builder, ToXContent.EMPTY_PARAMS);
        }
        builder.endArray();
        return builder.string();
    }

    public void submit(Runnable runnable) {
        Future<?> f = this.executor.submit(runnable);
        this.tasks.add(f);
    }

    public int abort() {
        int size = this.tasks.size();
        logger.info("aborting {} tasks", new Object[]{size});
        for (Future<?> f : this.tasks) {
            boolean b = f.cancel(true);
            if (b) continue;
            logger.error("task {} could not be cancelled", new Object[]{f});
        }
        this.tasks.clear();
        logger.info("shutdown", new Object[0]);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new ElasticsearchException(e.getMessage());
        }
        logger.info("shutdown now", new Object[0]);
        List<Runnable> runnables = this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new ElasticsearchException(e.getMessage());
        }
        logger.info("task queue size was {}, setting new executor", new Object[]{runnables.size()});
        this.executor = Executors.newSingleThreadExecutor();
        return size;
    }
}

