/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.knapsack;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.joda.time.ReadableInstant;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class KnapsackState
implements Streamable,
ToXContent {
    private String mode;
    private DateTime timestamp;
    private Path path;
    private String address;
    private String nodeName;
    private static final DateMathParser dateParser = new DateMathParser(Joda.forPattern((String)"dateOptionalTime"), TimeUnit.MILLISECONDS);

    public KnapsackState setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public KnapsackState setTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public KnapsackState setPath(Path path) {
        this.path = path;
        return this;
    }

    public Path getPath() {
        return this.path;
    }

    public KnapsackState setClusterAddress(String address) {
        this.address = address;
        return this;
    }

    public String getClusterAddress() {
        return this.address;
    }

    public KnapsackState setNodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    private static Callable<Long> now() {
        return new Callable<Long>(){

            @Override
            public Long call() {
                return 0L;
            }
        };
    }

    public KnapsackState fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Long startTimestamp = new Date().getTime();
        Path path = null;
        String address = null;
        String nodeName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue() && token != XContentParser.Token.VALUE_NULL) continue;
            switch (currentFieldName) {
                case "mode": {
                    this.mode = parser.text();
                    break;
                }
                case "started": {
                    startTimestamp = parser.text() != null ? Long.valueOf(dateParser.parse(parser.text(), KnapsackState.now())) : null;
                    break;
                }
                case "path": {
                    path = parser.text() != null ? Paths.get(URI.create(parser.text())) : null;
                    break;
                }
                case "cluster_address": {
                    address = parser.text();
                    break;
                }
                case "node_name": {
                    nodeName = parser.text();
                }
            }
        }
        return new KnapsackState().setMode(this.mode).setTimestamp(new DateTime((Object)startTimestamp)).setPath(path).setClusterAddress(address).setNodeName(nodeName);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("mode", this.mode);
        if (this.timestamp != null) {
            builder.field("started", (ReadableInstant)this.timestamp);
        }
        if (this.path != null) {
            builder.field("path", this.path.toUri().toString());
        }
        if (this.address != null) {
            builder.field("cluster_address", this.address);
        }
        if (this.nodeName != null) {
            builder.field("node_name", this.nodeName);
        }
        builder.endObject();
        return builder;
    }

    public String id() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mode).append(this.timestamp).append(this.path).append(this.address).append(this.nodeName);
        return sb.toString();
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KnapsackState other = (KnapsackState)obj;
        return this.id().equals(other.id());
    }

    public void readFrom(StreamInput in) throws IOException {
        this.mode = in.readString();
        this.timestamp = new DateTime(in.readLong());
        this.path = Paths.get(URI.create(in.readString()));
        this.address = in.readString();
        this.nodeName = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.mode);
        out.writeLong(this.timestamp.getMillis());
        out.writeString(this.path.toUri().toString());
        out.writeString(this.address);
        out.writeString(this.nodeName);
    }

    public String toString() {
        try {
            return this.toXContent(XContentFactory.jsonBuilder(), EMPTY_PARAMS).string();
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

