/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.plugin.knapsack;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.xbib.elasticsearch.plugin.knapsack.KnapsackPlugin;

public class Build {
    private static final Build INSTANCE;
    private String version;
    private String hash;
    private String hashShort;
    private String timestamp;
    private String date;

    Build(String version, String hash, String hashShort, String timestamp, String date) {
        this.version = version;
        this.hash = hash;
        this.hashShort = hashShort;
        this.timestamp = timestamp;
        this.date = date;
    }

    public static Build getInstance() {
        return INSTANCE;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHash() {
        return this.hash;
    }

    public String getShortHash() {
        return this.hashShort;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getDate() {
        return this.date;
    }

    static {
        String version = "NA";
        String hash = "NA";
        String hashShort = "NA";
        String timestamp = "NA";
        String date = "NA";
        try {
            String pluginName = KnapsackPlugin.class.getName();
            Enumeration<URL> e = KnapsackPlugin.class.getClassLoader().getResources("es-plugin.properties");
            while (e.hasMoreElements()) {
                int len;
                URL url = e.nextElement();
                InputStream in = url.openStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                in.close();
                Properties props = new Properties();
                props.load(new StringReader(new String(out.toByteArray())));
                String plugin = props.getProperty("plugin");
                if (!pluginName.equals(plugin)) continue;
                version = props.getProperty("version");
                hash = props.getProperty("hash");
                if (!"NA".equals(hash)) {
                    hashShort = hash.substring(0, 7);
                }
                timestamp = props.getProperty("timestamp");
                date = props.getProperty("date");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        INSTANCE = new Build(version, hash, hashShort, timestamp, date);
    }
}

