/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.plugin.knapsack;

import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.cluster.settings.ClusterDynamicSettingsModule;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.plugins.AbstractPlugin;
import org.elasticsearch.rest.RestModule;
import org.xbib.elasticsearch.action.knapsack.abort.KnapsackAbortAction;
import org.xbib.elasticsearch.action.knapsack.abort.TransportKnapsackAbortAction;
import org.xbib.elasticsearch.action.knapsack.exp.KnapsackExportAction;
import org.xbib.elasticsearch.action.knapsack.exp.TransportKnapsackExportAction;
import org.xbib.elasticsearch.action.knapsack.imp.KnapsackImportAction;
import org.xbib.elasticsearch.action.knapsack.imp.TransportKnapsackImportAction;
import org.xbib.elasticsearch.action.knapsack.pull.KnapsackPullAction;
import org.xbib.elasticsearch.action.knapsack.pull.TransportKnapsackPullAction;
import org.xbib.elasticsearch.action.knapsack.push.KnapsackPushAction;
import org.xbib.elasticsearch.action.knapsack.push.TransportKnapsackPushAction;
import org.xbib.elasticsearch.action.knapsack.state.KnapsackStateAction;
import org.xbib.elasticsearch.action.knapsack.state.TransportKnapsackStateAction;
import org.xbib.elasticsearch.knapsack.KnapsackModule;
import org.xbib.elasticsearch.plugin.knapsack.Build;
import org.xbib.elasticsearch.rest.action.knapsack.abort.RestKnapsackAbortAction;
import org.xbib.elasticsearch.rest.action.knapsack.exp.RestKnapsackExportAction;
import org.xbib.elasticsearch.rest.action.knapsack.imp.RestKnapsackImportAction;
import org.xbib.elasticsearch.rest.action.knapsack.pull.RestKnapsackPullAction;
import org.xbib.elasticsearch.rest.action.knapsack.push.RestKnapsackPushAction;
import org.xbib.elasticsearch.rest.action.knapsack.state.RestKnapsackStateAction;

public class KnapsackPlugin
extends AbstractPlugin {
    public String name() {
        return "knapsack-" + Build.getInstance().getVersion() + "-" + Build.getInstance().getShortHash();
    }

    public String description() {
        return "Knapsack plugin for import/export";
    }

    public void onModule(ActionModule module) {
        module.registerAction((GenericAction)KnapsackExportAction.INSTANCE, TransportKnapsackExportAction.class, new Class[0]);
        module.registerAction((GenericAction)KnapsackPushAction.INSTANCE, TransportKnapsackPushAction.class, new Class[0]);
        module.registerAction((GenericAction)KnapsackImportAction.INSTANCE, TransportKnapsackImportAction.class, new Class[0]);
        module.registerAction((GenericAction)KnapsackPullAction.INSTANCE, TransportKnapsackPullAction.class, new Class[0]);
        module.registerAction((GenericAction)KnapsackStateAction.INSTANCE, TransportKnapsackStateAction.class, new Class[0]);
        module.registerAction((GenericAction)KnapsackAbortAction.INSTANCE, TransportKnapsackAbortAction.class, new Class[0]);
    }

    public void onModule(RestModule module) {
        module.addRestAction(RestKnapsackExportAction.class);
        module.addRestAction(RestKnapsackImportAction.class);
        module.addRestAction(RestKnapsackPushAction.class);
        module.addRestAction(RestKnapsackPullAction.class);
        module.addRestAction(RestKnapsackStateAction.class);
        module.addRestAction(RestKnapsackAbortAction.class);
    }

    public void onModule(ClusterDynamicSettingsModule module) {
        module.addDynamicSettings(new String[]{"plugin.knapsack.export.state"});
        module.addDynamicSettings(new String[]{"plugin.knapsack.import.state"});
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList modules = Lists.newArrayList();
        modules.add(KnapsackModule.class);
        return modules;
    }
}

