/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.rest.action.knapsack.exp;

import java.io.File;
import java.nio.file.Path;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.rest.action.support.RestToXContentListener;
import org.xbib.elasticsearch.action.knapsack.exp.KnapsackExportAction;
import org.xbib.elasticsearch.action.knapsack.exp.KnapsackExportRequest;
import org.xbib.elasticsearch.knapsack.KnapsackHelper;
import org.xbib.elasticsearch.knapsack.KnapsackParameter;

public class RestKnapsackExportAction
extends BaseRestHandler
implements KnapsackParameter {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)RestKnapsackExportAction.class.getSimpleName());

    @Inject
    public RestKnapsackExportAction(Settings settings, Client client, RestController controller) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_export", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_export", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_export", (RestHandler)this);
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        try {
            String index = request.param("index", "_all");
            String type = request.param("type");
            String defaultSpec = index + (type != null ? "_" + type : "") + ".tar.gz";
            File file = new File(request.param("path", defaultSpec));
            Path path = file.toPath();
            KnapsackExportRequest exportRequest = new KnapsackExportRequest().setIndex(index).setType(type).setPath(path).setOverwriteAllowed(request.paramAsBoolean("overwrite", false)).setEncodeEntry(request.paramAsBoolean("with_encoded_entry", true)).withMetadata(request.paramAsBoolean("with_metadata", true)).withAliases(request.paramAsBoolean("with_aliases", true)).setIndexTypeNames(KnapsackHelper.toMap(request.param("map"), logger)).setSearchRequest(this.toSearchRequest(request)).setBytesToTransfer(request.paramAsSize("bytes", ByteSizeValue.parseBytesSizeValue((String)"0")));
            client.admin().indices().execute((Action)KnapsackExportAction.INSTANCE, (ActionRequest)exportRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (Throwable ex) {
            try {
                logger.error(ex.getMessage(), ex, new Object[0]);
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, ex));
            }
            catch (Exception ex2) {
                logger.error(ex2.getMessage(), (Throwable)ex2, new Object[0]);
            }
        }
    }

    private SearchRequest toSearchRequest(RestRequest request) {
        request.params().put("size", request.param("max_bulk_actions_per_request", "1000"));
        SearchRequest searchRequest = RestSearchAction.parseSearchRequest((RestRequest)request);
        searchRequest.listenerThreaded(false);
        return searchRequest;
    }
}

