/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.rest.action.knapsack.imp;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.support.RestToXContentListener;
import org.xbib.elasticsearch.action.knapsack.imp.KnapsackImportAction;
import org.xbib.elasticsearch.action.knapsack.imp.KnapsackImportRequest;
import org.xbib.elasticsearch.knapsack.KnapsackHelper;
import org.xbib.elasticsearch.knapsack.KnapsackParameter;

public class RestKnapsackImportAction
extends BaseRestHandler
implements KnapsackParameter {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)RestKnapsackImportAction.class.getSimpleName());

    @Inject
    public RestKnapsackImportAction(Settings settings, Client client, RestController controller) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_import", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_import", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_import", (RestHandler)this);
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        try {
            String index = request.param("index", "_all");
            String type = request.param("type");
            String defaultSpec = index + (type != null ? "_" + type : "") + ".tar.gz";
            File file = new File(request.param("path", defaultSpec));
            Path path = file.toPath();
            KnapsackImportRequest importRequest = new KnapsackImportRequest().setIndex(index).setType(type).setPath(path).setTimeout(request.paramAsTime("timeout", TimeValue.timeValueSeconds((long)30L))).setMaxActionsPerBulkRequest(request.paramAsInt("max_bulk_actions_per_request", 1000)).setMaxBulkConcurrency(request.paramAsInt("max_bulk_concurrency", Runtime.getRuntime().availableProcessors() * 2)).setDecodeEntry(request.paramAsBoolean("with_encoded_entry", true)).withMetadata(request.paramAsBoolean("with_metadata", true)).setIndexTypeNames(KnapsackHelper.toMap(request.param("map"), logger));
            for (Map.Entry e : request.params().entrySet()) {
                if (((String)e.getKey()).endsWith("_settings")) {
                    importRequest.addIndexSettings((String)e.getKey(), (String)e.getValue());
                    continue;
                }
                if (!((String)e.getKey()).endsWith("_mapping")) continue;
                importRequest.addIndexTypeMapping((String)e.getKey(), (String)e.getValue());
            }
            client.admin().indices().execute((Action)KnapsackImportAction.INSTANCE, (ActionRequest)importRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (Throwable ex) {
            try {
                logger.error(ex.getMessage(), ex, new Object[0]);
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, ex));
            }
            catch (Exception ex2) {
                logger.error(ex2.getMessage(), (Throwable)ex2, new Object[0]);
            }
        }
    }
}

