/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.rest.action.knapsack.push;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.rest.action.support.RestToXContentListener;
import org.xbib.elasticsearch.action.knapsack.push.KnapsackPushAction;
import org.xbib.elasticsearch.action.knapsack.push.KnapsackPushRequest;
import org.xbib.elasticsearch.knapsack.KnapsackHelper;
import org.xbib.elasticsearch.knapsack.KnapsackParameter;

public class RestKnapsackPushAction
extends BaseRestHandler
implements KnapsackParameter {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)RestKnapsackPushAction.class.getSimpleName());

    @Inject
    public RestKnapsackPushAction(Settings settings, Client client, RestController controller) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_push", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_push", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_push", (RestHandler)this);
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        try {
            String index = request.param("index", "_all");
            String type = request.param("type");
            KnapsackPushRequest pushRequest = new KnapsackPushRequest().setIndex(index).setType(type).setHost(request.param("host", "localhost")).setPort(request.paramAsInt("port", 9300)).setCluster(request.param("cluster")).setSniff(request.paramAsBoolean("sniff", true)).setMaxActionsPerBulkRequest(request.paramAsInt("max_bulk_actions_per_request", 1000)).setMaxBulkConcurrency(request.paramAsInt("max_bulk_concurrency", Runtime.getRuntime().availableProcessors() * 2)).setTimeout(request.paramAsTime("timeout", TimeValue.timeValueSeconds((long)30L))).withMetadata(request.paramAsBoolean("with_metadata", true)).setIndexTypeNames(KnapsackHelper.toMap(request.param("map"), logger)).setSearchRequest(this.toSearchRequest(request));
            client.admin().indices().execute((Action)KnapsackPushAction.INSTANCE, (ActionRequest)pushRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (Throwable ex) {
            try {
                logger.error(ex.getMessage(), ex, new Object[0]);
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, ex));
            }
            catch (Exception ex2) {
                logger.error(ex2.getMessage(), (Throwable)ex2, new Object[0]);
            }
        }
    }

    private SearchRequest toSearchRequest(RestRequest request) {
        request.params().put("size", request.param("max_bulk_actions_per_request", "1000"));
        SearchRequest searchRequest = RestSearchAction.parseSearchRequest((RestRequest)request);
        searchRequest.listenerThreaded(false);
        return searchRequest;
    }
}

