/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.support.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.xbib.elasticsearch.support.client.BaseTransportClient;
import org.xbib.elasticsearch.support.client.ClientHelper;
import org.xbib.elasticsearch.support.client.Ingest;

public abstract class BaseIngestTransportClient
extends BaseTransportClient
implements Ingest {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)BaseIngestTransportClient.class.getSimpleName());

    @Override
    public Ingest newClient(Settings settings) {
        super.createClient(settings);
        return this;
    }

    @Override
    public BaseIngestTransportClient shards(int shards) {
        super.addSetting("index.number_of_shards", shards);
        return this;
    }

    @Override
    public BaseIngestTransportClient replica(int replica) {
        super.addSetting("index.number_of_replicas", replica);
        return this;
    }

    @Override
    public BaseIngestTransportClient newIndex(String index) {
        return this.newIndex(index, (Settings)null, (Map)null);
    }

    @Override
    public BaseIngestTransportClient newIndex(String index, String type, InputStream settings, InputStream mappings) throws IOException {
        this.configHelper.reset();
        this.configHelper.setting(settings);
        this.configHelper.mapping(type, mappings);
        return this.newIndex(index, this.configHelper.settings(), (Map)this.configHelper.mappings());
    }

    @Override
    public BaseIngestTransportClient newIndex(String index, Settings settings, Map<String, String> mappings) {
        if (this.client == null) {
            logger.warn("no client for create index", new Object[0]);
            return this;
        }
        if (index == null) {
            logger.warn("no index name given to create index", new Object[0]);
            return this;
        }
        CreateIndexRequestBuilder createIndexRequestBuilder = new CreateIndexRequestBuilder(this.client.admin().indices()).setIndex(index);
        Object concreteSettings = settings == null && this.getSettings() != null ? this.getSettings() : (settings != null ? settings : null);
        if (concreteSettings != null) {
            createIndexRequestBuilder.setSettings(this.getSettings());
        }
        if (mappings == null && this.getMappings() != null) {
            for (String type : this.getMappings().keySet()) {
                createIndexRequestBuilder.addMapping(type, this.getMappings().get(type));
            }
        } else if (mappings != null) {
            for (String type : mappings.keySet()) {
                createIndexRequestBuilder.addMapping(type, mappings.get(type));
            }
        }
        createIndexRequestBuilder.execute().actionGet();
        logger.info("index {} created with settings {} and {} mappings", new Object[]{index, concreteSettings != null ? concreteSettings.getAsMap() : "", mappings != null ? mappings.size() : 0});
        return this;
    }

    @Override
    public synchronized BaseIngestTransportClient deleteIndex(String index) {
        if (this.client == null) {
            logger.warn("no client for delete index", new Object[0]);
            return this;
        }
        if (index == null) {
            logger.warn("no index name given to delete index", new Object[0]);
            return this;
        }
        DeleteIndexRequestBuilder deleteIndexRequestBuilder = new DeleteIndexRequestBuilder(this.client.admin().indices(), new String[]{index});
        deleteIndexRequestBuilder.execute().actionGet();
        return this;
    }

    @Override
    public BaseIngestTransportClient putMapping(String index) {
        if (this.client == null) {
            logger.warn("no client for put mapping", new Object[0]);
            return this;
        }
        this.configHelper.putMapping((Client)this.client, index);
        return this;
    }

    @Override
    public BaseIngestTransportClient deleteMapping(String index, String type) {
        if (this.client == null) {
            logger.warn("no client for delete mapping", new Object[0]);
            return this;
        }
        this.configHelper.deleteMapping((Client)this.client, index, type);
        return this;
    }

    @Override
    public BaseIngestTransportClient waitForCluster(ClusterHealthStatus status, TimeValue timeValue) throws IOException {
        ClientHelper.waitForCluster((Client)this.client, status, timeValue);
        return this;
    }
}

