/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.support.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.xbib.elasticsearch.support.client.ClientHelper;
import org.xbib.elasticsearch.support.client.ConfigHelper;

public abstract class BaseTransportClient {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)BaseTransportClient.class.getSimpleName());
    private final Set<InetSocketTransportAddress> addresses = Sets.newHashSet();
    protected TransportClient client;
    protected ConfigHelper configHelper = new ConfigHelper();

    protected void createClient(Settings settings) {
        if (this.client != null) {
            logger.warn("client is open, closing...", new Object[0]);
            this.client.close();
            this.client.threadPool().shutdown();
            logger.warn("client is closed", new Object[0]);
            this.client = null;
        }
        if (settings != null) {
            logger.info("creating transport client, java version {}, effective settings {}", new Object[]{System.getProperty("java.version"), settings.getAsMap()});
            this.client = new TransportClient(settings, false);
            logger.info("transport client settings = {}", new Object[]{this.client.settings().getAsMap()});
        } else {
            logger.info("creating transport client, java version {}, using default settings", new Object[]{System.getProperty("java.version")});
            this.client = new TransportClient();
        }
        try {
            this.connect(settings);
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (SocketException e) {
            logger.error(e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public Client client() {
        return this.client;
    }

    public List<String> getConnectedNodes() {
        return ClientHelper.getConnectedNodes(this.client);
    }

    public synchronized void shutdown() {
        if (this.client != null) {
            logger.debug("shutdown started", new Object[0]);
            this.client.close();
            this.client.threadPool().shutdown();
            this.client = null;
            logger.debug("shutdown complete", new Object[0]);
        }
        this.addresses.clear();
    }

    protected Settings findSettings() {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        settingsBuilder.put("host", "localhost");
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            logger.debug("the hostname is {}", new Object[]{hostname});
            settingsBuilder.put("host", hostname).put("port", 9300);
        }
        catch (UnknownHostException e) {
            logger.warn("can't resolve host name, probably something wrong with network config: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e, new Object[0]);
        }
        return settingsBuilder.build();
    }

    protected void connect(Settings settings) throws IOException {
        String hostname = settings.get("host");
        int port = settings.getAsInt("port", Integer.valueOf(9300));
        switch (hostname) {
            case "hostname": {
                InetSocketTransportAddress address = new InetSocketTransportAddress(InetAddress.getLocalHost().getHostName(), port);
                if (this.addresses.contains(address)) break;
                logger.info("adding hostname address for transport client: {}", new Object[]{address});
                this.client.addTransportAddress((TransportAddress)address);
                this.addresses.add(address);
                break;
            }
            case "interfaces": {
                InetSocketTransportAddress address;
                Enumeration<InetAddress> inetAddresses;
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                for (NetworkInterface netint : Collections.list(nets)) {
                    logger.info("checking network interface = {}", new Object[]{netint.getName()});
                    inetAddresses = netint.getInetAddresses();
                    for (InetAddress addr : Collections.list(inetAddresses)) {
                        logger.info("checking address = {}", new Object[]{addr.getHostAddress()});
                        address = new InetSocketTransportAddress(addr, port);
                        if (this.addresses.contains(address)) continue;
                        logger.info("adding address to transport client: {}", new Object[]{address});
                        this.client.addTransportAddress((TransportAddress)address);
                        this.addresses.add(address);
                    }
                }
                break;
            }
            case "inet4": {
                InetSocketTransportAddress address;
                Enumeration<InetAddress> inetAddresses;
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                for (NetworkInterface netint : Collections.list(nets)) {
                    logger.info("checking network interface = {}", new Object[]{netint.getName()});
                    inetAddresses = netint.getInetAddresses();
                    for (InetAddress addr : Collections.list(inetAddresses)) {
                        if (!(addr instanceof Inet4Address)) continue;
                        logger.info("checking address = {}", new Object[]{addr.getHostAddress()});
                        address = new InetSocketTransportAddress(addr, port);
                        if (this.addresses.contains(address)) continue;
                        logger.info("adding address for transport client: {}", new Object[]{address});
                        this.client.addTransportAddress((TransportAddress)address);
                        this.addresses.add(address);
                    }
                }
                break;
            }
            case "inet6": {
                InetSocketTransportAddress address;
                Enumeration<InetAddress> inetAddresses;
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                for (NetworkInterface netint : Collections.list(nets)) {
                    logger.info("checking network interface = {}", new Object[]{netint.getName()});
                    inetAddresses = netint.getInetAddresses();
                    for (InetAddress addr : Collections.list(inetAddresses)) {
                        if (!(addr instanceof Inet6Address)) continue;
                        logger.info("checking address = {}", new Object[]{addr.getHostAddress()});
                        address = new InetSocketTransportAddress(addr, port);
                        if (this.addresses.contains(address)) continue;
                        logger.info("adding address for transport client: {}", new Object[]{address});
                        this.client.addTransportAddress((TransportAddress)address);
                        this.addresses.add(address);
                    }
                }
                break;
            }
            default: {
                InetSocketTransportAddress address = new InetSocketTransportAddress(hostname, port);
                if (this.addresses.contains(address)) break;
                logger.info("adding custom address for transport client: {}", new Object[]{address});
                this.client.addTransportAddress((TransportAddress)address);
                this.addresses.add(address);
                break;
            }
        }
        long timeout = settings.getAsTime("timeout", settings.getAsTime("client.transport.ping_timeout", TimeValue.timeValueSeconds((long)10L))).millis();
        logger.info("configured addresses to connect = {}, waiting for {} to connect ...", new Object[]{this.addresses, TimeValue.timeValueMillis((long)timeout).format()});
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("interrupted", new Object[0]);
        }
        if (this.client.connectedNodes() != null) {
            ImmutableList nodes = this.client.connectedNodes().asList();
            logger.info("connected nodes = {}", new Object[]{nodes});
            for (DiscoveryNode node : nodes) {
                logger.info("new connection to {}", new Object[]{node});
            }
            if (!(nodes.isEmpty() || settings.get("sniff") == null && settings.get("es.sniff") == null && settings.get("client.transport.sniff") == null)) {
                try {
                    this.connectMore();
                }
                catch (Exception e) {
                    logger.error("error while connecting to more nodes", (Throwable)e, new Object[0]);
                }
            }
        }
    }

    public ImmutableSettings.Builder getSettingsBuilder() {
        return this.configHelper.settingsBuilder();
    }

    public void resetSettings() {
        this.configHelper.reset();
    }

    public void setting(InputStream in) throws IOException {
        this.configHelper.setting(in);
    }

    public void addSetting(String key, String value) {
        this.configHelper.setting(key, value);
    }

    public void addSetting(String key, Boolean value) {
        this.configHelper.setting(key, value);
    }

    public void addSetting(String key, Integer value) {
        this.configHelper.setting(key, value);
    }

    public void setSettings(Settings settings) {
        this.configHelper.settings(settings);
    }

    public Settings getSettings() {
        return this.configHelper.settings();
    }

    public void mapping(String type, String mapping) throws IOException {
        this.configHelper.mapping(type, mapping);
    }

    public void mapping(String type, InputStream in) throws IOException {
        this.configHelper.mapping(type, in);
    }

    public Map<String, String> getMappings() {
        return this.configHelper.mappings();
    }

    private void connectMore() throws IOException {
        logger.info("trying to discover more nodes...", new Object[0]);
        ClusterStateResponse clusterStateResponse = (ClusterStateResponse)this.client.admin().cluster().state(new ClusterStateRequest()).actionGet();
        DiscoveryNodes nodes = clusterStateResponse.getState().getNodes();
        for (DiscoveryNode node : nodes) {
            logger.info("adding discovered node {}", new Object[]{node});
            try {
                this.client.addTransportAddress(node.address());
            }
            catch (Exception e) {
                logger.warn("can't add node " + node, (Throwable)e, new Object[0]);
            }
        }
        logger.info("... discovery done", new Object[0]);
    }
}

