/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.support.client;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public class ClientHelper {
    public static List<String> getConnectedNodes(TransportClient client) {
        LinkedList nodes = Lists.newLinkedList();
        if (client.connectedNodes() != null) {
            for (DiscoveryNode discoveryNode : client.connectedNodes()) {
                nodes.add(discoveryNode.toString());
            }
        }
        return nodes;
    }

    public static void updateIndexSetting(Client client, String index, String key, Object value) throws IOException {
        if (client == null) {
            throw new IOException("no client");
        }
        if (index == null) {
            throw new IOException("no index name given");
        }
        if (key == null) {
            throw new IOException("no key given");
        }
        if (value == null) {
            throw new IOException("no value given");
        }
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        settingsBuilder.put(key, value.toString());
        UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(new String[]{index}).settings((Settings.Builder)settingsBuilder);
        client.admin().indices().updateSettings(updateSettingsRequest).actionGet();
    }

    public static int waitForRecovery(Client client, String index) throws IOException {
        if (index == null) {
            throw new IOException("unable to waitfor recovery, index not set");
        }
        RecoveryResponse response = (RecoveryResponse)client.admin().indices().prepareRecoveries(new String[]{index}).execute().actionGet();
        int shards = response.getTotalShards();
        client.admin().cluster().prepareHealth(new String[]{index}).setWaitForActiveShards(shards).execute().actionGet();
        return shards;
    }

    public static void waitForCluster(Client client, ClusterHealthStatus status, TimeValue timeout) throws IOException {
        try {
            ClusterHealthResponse healthResponse = (ClusterHealthResponse)client.admin().cluster().prepareHealth(new String[0]).setWaitForStatus(status).setTimeout(timeout).execute().actionGet();
            if (healthResponse != null && healthResponse.isTimedOut()) {
                throw new IOException("cluster state is " + healthResponse.getStatus().name() + " and not " + status.name() + ", cowardly refusing to continue with operations");
            }
        }
        catch (ElasticsearchTimeoutException e) {
            throw new IOException("timeout, cluster does not respond to health request, cowardly refusing to continue with operations");
        }
    }

    public static String clusterName(Client client) {
        try {
            ClusterStateRequestBuilder clusterStateRequestBuilder = new ClusterStateRequestBuilder(client.admin().cluster()).all();
            ClusterStateResponse clusterStateResponse = (ClusterStateResponse)clusterStateRequestBuilder.execute().actionGet();
            String name = clusterStateResponse.getClusterName().value();
            int nodeCount = clusterStateResponse.getState().getNodes().size();
            return name + " (" + nodeCount + " nodes connected)";
        }
        catch (ElasticsearchTimeoutException e) {
            return "TIMEOUT";
        }
        catch (NoNodeAvailableException e) {
            return "DISCONNECTED";
        }
        catch (Throwable t) {
            return "[" + t.getMessage() + "]";
        }
    }

    public static String healthColor(Client client) {
        try {
            ClusterHealthResponse healthResponse = (ClusterHealthResponse)client.admin().cluster().prepareHealth(new String[0]).setTimeout(TimeValue.timeValueSeconds((long)30L)).execute().actionGet();
            ClusterHealthStatus status = healthResponse.getStatus();
            return status.name();
        }
        catch (ElasticsearchTimeoutException e) {
            return "TIMEOUT";
        }
        catch (NoNodeAvailableException e) {
            return "DISCONNECTED";
        }
        catch (Throwable t) {
            return "[" + t.getMessage() + "]";
        }
    }

    public static int updateReplicaLevel(Client client, String index, int level) throws IOException {
        ClientHelper.waitForCluster(client, ClusterHealthStatus.YELLOW, TimeValue.timeValueSeconds((long)30L));
        ClientHelper.updateIndexSetting(client, index, "number_of_replicas", level);
        return ClientHelper.waitForRecovery(client, index);
    }

    public static void disableRefresh(Client client, String index) throws IOException {
        ClientHelper.updateIndexSetting(client, index, "refresh_interval", -1);
    }

    public static void enableRefresh(Client client, String index) throws IOException {
        ClientHelper.updateIndexSetting(client, index, "refresh_interval", 1000);
    }

    public static void flush(Client client, String index) {
        ((FlushRequestBuilder)client.admin().indices().prepareFlush(new String[0]).setIndices(new String[]{index})).execute().actionGet();
    }

    public static void refresh(Client client, String index) {
        ((RefreshRequestBuilder)client.admin().indices().prepareRefresh(new String[0]).setIndices(new String[]{index})).setForce(true).execute().actionGet();
    }
}

