/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.support.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class ConfigHelper {
    private ImmutableSettings.Builder settingsBuilder;
    private Settings settings;
    private Map<String, String> mappings = Maps.newHashMap();

    public ConfigHelper reset() {
        this.settingsBuilder = ImmutableSettings.settingsBuilder();
        this.settings = null;
        this.mappings = Maps.newHashMap();
        return this;
    }

    public ConfigHelper settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public ConfigHelper setting(String key, String value) {
        if (this.settingsBuilder == null) {
            this.settingsBuilder = ImmutableSettings.settingsBuilder();
        }
        this.settingsBuilder.put(key, value);
        return this;
    }

    public ConfigHelper setting(String key, Boolean value) {
        if (this.settingsBuilder == null) {
            this.settingsBuilder = ImmutableSettings.settingsBuilder();
        }
        this.settingsBuilder.put(key, value.booleanValue());
        return this;
    }

    public ConfigHelper setting(String key, Integer value) {
        if (this.settingsBuilder == null) {
            this.settingsBuilder = ImmutableSettings.settingsBuilder();
        }
        this.settingsBuilder.put(key, value.intValue());
        return this;
    }

    public ConfigHelper setting(InputStream in) throws IOException {
        this.settingsBuilder = ImmutableSettings.settingsBuilder().loadFromStream(".json", in);
        return this;
    }

    public ImmutableSettings.Builder settingsBuilder() {
        return this.settingsBuilder != null ? this.settingsBuilder : ImmutableSettings.settingsBuilder();
    }

    public Settings settings() {
        if (this.settings != null) {
            return this.settings;
        }
        if (this.settingsBuilder == null) {
            this.settingsBuilder = ImmutableSettings.settingsBuilder();
        }
        return this.settingsBuilder.build();
    }

    public ConfigHelper mapping(String type, String mapping) throws IOException {
        this.mappings.put(type, mapping);
        return this;
    }

    public ConfigHelper mapping(String type, InputStream in) throws IOException {
        if (type == null) {
            return this;
        }
        StringWriter sw = new StringWriter();
        Streams.copy((Reader)new InputStreamReader(in), (Writer)sw);
        this.mappings.put(type, sw.toString());
        return this;
    }

    public ConfigHelper putMapping(Client client, String index) {
        if (!this.mappings.isEmpty()) {
            for (Map.Entry<String, String> me : this.mappings.entrySet()) {
                client.admin().indices().putMapping(new PutMappingRequest(new String[]{index}).type(me.getKey()).source(me.getValue())).actionGet();
            }
        }
        return this;
    }

    public ConfigHelper deleteMappings(Client client, String index) {
        if (!this.mappings.isEmpty()) {
            for (Map.Entry<String, String> me : this.mappings.entrySet()) {
                client.admin().indices().deleteMapping(new DeleteMappingRequest(new String[]{index}).types(new String[]{me.getKey()})).actionGet();
            }
        }
        return this;
    }

    public ConfigHelper deleteMapping(Client client, String index, String type) {
        client.admin().indices().deleteMapping(new DeleteMappingRequest(new String[]{index}).types(new String[]{type})).actionGet();
        return this;
    }

    public Map<String, String> mappings() {
        return this.mappings.isEmpty() ? null : this.mappings;
    }
}

