/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.support.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;

public class State {
    private final Set<String> indexNames = Collections.synchronizedSet(new HashSet());
    private final MeanMetric totalIngest = new MeanMetric();
    private final CounterMetric totalIngestSizeInBytes = new CounterMetric();
    private final CounterMetric currentIngest = new CounterMetric();
    private final CounterMetric currentIngestNumDocs = new CounterMetric();
    private final CounterMetric submitted = new CounterMetric();
    private final CounterMetric succeeded = new CounterMetric();
    private final CounterMetric failed = new CounterMetric();

    public MeanMetric getTotalIngest() {
        return this.totalIngest;
    }

    public CounterMetric getTotalIngestSizeInBytes() {
        return this.totalIngestSizeInBytes;
    }

    public CounterMetric getCurrentIngest() {
        return this.currentIngest;
    }

    public CounterMetric getCurrentIngestNumDocs() {
        return this.currentIngestNumDocs;
    }

    public CounterMetric getSubmitted() {
        return this.submitted;
    }

    public CounterMetric getSucceeded() {
        return this.succeeded;
    }

    public CounterMetric getFailed() {
        return this.failed;
    }

    public State startBulk(String indexName) {
        this.indexNames.add(indexName);
        return this;
    }

    public boolean isBulk(String indexName) {
        return this.indexNames.contains(indexName);
    }

    public State stopBulk(String indexName) {
        this.indexNames.remove(indexName);
        return this;
    }

    public Set<String> indices() {
        return this.indexNames;
    }
}

