/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.support.client.bulk;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.TimeValue;

public class BulkProcessorHelper {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)BulkProcessorHelper.class.getSimpleName());

    public static void flush(BulkProcessor bulkProcessor) {
        try {
            Field field = bulkProcessor.getClass().getDeclaredField("bulkRequest");
            if (field != null) {
                Method method;
                field.setAccessible(true);
                BulkRequest bulkRequest = (BulkRequest)field.get(bulkProcessor);
                if (bulkRequest.numberOfActions() > 0 && (method = bulkProcessor.getClass().getDeclaredMethod("execute", new Class[0])) != null) {
                    method.setAccessible(true);
                    method.invoke((Object)bulkProcessor, new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitFor(BulkProcessor bulkProcessor, TimeValue maxWait) {
        Semaphore semaphore = null;
        boolean acquired = false;
        try {
            Field field = bulkProcessor.getClass().getDeclaredField("semaphore");
            if (field != null) {
                field.setAccessible(true);
                Field concurrentField = bulkProcessor.getClass().getDeclaredField("concurrentRequests");
                concurrentField.setAccessible(true);
                int concurrency = concurrentField.getInt(bulkProcessor);
                if (concurrency > 1) {
                    semaphore = (Semaphore)field.get(bulkProcessor);
                    acquired = semaphore.tryAcquire(concurrency, maxWait.getMillis(), TimeUnit.MILLISECONDS);
                    boolean bl = semaphore.availablePermits() == concurrency;
                    return bl;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("interrupted", new Object[0]);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e, new Object[0]);
        }
        finally {
            if (semaphore != null && acquired) {
                semaphore.release();
            }
        }
        return false;
    }
}

