/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.support.client.bulk;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.xbib.elasticsearch.support.client.BaseIngestTransportClient;
import org.xbib.elasticsearch.support.client.ClientHelper;
import org.xbib.elasticsearch.support.client.Ingest;
import org.xbib.elasticsearch.support.client.State;
import org.xbib.elasticsearch.support.client.bulk.BulkProcessorHelper;

public class BulkTransportClient
extends BaseIngestTransportClient
implements Ingest {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)BulkTransportClient.class.getSimpleName());
    private int maxActionsPerBulkRequest = 100;
    private int maxConcurrentBulkRequests = Runtime.getRuntime().availableProcessors() * 2;
    private ByteSizeValue maxVolumePerBulkRequest = new ByteSizeValue(10L, ByteSizeUnit.MB);
    private TimeValue flushInterval = TimeValue.timeValueSeconds((long)30L);
    private final AtomicLong concurrentRequestCounter = new AtomicLong(0L);
    private BulkProcessor bulkProcessor;
    private State state = new State();
    private Throwable throwable;
    private boolean closed = false;

    @Override
    public BulkTransportClient maxActionsPerBulkRequest(int maxActionsPerBulkRequest) {
        this.maxActionsPerBulkRequest = maxActionsPerBulkRequest;
        return this;
    }

    @Override
    public BulkTransportClient maxConcurrentBulkRequests(int maxConcurrentBulkRequests) {
        this.maxConcurrentBulkRequests = maxConcurrentBulkRequests;
        return this;
    }

    @Override
    public BulkTransportClient maxVolumePerBulkRequest(ByteSizeValue maxVolumePerBulkRequest) {
        this.maxVolumePerBulkRequest = maxVolumePerBulkRequest;
        return this;
    }

    @Override
    public BulkTransportClient maxRequestWait(TimeValue timeout) {
        return this;
    }

    @Override
    public BulkTransportClient flushIngestInterval(TimeValue flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    @Override
    public BulkTransportClient newClient(Client client) {
        return this.newClient(this.findSettings());
    }

    @Override
    public BulkTransportClient newClient(Map<String, String> settings) {
        return this.newClient(ImmutableSettings.settingsBuilder().put(settings).build());
    }

    @Override
    public BulkTransportClient newClient(Settings settings) {
        super.newClient(settings);
        this.resetSettings();
        this.state = new State();
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                long l = BulkTransportClient.this.concurrentRequestCounter.getAndIncrement();
                if (BulkTransportClient.this.state != null) {
                    int n = request.numberOfActions();
                    BulkTransportClient.this.state.getSubmitted().inc((long)n);
                    BulkTransportClient.this.state.getCurrentIngestNumDocs().inc((long)n);
                    BulkTransportClient.this.state.getTotalIngestSizeInBytes().inc(request.estimatedSizeInBytes());
                }
                if (logger.isInfoEnabled()) {
                    logger.info("before bulk [{}] [actions={}] [bytes={}] [concurrent requests={}]", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes(), l});
                }
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                long l = BulkTransportClient.this.concurrentRequestCounter.decrementAndGet();
                if (BulkTransportClient.this.state != null) {
                    BulkTransportClient.this.state.getSucceeded().inc((long)response.getItems().length);
                    BulkTransportClient.this.state.getTotalIngest().inc(response.getTookInMillis());
                }
                int n = 0;
                for (BulkItemResponse itemResponse : response.getItems()) {
                    if (!itemResponse.isFailed()) continue;
                    ++n;
                    BulkTransportClient.this.state.getSucceeded().dec(1L);
                    BulkTransportClient.this.state.getFailed().inc(1L);
                }
                if (logger.isInfoEnabled()) {
                    logger.info("after bulk [{}] [succeeded={}] [failed={}] [{}ms] [concurrent requests={}]", new Object[]{executionId, BulkTransportClient.this.state.getSucceeded().count(), BulkTransportClient.this.state.getFailed().count(), response.getTook().millis(), l});
                }
                if (n > 0) {
                    logger.error("bulk [{}] failed with {} failed items, failure message = {}", new Object[]{executionId, n, response.buildFailureMessage()});
                } else {
                    BulkTransportClient.this.state.getCurrentIngestNumDocs().dec((long)response.getItems().length);
                }
            }

            public void afterBulk(long executionId, BulkRequest requst, Throwable failure) {
                BulkTransportClient.this.concurrentRequestCounter.decrementAndGet();
                BulkTransportClient.this.throwable = failure;
                BulkTransportClient.this.closed = true;
                logger.error("bulk [" + executionId + "] error", failure, new Object[0]);
            }
        };
        BulkProcessor.Builder builder = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)listener).setBulkActions(this.maxActionsPerBulkRequest).setConcurrentRequests(this.maxConcurrentBulkRequests).setFlushInterval(this.flushInterval);
        if (this.maxVolumePerBulkRequest != null) {
            builder.setBulkSize(this.maxVolumePerBulkRequest);
        }
        this.bulkProcessor = builder.build();
        this.closed = false;
        return this;
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public BulkTransportClient shards(int value) {
        super.shards(value);
        return this;
    }

    @Override
    public BulkTransportClient replica(int value) {
        super.replica(value);
        return this;
    }

    @Override
    public BulkTransportClient newIndex(String index) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        super.newIndex(index);
        return this;
    }

    @Override
    public BulkTransportClient deleteIndex(String index) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        super.deleteIndex(index);
        return this;
    }

    @Override
    public BulkTransportClient startBulk(String index) throws IOException {
        if (this.state == null) {
            return this;
        }
        if (!this.state.isBulk(index)) {
            this.state.startBulk(index);
            ClientHelper.disableRefresh((Client)this.client, index);
        }
        return this;
    }

    @Override
    public BulkTransportClient stopBulk(String index) throws IOException {
        if (this.state == null) {
            return this;
        }
        if (this.state.isBulk(index)) {
            this.state.stopBulk(index);
            ClientHelper.enableRefresh((Client)this.client, index);
        }
        return this;
    }

    @Override
    public BulkTransportClient flush(String index) {
        ClientHelper.flush((Client)this.client, index);
        return this;
    }

    @Override
    public BulkTransportClient refresh(String index) {
        ClientHelper.refresh((Client)this.client, index);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkTransportClient index(String index, String type, String id, String source) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        try {
            this.state.getCurrentIngest().inc();
            this.bulkProcessor.add(new IndexRequest(index).type(type).id(id).create(false).source(source));
        }
        catch (Exception e) {
            this.throwable = e;
            this.closed = true;
            logger.error("bulk add of index request failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            this.state.getCurrentIngest().dec();
        }
        return this;
    }

    @Override
    public BulkTransportClient bulkIndex(IndexRequest indexRequest) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        try {
            this.state.getCurrentIngest().inc();
            this.bulkProcessor.add(indexRequest);
        }
        catch (Exception e) {
            this.throwable = e;
            this.closed = true;
            logger.error("bulk add of index request failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            this.state.getCurrentIngest().dec();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkTransportClient delete(String index, String type, String id) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        try {
            this.state.getCurrentIngest().inc();
            this.bulkProcessor.add(new DeleteRequest(index).type(type).id(id));
        }
        catch (Exception e) {
            this.throwable = e;
            this.closed = true;
            logger.error("bulk add of delete request failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            this.state.getCurrentIngest().dec();
        }
        return this;
    }

    @Override
    public BulkTransportClient bulkDelete(DeleteRequest deleteRequest) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        try {
            this.state.getCurrentIngest().inc();
            this.bulkProcessor.add(deleteRequest);
        }
        catch (Exception e) {
            this.throwable = e;
            this.closed = true;
            logger.error("bulk add of delete request failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            this.state.getCurrentIngest().dec();
        }
        return this;
    }

    @Override
    public synchronized BulkTransportClient flushIngest() {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        if (this.client == null) {
            logger.warn("no client", new Object[0]);
            return this;
        }
        logger.info("flushing bulk processor", new Object[0]);
        BulkProcessorHelper.flush(this.bulkProcessor);
        return this;
    }

    @Override
    public synchronized BulkTransportClient waitForResponses(TimeValue maxWaitTime) throws InterruptedException {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        if (this.client == null) {
            logger.warn("no client", new Object[0]);
            return this;
        }
        BulkProcessorHelper.waitFor(this.bulkProcessor, maxWaitTime);
        return this;
    }

    @Override
    public BulkTransportClient waitForCluster(ClusterHealthStatus status, TimeValue timeValue) throws IOException {
        ClientHelper.waitForCluster((Client)this.client, status, timeValue);
        return this;
    }

    @Override
    public int waitForRecovery(String index) throws IOException {
        return ClientHelper.waitForRecovery((Client)this.client, index);
    }

    @Override
    public int updateReplicaLevel(String index, int level) throws IOException {
        return ClientHelper.updateReplicaLevel((Client)this.client, index, level);
    }

    @Override
    public synchronized void shutdown() {
        if (this.closed) {
            super.shutdown();
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        if (this.client == null) {
            logger.warn("no client", new Object[0]);
            return;
        }
        try {
            if (this.bulkProcessor != null) {
                logger.info("closing bulk processor...", new Object[0]);
                this.bulkProcessor.close();
            }
            if (this.state.indices() != null && !this.state.indices().isEmpty()) {
                logger.info("stopping bulk mode for indices {}...", new Object[]{this.state.indices()});
                for (String index : ImmutableSet.copyOf(this.state.indices())) {
                    this.stopBulk(index);
                }
            }
            logger.info("shutting down...", new Object[0]);
            super.shutdown();
            logger.info("shutting down completed", new Object[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public boolean hasThrowable() {
        return this.throwable != null;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

