/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elasticsearch.support.client.node;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.xbib.elasticsearch.support.client.ClientHelper;
import org.xbib.elasticsearch.support.client.ConfigHelper;
import org.xbib.elasticsearch.support.client.Ingest;
import org.xbib.elasticsearch.support.client.State;
import org.xbib.elasticsearch.support.client.bulk.BulkProcessorHelper;

public class BulkNodeClient
implements Ingest {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)BulkNodeClient.class.getSimpleName());
    private int maxActionsPerBulkRequest = 100;
    private int maxConcurrentBulkRequests = Runtime.getRuntime().availableProcessors() * 2;
    private ByteSizeValue maxVolume = new ByteSizeValue(10L, ByteSizeUnit.MB);
    private TimeValue flushInterval = TimeValue.timeValueSeconds((long)30L);
    private final ConfigHelper configHelper = new ConfigHelper();
    private final AtomicLong concurrentRequestCounter = new AtomicLong(0L);
    private Client client;
    private BulkProcessor bulkProcessor;
    private State state = new State();
    private boolean closed = false;
    private Throwable throwable;

    @Override
    public BulkNodeClient shards(int shards) {
        this.configHelper.setting("index.number_of_shards", shards);
        return this;
    }

    @Override
    public BulkNodeClient replica(int replica) {
        this.configHelper.setting("index.number_of_replica", replica);
        return this;
    }

    @Override
    public BulkNodeClient maxActionsPerBulkRequest(int maxActionsPerBulkRequest) {
        this.maxActionsPerBulkRequest = maxActionsPerBulkRequest;
        return this;
    }

    @Override
    public BulkNodeClient maxConcurrentBulkRequests(int maxConcurrentBulkRequests) {
        this.maxConcurrentBulkRequests = maxConcurrentBulkRequests;
        return this;
    }

    @Override
    public BulkNodeClient maxVolumePerBulkRequest(ByteSizeValue maxVolume) {
        this.maxVolume = maxVolume;
        return this;
    }

    @Override
    public BulkNodeClient maxRequestWait(TimeValue timeValue) {
        return this;
    }

    @Override
    public BulkNodeClient flushIngestInterval(TimeValue flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    @Override
    public BulkNodeClient newClient(Settings settings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BulkNodeClient newClient(Map<String, String> client) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BulkNodeClient newClient(Client client) {
        this.client = client;
        this.state = new State();
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                long l = BulkNodeClient.this.concurrentRequestCounter.getAndIncrement();
                int n = request.numberOfActions();
                BulkNodeClient.this.state.getSubmitted().inc((long)n);
                BulkNodeClient.this.state.getCurrentIngestNumDocs().inc((long)n);
                BulkNodeClient.this.state.getTotalIngestSizeInBytes().inc(request.estimatedSizeInBytes());
                if (logger.isInfoEnabled()) {
                    logger.info("before bulk [{}] [actions={}] [bytes={}] [concurrent requests={}]", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes(), l});
                }
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                long l = BulkNodeClient.this.concurrentRequestCounter.decrementAndGet();
                BulkNodeClient.this.state.getSucceeded().inc((long)response.getItems().length);
                BulkNodeClient.this.state.getFailed().inc(0L);
                BulkNodeClient.this.state.getTotalIngest().inc(response.getTookInMillis());
                int n = 0;
                for (BulkItemResponse itemResponse : response.getItems()) {
                    if (!itemResponse.isFailed()) continue;
                    ++n;
                    BulkNodeClient.this.state.getSucceeded().dec(1L);
                    BulkNodeClient.this.state.getFailed().inc(1L);
                }
                if (logger.isInfoEnabled()) {
                    logger.info("after bulk [{}] [succeeded={}] [failed={}] [{}ms] {} concurrent requests", new Object[]{executionId, BulkNodeClient.this.state.getSucceeded().count(), BulkNodeClient.this.state.getFailed().count(), response.getTook().millis(), l});
                }
                if (n > 0) {
                    logger.error("bulk [{}] failed with {} failed items, failure message = {}", new Object[]{executionId, n, response.buildFailureMessage()});
                } else {
                    BulkNodeClient.this.state.getCurrentIngestNumDocs().dec((long)response.getItems().length);
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                BulkNodeClient.this.concurrentRequestCounter.decrementAndGet();
                BulkNodeClient.this.throwable = failure;
                BulkNodeClient.this.closed = true;
                logger.error("after bulk [" + executionId + "] error", failure, new Object[0]);
            }
        };
        BulkProcessor.Builder builder = BulkProcessor.builder((Client)client, (BulkProcessor.Listener)listener).setBulkActions(this.maxActionsPerBulkRequest).setConcurrentRequests(this.maxConcurrentBulkRequests).setFlushInterval(this.flushInterval);
        if (this.maxVolume != null) {
            builder.setBulkSize(this.maxVolume);
        }
        this.bulkProcessor = builder.build();
        try {
            this.waitForCluster(ClusterHealthStatus.YELLOW, TimeValue.timeValueSeconds((long)30L));
            this.closed = false;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e, new Object[0]);
            this.closed = true;
        }
        return this;
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public BulkNodeClient putMapping(String index) {
        if (this.client == null) {
            logger.warn("no client for put mapping", new Object[0]);
            return this;
        }
        this.configHelper.putMapping(this.client, index);
        return this;
    }

    @Override
    public BulkNodeClient deleteMapping(String index, String type) {
        if (this.client == null) {
            logger.warn("no client for delete mapping", new Object[0]);
            return this;
        }
        this.configHelper.deleteMapping(this.client, index, type);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkNodeClient index(String index, String type, String id, String source) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        try {
            if (this.state != null) {
                this.state.getCurrentIngest().inc();
            }
            this.bulkProcessor.add(new IndexRequest(index).type(type).id(id).create(false).source(source));
        }
        catch (Exception e) {
            this.throwable = e;
            this.closed = true;
            logger.error("bulk add of index request failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            if (this.state != null) {
                this.state.getCurrentIngest().dec();
            }
        }
        return this;
    }

    @Override
    public BulkNodeClient bulkIndex(IndexRequest indexRequest) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        try {
            if (this.state != null) {
                this.state.getCurrentIngest().inc();
            }
            this.bulkProcessor.add(indexRequest);
        }
        catch (Exception e) {
            this.throwable = e;
            this.closed = true;
            logger.error("bulk add of index request failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            if (this.state != null) {
                this.state.getCurrentIngest().dec();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkNodeClient delete(String index, String type, String id) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        try {
            if (this.state != null) {
                this.state.getCurrentIngest().inc();
            }
            this.bulkProcessor.add(new DeleteRequest(index).type(type).id(id));
        }
        catch (Exception e) {
            this.throwable = e;
            this.closed = true;
            logger.error("bulk add of delete failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            if (this.state != null) {
                this.state.getCurrentIngest().dec();
            }
        }
        return this;
    }

    @Override
    public BulkNodeClient bulkDelete(DeleteRequest deleteRequest) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        try {
            if (this.state != null) {
                this.state.getCurrentIngest().inc();
            }
            this.bulkProcessor.add(deleteRequest);
        }
        catch (Exception e) {
            this.throwable = e;
            this.closed = true;
            logger.error("bulk add of delete failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            if (this.state != null) {
                this.state.getCurrentIngest().dec();
            }
        }
        return this;
    }

    @Override
    public BulkNodeClient flushIngest() {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        logger.info("flushing bulk processor", new Object[0]);
        BulkProcessorHelper.flush(this.bulkProcessor);
        return this;
    }

    @Override
    public BulkNodeClient waitForResponses(TimeValue maxWaitTime) throws InterruptedException {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        BulkProcessorHelper.waitFor(this.bulkProcessor, maxWaitTime);
        return this;
    }

    @Override
    public BulkNodeClient startBulk(String index) throws IOException {
        if (this.state == null) {
            return this;
        }
        if (!this.state.isBulk(index)) {
            this.state.startBulk(index);
            ClientHelper.disableRefresh(this.client, index);
        }
        return this;
    }

    @Override
    public BulkNodeClient stopBulk(String index) throws IOException {
        if (this.state == null) {
            return this;
        }
        if (this.state.isBulk(index)) {
            this.state.stopBulk(index);
            ClientHelper.enableRefresh(this.client, index);
        }
        return this;
    }

    @Override
    public BulkNodeClient flush(String index) {
        ClientHelper.flush(this.client, index);
        return this;
    }

    @Override
    public BulkNodeClient refresh(String index) {
        ClientHelper.refresh(this.client, index);
        return this;
    }

    @Override
    public int updateReplicaLevel(String index, int level) throws IOException {
        return ClientHelper.updateReplicaLevel(this.client, index, level);
    }

    @Override
    public BulkNodeClient waitForCluster(ClusterHealthStatus status, TimeValue timeout) throws IOException {
        ClientHelper.waitForCluster(this.client, status, timeout);
        return this;
    }

    @Override
    public int waitForRecovery(String index) throws IOException {
        return ClientHelper.waitForRecovery(this.client, index);
    }

    @Override
    public synchronized void shutdown() {
        try {
            if (this.bulkProcessor != null) {
                logger.info("closing bulk processor...", new Object[0]);
                this.bulkProcessor.close();
            }
            if (this.state != null && this.state.indices() != null && !this.state.indices().isEmpty()) {
                logger.info("stopping bulk mode for indices {}...", new Object[]{this.state.indices()});
                for (String index : ImmutableSet.copyOf(this.state.indices())) {
                    this.stopBulk(index);
                }
            }
            logger.info("shutting down...", new Object[0]);
            this.client.close();
            logger.info("shutting down completed", new Object[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public BulkNodeClient newIndex(String index) {
        return this.newIndex(index, (Settings)null, (Map)null);
    }

    @Override
    public BulkNodeClient newIndex(String index, String type, InputStream settings, InputStream mappings) throws IOException {
        this.configHelper.reset();
        this.configHelper.setting(settings);
        this.configHelper.mapping(type, mappings);
        return this.newIndex(index, this.configHelper.settings(), (Map)this.configHelper.mappings());
    }

    @Override
    public BulkNodeClient newIndex(String index, Settings settings, Map<String, String> mappings) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        if (this.client == null) {
            logger.warn("no client for create index", new Object[0]);
            return this;
        }
        if (index == null) {
            logger.warn("no index name given to create index", new Object[0]);
            return this;
        }
        CreateIndexRequestBuilder createIndexRequestBuilder = new CreateIndexRequestBuilder(this.client.admin().indices()).setIndex(index);
        Object concreteSettings = settings == null && this.getSettings() != null ? this.getSettings() : (settings != null ? settings : null);
        if (concreteSettings != null) {
            createIndexRequestBuilder.setSettings(this.getSettings());
        }
        if (mappings == null && this.getMappings() != null) {
            for (String type : this.getMappings().keySet()) {
                createIndexRequestBuilder.addMapping(type, this.getMappings().get(type));
            }
        } else if (mappings != null) {
            for (String type : mappings.keySet()) {
                createIndexRequestBuilder.addMapping(type, mappings.get(type));
            }
        }
        createIndexRequestBuilder.execute().actionGet();
        logger.info("index {} created with settings {} and {} mappings", new Object[]{index, concreteSettings != null ? concreteSettings.getAsMap() : "", mappings != null ? mappings.size() : 0});
        return this;
    }

    @Override
    public BulkNodeClient deleteIndex(String index) {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("client is closed");
        }
        if (this.client == null) {
            logger.warn("no client", new Object[0]);
            return this;
        }
        if (index == null) {
            logger.warn("no index name given to delete index", new Object[0]);
            return this;
        }
        DeleteIndexRequestBuilder deleteIndexRequestBuilder = new DeleteIndexRequestBuilder(this.client.admin().indices(), new String[]{index});
        deleteIndexRequestBuilder.execute().actionGet();
        return this;
    }

    @Override
    public boolean hasThrowable() {
        return this.throwable != null;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public void setSettings(Settings settings) {
        this.configHelper.settings(settings);
    }

    @Override
    public Settings getSettings() {
        return this.configHelper.settings();
    }

    @Override
    public ImmutableSettings.Builder getSettingsBuilder() {
        return this.configHelper.settingsBuilder();
    }

    @Override
    public void setting(InputStream in) throws IOException {
        this.configHelper.setting(in);
    }

    @Override
    public void addSetting(String key, String value) {
        this.configHelper.setting(key, value);
    }

    @Override
    public void addSetting(String key, Boolean value) {
        this.configHelper.setting(key, value);
    }

    @Override
    public void addSetting(String key, Integer value) {
        this.configHelper.setting(key, value);
    }

    @Override
    public void mapping(String type, InputStream in) throws IOException {
        this.configHelper.mapping(type, in);
    }

    @Override
    public void mapping(String type, String mapping) throws IOException {
        this.configHelper.mapping(type, mapping);
    }

    @Override
    public Map<String, String> getMappings() {
        return this.configHelper.mappings();
    }
}

