/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive;

import java.nio.file.Path;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import org.xbib.io.BytesProgressWatcher;
import org.xbib.io.archive.ArchiveCodec;
import org.xbib.io.archive.ArchiveInputStream;
import org.xbib.io.archive.ArchiveOutputStream;
import org.xbib.io.archive.ArchiveSession;
import org.xbib.io.compress.CompressCodecService;

public class ArchiveService {
    private static final Map<String, ArchiveCodec> codecs = new WeakHashMap<String, ArchiveCodec>();
    private static final ArchiveService instance = new ArchiveService();

    private ArchiveService() {
        ServiceLoader<ArchiveCodec> loader = ServiceLoader.load(ArchiveCodec.class);
        for (ArchiveCodec codec : loader) {
            if (codecs.containsKey(codec.getName())) continue;
            codecs.put(codec.getName(), codec);
        }
    }

    public static ArchiveService getInstance() {
        return instance;
    }

    public ArchiveCodec getCodec(String name) {
        if (codecs.containsKey(name)) {
            return codecs.get(name);
        }
        throw new IllegalArgumentException("archive codec for " + name + " not found in " + codecs);
    }

    public static Set<String> getCodecs() {
        return codecs.keySet();
    }

    public static <I extends ArchiveInputStream, O extends ArchiveOutputStream> ArchiveSession<I, O> newSession(Path path, BytesProgressWatcher watcher) {
        for (String archiverName : ArchiveService.getCodecs()) {
            if (!ArchiveService.canOpen(archiverName, path)) continue;
            return codecs.get(archiverName).newSession(watcher);
        }
        throw new IllegalArgumentException("no archive session implementation found for path " + path);
    }

    private static boolean canOpen(String suffix, Path path) {
        String pathStr = path.toString();
        if (pathStr.endsWith("." + suffix.toLowerCase()) || pathStr.endsWith("." + suffix.toUpperCase())) {
            return true;
        }
        Set<String> codecs = CompressCodecService.getCodecs();
        for (String codec : codecs) {
            String s = "." + suffix + "." + codec;
            if (!pathStr.endsWith(s) && !pathStr.endsWith(s.toLowerCase()) && !pathStr.endsWith(s.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

