/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.xbib.io.BytesProgressWatcher;
import org.xbib.io.Session;
import org.xbib.io.StringPacket;
import org.xbib.io.archive.ArchiveInputStream;
import org.xbib.io.archive.ArchiveOutputStream;
import org.xbib.io.archive.ArchiveService;
import org.xbib.io.archive.ArchiveUtils;
import org.xbib.io.compress.CompressCodecService;

public abstract class ArchiveSession<I extends ArchiveInputStream, O extends ArchiveOutputStream>
implements Session<StringPacket> {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)ArchiveSession.class.getSimpleName());
    private static final CompressCodecService codecService = CompressCodecService.getInstance();
    private static final ArchiveService archiveService = ArchiveService.getInstance();
    private boolean isOpen;
    private EnumSet<Session.Mode> mode;
    private File file;
    private Path path;
    private I in;
    private O out;
    private BytesProgressWatcher watcher;
    private long packetCounter;
    private AtomicLong archiveCounter = new AtomicLong();

    protected ArchiveSession(BytesProgressWatcher watcher) {
        this.watcher = watcher;
        this.packetCounter = 0L;
    }

    public BytesProgressWatcher getWatcher() {
        if (this.watcher == null) {
            this.watcher = new BytesProgressWatcher(0L);
        }
        return this.watcher;
    }

    @Override
    public abstract String getName();

    @Override
    public synchronized void open(EnumSet<Session.Mode> mode, Path path, File file) throws IOException {
        if (this.isOpen) {
            return;
        }
        this.mode = mode;
        this.file = file;
        this.path = path;
        if (mode.contains((Object)Session.Mode.READ)) {
            this.in = this.createArchiveInputStream();
            boolean bl = this.isOpen = this.in != null;
            if (!this.isOpen) {
                throw new FileNotFoundException("can't open for input, check existence or access rights: " + file.getAbsolutePath());
            }
        } else if (mode.contains((Object)Session.Mode.WRITE)) {
            this.out = this.createArchiveOutputStream(false);
            boolean bl = this.isOpen = this.out != null;
            if (!this.isOpen) {
                throw new FileNotFoundException("can't open for output, check existence or access rights: " + file.getAbsolutePath());
            }
        } else if (mode.contains((Object)Session.Mode.OVERWRITE)) {
            this.out = this.createArchiveOutputStream(true);
            boolean bl = this.isOpen = this.out != null;
            if (!this.isOpen) {
                throw new FileNotFoundException("can't open for output, check existence or access rights: " + file.getAbsolutePath());
            }
        }
    }

    private I createArchiveInputStream() throws IOException {
        if (!this.file.isFile() || !this.file.canRead()) {
            throw new FileNotFoundException("can't open for input, check existence or access rights: " + this.path);
        }
        FileInputStream in = new FileInputStream(this.file);
        String pathStr = this.path.toString();
        Set<String> streamCodecs = CompressCodecService.getCodecs();
        for (String codec : streamCodecs) {
            if (!pathStr.endsWith("." + codec)) continue;
            Object archiveIn = archiveService.getCodec(this.getName()).createArchiveInputStream((InputStream)codecService.getCodec(codec).decode(in));
            ((ArchiveInputStream)archiveIn).setWatcher(this.watcher);
            return archiveIn;
        }
        Object archiveIn = archiveService.getCodec(this.getName()).createArchiveInputStream(in);
        ((ArchiveInputStream)archiveIn).setWatcher(this.watcher);
        return archiveIn;
    }

    private O createArchiveOutputStream(boolean overwrite) throws IOException {
        if (this.file.exists() && this.file.length() != 0L && !overwrite) {
            throw new FileNotFoundException("can't open for output, check existence or access rights: " + this.file.getAbsolutePath());
        }
        FileOutputStream out = new FileOutputStream(this.file);
        String pathStr = this.path.toString();
        Set<String> streamCodecs = CompressCodecService.getCodecs();
        for (String codec : streamCodecs) {
            if (!pathStr.endsWith("." + codec)) continue;
            Object archiveOut = archiveService.getCodec(this.getName()).createArchiveOutputStream((OutputStream)codecService.getCodec(codec).encode(out));
            ((ArchiveOutputStream)archiveOut).setWatcher(this.watcher);
            return archiveOut;
        }
        Object archiveOut = archiveService.getCodec(this.getName()).createArchiveOutputStream(out);
        ((ArchiveOutputStream)archiveOut).setWatcher(this.watcher);
        return archiveOut;
    }

    @Override
    public StringPacket newPacket() {
        return new StringPacket();
    }

    @Override
    public synchronized StringPacket read() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("not open");
        }
        if (this.in == null) {
            throw new IOException("no input stream found");
        }
        Object entry = ((ArchiveInputStream)this.in).getNextEntry();
        if (entry == null) {
            return null;
        }
        StringPacket packet = this.newPacket();
        String name = entry.getName();
        packet.meta("name", name);
        ArchiveUtils.decodeArchiveEntryName(packet, name);
        int size = (int)entry.getEntrySize();
        if (size >= 0) {
            byte[] b = new byte[size];
            int num = ((InputStream)this.in).read(b, 0, size);
            packet.payload(new String(b));
        } else {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            Streams.copy(this.in, (OutputStream)b);
            packet.payload(new String(b.toByteArray(), "UTF-8"));
        }
        ++this.packetCounter;
        return packet;
    }

    @Override
    public synchronized void write(StringPacket packet) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("not open");
        }
        if (this.out == null) {
            throw new IOException("no output stream found");
        }
        if (packet == null || packet.payload() == null) {
            throw new IOException("no payload to write for entry");
        }
        byte[] buf = packet.payload().getBytes("UTF-8");
        String name = ArchiveUtils.encodeArchiveEntryName(packet);
        Object entry = ((ArchiveOutputStream)this.out).newArchiveEntry();
        entry.setName(name);
        entry.setLastModified(new Date());
        entry.setEntrySize(buf.length);
        ((ArchiveOutputStream)this.out).putArchiveEntry(entry);
        ((OutputStream)this.out).write(buf);
        ((ArchiveOutputStream)this.out).closeArchiveEntry();
        ++this.packetCounter;
        if (this.watcher.getBytesToTransfer() != 0L && this.watcher.getBytesTransferred() > this.watcher.getBytesToTransfer()) {
            logger.debug("bytes watcher: transferred = {}, rate {}", new Object[]{this.watcher.getBytesTransferred(), this.watcher.getRecentByteRatePerSecond()});
            this.switchToNextArchive();
            this.watcher.resetWatcher();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        if (this.out != null) {
            ((OutputStream)this.out).close();
        }
        if (this.in != null) {
            ((InputStream)this.in).close();
        }
        this.isOpen = false;
    }

    @Override
    public long getPacketCounter() {
        return this.packetCounter;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    private void switchToNextArchive() throws IOException {
        this.close();
        String filename = this.file.getName();
        String prefix = Long.toString(this.archiveCounter.get()) + ".";
        if (filename.startsWith(prefix)) {
            filename = filename.substring(prefix.length());
        }
        filename = this.archiveCounter.incrementAndGet() + "." + filename;
        this.file = new File(this.file.getParent() + File.separator + filename);
        this.path = this.file.toPath();
        this.open(this.mode, this.path, this.file);
    }
}

