/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.StringTokenizer;
import org.xbib.io.Packet;
import org.xbib.io.StringPacket;
import org.xbib.io.archive.ArchiveEntry;
import org.xbib.io.archive.entry.ArchiveEntryEncoding;
import org.xbib.io.archive.entry.ArchiveEntryEncodingHelper;

public class ArchiveUtils {
    public static final ArchiveEntryEncoding DEFAULT_ENCODING = ArchiveEntryEncodingHelper.getEncoding(null);
    public static final ArchiveEntryEncoding FALLBACK_ENCODING = new ArchiveEntryEncoding(){

        @Override
        public boolean canEncode(String name) {
            return true;
        }

        @Override
        public ByteBuffer encode(String name) {
            int length = name.length();
            byte[] buf = new byte[length];
            for (int i = 0; i < length; ++i) {
                buf[i] = (byte)name.charAt(i);
            }
            return ByteBuffer.wrap(buf);
        }

        @Override
        public String decode(byte[] buffer) {
            int length = buffer.length;
            StringBuilder result = new StringBuilder(length);
            for (byte b : buffer) {
                if (b == 0) break;
                result.append((char)(b & 0xFF));
            }
            return result.toString();
        }
    };
    public static final String[] keys = new String[]{"index", "type", "id", "field"};
    private static final String EMPTY = "null";
    private static final String hex = "0123456789ABCDEF";
    private static final Charset LATIN1 = Charset.forName("ISO-8859-1");
    private static final Charset UTF8 = Charset.forName("UTF-8");

    private ArchiveUtils() {
    }

    public static String normalizeFileName(String fileName, boolean preserveLeadingSlashes) {
        int colon;
        String osname = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (osname.startsWith("windows")) {
            if (fileName.length() > 2) {
                char ch1 = fileName.charAt(0);
                char ch2 = fileName.charAt(1);
                if (ch2 == ':' && (ch1 >= 'a' && ch1 <= 'z' || ch1 >= 'A' && ch1 <= 'Z')) {
                    fileName = fileName.substring(2);
                }
            }
        } else if (osname.contains("netware") && (colon = fileName.indexOf(58)) != -1) {
            fileName = fileName.substring(colon + 1);
        }
        fileName = fileName.replace(File.separatorChar, '/');
        while (!preserveLeadingSlashes && fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    public static int formatNameBytes(String name, byte[] buf, int offset, int length) {
        try {
            return ArchiveUtils.formatNameBytes(name, buf, offset, length, DEFAULT_ENCODING);
        }
        catch (IOException ex) {
            try {
                return ArchiveUtils.formatNameBytes(name, buf, offset, length, FALLBACK_ENCODING);
            }
            catch (IOException ex2) {
                throw new RuntimeException(ex2);
            }
        }
    }

    public static int formatNameBytes(String name, byte[] buf, int offset, int length, ArchiveEntryEncoding encoding) throws IOException {
        int len = name.length();
        ByteBuffer b = encoding.encode(name);
        while (b.limit() > length && len > 0) {
            b = encoding.encode(name.substring(0, --len));
        }
        int limit = b.limit();
        System.arraycopy(b.array(), b.arrayOffset(), buf, offset, limit);
        for (int i = limit; i < length; ++i) {
            buf[offset + i] = 0;
        }
        return offset + length;
    }

    public static String toString(ArchiveEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(entry.isDirectory() ? (char)'d' : '-');
        String size = Long.toString(entry.getEntrySize());
        sb.append(' ');
        for (int i = 7; i > size.length(); --i) {
            sb.append(' ');
        }
        sb.append(size);
        sb.append(' ').append(entry.getName());
        return sb.toString();
    }

    public static boolean matchAsciiBuffer(String expected, byte[] buffer, int offset, int length) {
        byte[] buffer1;
        try {
            buffer1 = expected.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return ArchiveUtils.isEqual(buffer1, 0, buffer1.length, buffer, offset, length, false);
    }

    public static byte[] toAsciiBytes(String inputString) {
        try {
            return inputString.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toAsciiString(byte[] inputBytes) {
        try {
            return new String(inputBytes, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toAsciiString(byte[] inputBytes, int offset, int length) {
        try {
            return new String(inputBytes, offset, length, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isEqual(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2, boolean ignoreTrailingNulls) {
        int i;
        int minLen = length1 < length2 ? length1 : length2;
        for (i = 0; i < minLen; ++i) {
            if (buffer1[offset1 + i] == buffer2[offset2 + i]) continue;
            return false;
        }
        if (length1 == length2) {
            return true;
        }
        if (ignoreTrailingNulls) {
            if (length1 > length2) {
                for (i = length2; i < length1; ++i) {
                    if (buffer1[offset1 + i] == 0) continue;
                    return false;
                }
            } else {
                for (i = length1; i < length2; ++i) {
                    if (buffer2[offset2 + i] == 0) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static String encodeArchiveEntryName(StringPacket packet) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            Object o;
            if (i > 0) {
                sb.append(File.separator);
            }
            if ((o = packet.meta().get(keys[i])) == null) {
                o = EMPTY;
            }
            sb.append(ArchiveUtils.encode(o.toString(), UTF8));
        }
        return sb.toString();
    }

    public static void decodeArchiveEntryName(Packet packet, String archiveEntryName) {
        String[] components = ArchiveUtils.split(archiveEntryName, File.separator);
        for (int i = 0; i < components.length; ++i) {
            packet.meta(keys[i], ArchiveUtils.decode(components[i], UTF8));
        }
    }

    private static String[] split(String str, String delims) {
        StringTokenizer tokenizer = new StringTokenizer(str, delims);
        int n = tokenizer.countTokens();
        String[] list = new String[n];
        for (int i = 0; i < n; ++i) {
            list[i] = tokenizer.nextToken();
        }
        return list;
    }

    private static String decode(String s, Charset encoding) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean fragment = false;
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '+': {
                    sb.append(' ');
                    continue block5;
                }
                case '#': {
                    sb.append(ch);
                    fragment = true;
                    continue block5;
                }
                case '%': {
                    if (!fragment) {
                        sb.append((char)(Character.digit(s.charAt(++i), 16) << 4 | Character.digit(s.charAt(++i), 16)));
                        continue block5;
                    }
                    sb.append(ch);
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return new String(sb.toString().getBytes(LATIN1), encoding);
    }

    private static String encode(String s, Charset encoding) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        int length = s.length();
        int start = 0;
        int i = 0;
        StringBuilder result = new StringBuilder(length);
        while (true) {
            if (i < length && ArchiveUtils.isSafe(s.charAt(i))) {
                ++i;
                continue;
            }
            result.append(s.substring(start, i));
            if (i >= length) {
                return result.toString();
            }
            if (s.charAt(i) == ' ') {
                result.append('+');
            } else {
                byte[] bytes;
                char c;
                start = i;
                while (i < length && (c = s.charAt(i)) != ' ' && !ArchiveUtils.isSafe(c)) {
                    ++i;
                }
                String unsafe = s.substring(start, i);
                for (byte aByte : bytes = unsafe.getBytes(encoding)) {
                    result.append('%');
                    result.append(hex.charAt((aByte & 0xF0) >> 4));
                    result.append(hex.charAt(aByte & 0xF));
                }
            }
            start = ++i;
        }
    }

    private static boolean isSafe(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '*';
    }
}

