/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive.cpio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.xbib.io.archive.ArchiveInputStream;
import org.xbib.io.archive.ArchiveUtils;
import org.xbib.io.archive.cpio.CpioArchiveEntry;
import org.xbib.io.archive.cpio.CpioConstants;
import org.xbib.io.archive.cpio.CpioUtil;

public class CpioArchiveInputStream
extends ArchiveInputStream<CpioArchiveEntry>
implements CpioConstants {
    private boolean closed = false;
    private CpioArchiveEntry entry;
    private long entryBytesRead = 0L;
    private boolean entryEOF = false;
    private final byte[] tmpbuf = new byte[4096];
    private long crc = 0L;
    private final InputStream in;

    public CpioArchiveInputStream(InputStream in) {
        this.in = in;
        this.closed = false;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.entryEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.closed = true;
        }
    }

    private void closeEntry() throws IOException {
        this.ensureOpen();
        while (this.read(this.tmpbuf, 0, this.tmpbuf.length) != -1) {
        }
        this.entryEOF = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public CpioArchiveEntry getNextCPIOEntry() throws IOException {
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        byte[] magic = new byte[2];
        this.readFully(magic, 0, magic.length);
        if (CpioUtil.byteArray2long(magic, false) == 29127L) {
            this.entry = this.readOldBinaryEntry(false);
        } else if (CpioUtil.byteArray2long(magic, true) == 29127L) {
            this.entry = this.readOldBinaryEntry(true);
        } else {
            byte[] more_magic = new byte[4];
            this.readFully(more_magic, 0, more_magic.length);
            byte[] tmp = new byte[6];
            System.arraycopy(magic, 0, tmp, 0, magic.length);
            System.arraycopy(more_magic, 0, tmp, magic.length, more_magic.length);
            String magicString = ArchiveUtils.toAsciiString(tmp);
            if (magicString.equals("070701")) {
                this.entry = this.readNewEntry(false);
            } else if (magicString.equals("070702")) {
                this.entry = this.readNewEntry(true);
            } else if (magicString.equals("070707")) {
                this.entry = this.readOldAsciiEntry();
            } else {
                throw new IOException("unknown magic: " + magicString);
            }
        }
        this.entryBytesRead = 0L;
        this.entryEOF = false;
        this.crc = 0L;
        if (this.entry.getName().equals("TRAILER!!!")) {
            this.entryEOF = true;
            return null;
        }
        return this.entry;
    }

    private void skip(int bytes) throws IOException {
        byte[] buff = new byte[4];
        if (bytes > 0) {
            this.readFully(buff, 0, bytes);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.entry == null || this.entryEOF) {
            return -1;
        }
        if (this.entryBytesRead == this.entry.getEntrySize()) {
            this.skip(this.entry.getDataPadCount());
            this.entryEOF = true;
            if (this.entry.getFormat() == 2 && this.crc != this.entry.getChksum()) {
                throw new IOException("CRC error");
            }
            return -1;
        }
        int tmplength = (int)Math.min((long)len, this.entry.getEntrySize() - this.entryBytesRead);
        if (tmplength < 0) {
            return -1;
        }
        int tmpread = this.readFully(b, off, tmplength);
        if (this.entry.getFormat() == 2) {
            for (int pos = 0; pos < tmpread; ++pos) {
                this.crc += (long)(b[pos] & 0xFF);
            }
        }
        this.entryBytesRead += (long)tmpread;
        return tmpread;
    }

    private int readFully(byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return n;
    }

    private long readBinaryLong(int length, boolean swapHalfWord) throws IOException {
        byte[] tmp = new byte[length];
        this.readFully(tmp, 0, tmp.length);
        return CpioUtil.byteArray2long(tmp, swapHalfWord);
    }

    private long readAsciiLong(int length, int radix) throws IOException {
        byte[] tmpBuffer = new byte[length];
        this.readFully(tmpBuffer, 0, tmpBuffer.length);
        return Long.parseLong(ArchiveUtils.toAsciiString(tmpBuffer), radix);
    }

    private CpioArchiveEntry readNewEntry(boolean hasCrc) throws IOException {
        CpioArchiveEntry ret = hasCrc ? new CpioArchiveEntry(2) : new CpioArchiveEntry(1);
        ret.setInode(this.readAsciiLong(8, 16));
        long mode = this.readAsciiLong(8, 16);
        if (mode != 0L) {
            ret.setMode(mode);
        }
        ret.setUID(this.readAsciiLong(8, 16));
        ret.setGID(this.readAsciiLong(8, 16));
        ret.setNumberOfLinks(this.readAsciiLong(8, 16));
        ret.setTime(this.readAsciiLong(8, 16));
        ret.setEntrySize(this.readAsciiLong(8, 16));
        ret.setDeviceMaj(this.readAsciiLong(8, 16));
        ret.setDeviceMin(this.readAsciiLong(8, 16));
        ret.setRemoteDeviceMaj(this.readAsciiLong(8, 16));
        ret.setRemoteDeviceMin(this.readAsciiLong(8, 16));
        long namesize = this.readAsciiLong(8, 16);
        ret.setChksum(this.readAsciiLong(8, 16));
        String name = this.readCString((int)namesize);
        ret.setName(name);
        if (mode == 0L && !name.equals("TRAILER!!!")) {
            throw new IOException("mode 0 only allowed in the trailer, found entry " + name);
        }
        this.skip(ret.getHeaderPadCount());
        return ret;
    }

    private CpioArchiveEntry readOldAsciiEntry() throws IOException {
        CpioArchiveEntry ret = new CpioArchiveEntry(4);
        ret.setDevice(this.readAsciiLong(6, 8));
        ret.setInode(this.readAsciiLong(6, 8));
        long mode = this.readAsciiLong(6, 8);
        if (mode != 0L) {
            ret.setMode(mode);
        }
        ret.setUID(this.readAsciiLong(6, 8));
        ret.setGID(this.readAsciiLong(6, 8));
        ret.setNumberOfLinks(this.readAsciiLong(6, 8));
        ret.setRemoteDevice(this.readAsciiLong(6, 8));
        ret.setTime(this.readAsciiLong(11, 8));
        long namesize = this.readAsciiLong(6, 8);
        ret.setEntrySize(this.readAsciiLong(11, 8));
        String name = this.readCString((int)namesize);
        ret.setName(name);
        if (mode == 0L && !name.equals("TRAILER!!!")) {
            throw new IOException("mode 0 only allowed in the trailer, found entry " + name);
        }
        return ret;
    }

    private CpioArchiveEntry readOldBinaryEntry(boolean swapHalfWord) throws IOException {
        CpioArchiveEntry ret = new CpioArchiveEntry(8);
        ret.setDevice(this.readBinaryLong(2, swapHalfWord));
        ret.setInode(this.readBinaryLong(2, swapHalfWord));
        long mode = this.readBinaryLong(2, swapHalfWord);
        if (mode != 0L) {
            ret.setMode(mode);
        }
        ret.setUID(this.readBinaryLong(2, swapHalfWord));
        ret.setGID(this.readBinaryLong(2, swapHalfWord));
        ret.setNumberOfLinks(this.readBinaryLong(2, swapHalfWord));
        ret.setRemoteDevice(this.readBinaryLong(2, swapHalfWord));
        ret.setTime(this.readBinaryLong(4, swapHalfWord));
        long namesize = this.readBinaryLong(2, swapHalfWord);
        ret.setEntrySize(this.readBinaryLong(4, swapHalfWord));
        String name = this.readCString((int)namesize);
        ret.setName(name);
        if (mode == 0L && !name.equals("TRAILER!!!")) {
            throw new IOException("mode 0 only allowed in the trailer, found entry " + name);
        }
        this.skip(ret.getHeaderPadCount());
        return ret;
    }

    private String readCString(int length) throws IOException {
        byte[] tmpBuffer = new byte[length];
        this.readFully(tmpBuffer, 0, tmpBuffer.length);
        return new String(tmpBuffer, 0, tmpBuffer.length - 1);
    }

    @Override
    public long skip(long n) throws IOException {
        int total;
        int len;
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        for (total = 0; total < max; total += len) {
            len = max - total;
            if (len > this.tmpbuf.length) {
                len = this.tmpbuf.length;
            }
            if ((len = this.read(this.tmpbuf, 0, len)) != -1) continue;
            this.entryEOF = true;
            break;
        }
        return total;
    }

    @Override
    public CpioArchiveEntry getNextEntry() throws IOException {
        return this.getNextCPIOEntry();
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < 6) {
            return false;
        }
        if (signature[0] == 113 && (signature[1] & 0xFF) == 199) {
            return true;
        }
        if (signature[1] == 113 && (signature[0] & 0xFF) == 199) {
            return true;
        }
        if (signature[0] != 48) {
            return false;
        }
        if (signature[1] != 55) {
            return false;
        }
        if (signature[2] != 48) {
            return false;
        }
        if (signature[3] != 55) {
            return false;
        }
        if (signature[4] != 48) {
            return false;
        }
        if (signature[5] == 49) {
            return true;
        }
        if (signature[5] == 50) {
            return true;
        }
        return signature[5] == 55;
    }
}

