/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive.esbulk;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.io.archive.ArchiveInputStream;
import org.xbib.io.archive.esbulk.EsBulkArchiveEntry;

public class EsBulkArchiveInputStream
extends ArchiveInputStream<EsBulkArchiveEntry> {
    private static final Pattern indexPattern = Pattern.compile("\"_index\"\\s*:\\s*\"(.*?)\"");
    private static final Pattern typePattern = Pattern.compile("\"_type\"\\s*:\\s*\"(.*?)\"");
    private static final Pattern idPattern = Pattern.compile("\"_id\"\\s*:\\s*\"(.*?)\"");
    private final BufferedReader reader;
    private ByteArrayInputStream in;

    public EsBulkArchiveInputStream(InputStream in) throws UnsupportedEncodingException {
        this.reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
    }

    @Override
    public EsBulkArchiveEntry getNextEntry() throws IOException {
        String meta = this.reader.readLine();
        if (meta == null) {
            return null;
        }
        String data = this.reader.readLine();
        if (data == null) {
            return null;
        }
        EsBulkArchiveEntry entry = new EsBulkArchiveEntry();
        StringBuilder sb = new StringBuilder();
        Matcher m = indexPattern.matcher(meta);
        if (!m.find()) {
            throw new IOException("no _index found");
        }
        sb.append(m.group(1));
        m = typePattern.matcher(meta);
        if (!m.find()) {
            throw new IOException("no _type found");
        }
        sb.append('/').append(m.group(1));
        m = idPattern.matcher(meta);
        if (!m.find()) {
            throw new IOException("no _id found");
        }
        sb.append('/').append(m.group(1));
        entry.setName(sb.toString());
        byte[] b = data.getBytes("UTF-8");
        entry.setEntrySize(b.length);
        this.in = new ByteArrayInputStream(b);
        return entry;
    }

    @Override
    public int read(byte[] buffer, int start, int length) throws IOException {
        return this.in.read(buffer, start, length);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public long skip(long value) throws IOException {
        throw new UnsupportedOperationException();
    }
}

