/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive.esbulk;

import java.io.IOException;
import java.io.OutputStream;
import org.xbib.io.StringPacket;
import org.xbib.io.archive.ArchiveOutputStream;
import org.xbib.io.archive.ArchiveUtils;
import org.xbib.io.archive.esbulk.EsBulkArchiveEntry;

public class EsBulkArchiveOutputStream
extends ArchiveOutputStream<EsBulkArchiveEntry> {
    private final OutputStream out;
    private boolean closed = false;
    private boolean finished;

    public EsBulkArchiveOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public EsBulkArchiveEntry newArchiveEntry() {
        return new EsBulkArchiveEntry();
    }

    @Override
    public void putArchiveEntry(EsBulkArchiveEntry entry) throws IOException {
        StringPacket packet = new StringPacket();
        ArchiveUtils.decodeArchiveEntryName(packet, entry.getName());
        StringBuilder sb = new StringBuilder();
        sb.append("{\"index\":{\"_index\":\"").append(packet.meta().get(ArchiveUtils.keys[0])).append("\",\"_type\":\"").append(packet.meta().get(ArchiveUtils.keys[1])).append("\",\"_id\":\"").append(packet.meta().get(ArchiveUtils.keys[2])).append("\"}\n");
        this.out.write(sb.toString().getBytes("UTF-8"));
    }

    @Override
    public void write(byte[] buf, int offset, int size) throws IOException {
        this.out.write(buf, offset, size);
        this.out.write(10);
        this.getWatcher().updateBytesTransferred(size);
    }

    @Override
    public void closeArchiveEntry() throws IOException {
    }

    @Override
    public void finish() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            this.finish();
            this.finished = true;
        }
        if (!this.closed) {
            this.out.close();
            this.closed = true;
        }
    }
}

