/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive.tar;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import org.xbib.io.archive.ArchiveEntry;
import org.xbib.io.archive.ArchiveUtils;
import org.xbib.io.archive.entry.ArchiveEntryEncoding;
import org.xbib.io.archive.tar.TarConstants;

public class TarArchiveInputEntry
implements TarConstants,
ArchiveEntry {
    private static final int MAX_NAMELEN = 31;
    private static final int DEFAULT_DIR_MODE = 16877;
    private static final int DEFAULT_FILE_MODE = 33188;
    private static final int MILLIS_PER_SECOND = 1000;
    private String name = "";
    private int mode;
    private int userId;
    private int groupId;
    private long size;
    private long modTime;
    private byte linkFlag = (byte)76;
    private String linkName = "";
    private String version = "00";
    private String userName;
    private String groupName;
    private int devMajor;
    private int devMinor;
    private boolean isExtended;
    private long realSize;
    private boolean isDir;

    public TarArchiveInputEntry() {
        String user = System.getProperty("user.name", "");
        if (user.length() > 31) {
            user = user.substring(0, 31);
        }
        this.userName = user;
        this.groupName = "";
        this.userId = 0;
        this.groupId = 0;
        this.mode = 33188;
    }

    public TarArchiveInputEntry(String name) {
        this(name, false);
    }

    public TarArchiveInputEntry(String name, boolean preserveLeadingSlashes) {
        this();
        this.name = name = ArchiveUtils.normalizeFileName(name, preserveLeadingSlashes);
        boolean isDir = name.endsWith("/");
        this.mode = isDir ? 16877 : 33188;
        this.linkFlag = (byte)(isDir ? 53 : 48);
        this.devMajor = 0;
        this.devMinor = 0;
        this.userId = 0;
        this.groupId = 0;
        this.size = 0L;
        this.modTime = new Date().getTime() / 1000L;
        this.linkName = "";
        this.userName = "";
        this.groupName = "";
    }

    public TarArchiveInputEntry(String name, byte linkFlag) {
        this(name);
        this.linkFlag = linkFlag;
        if (linkFlag == 76) {
            this.version = " \u0000";
        }
    }

    public TarArchiveInputEntry(byte[] headerBuf, ArchiveEntryEncoding encoding) throws IOException {
        this();
        this.parseTarHeader(headerBuf, encoding);
    }

    public boolean equals(TarArchiveInputEntry it) {
        return this.getName().equals(it.getName());
    }

    public boolean equals(Object it) {
        return it != null && this.getClass() == it.getClass() && this.equals((TarArchiveInputEntry)it);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TarArchiveInputEntry setName(String name) {
        this.name = ArchiveUtils.normalizeFileName(name, false);
        this.isDir = name.endsWith("/");
        this.mode = this.isDir ? 16877 : 33188;
        this.linkFlag = (byte)(this.isDir ? 53 : 48);
        return this;
    }

    @Override
    public TarArchiveInputEntry setLastModified(Date date) {
        this.modTime = date.getTime() / 1000L;
        return this;
    }

    @Override
    public Date getLastModified() {
        return new Date(this.modTime * 1000L);
    }

    @Override
    public boolean isDirectory() {
        return this.isDir;
    }

    @Override
    public TarArchiveInputEntry setEntrySize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("size is out of range: " + size);
        }
        this.size = size;
        return this;
    }

    @Override
    public long getEntrySize() {
        return this.size;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String link) {
        this.linkName = link;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getMode() {
        return this.mode;
    }

    public int getDevMajor() {
        return this.devMajor;
    }

    public void setDevMajor(int devNo) {
        if (devNo < 0) {
            throw new IllegalArgumentException("Major device number is out of range: " + devNo);
        }
        this.devMajor = devNo;
    }

    public int getDevMinor() {
        return this.devMinor;
    }

    public void setDevMinor(int devNo) {
        if (devNo < 0) {
            throw new IllegalArgumentException("Minor device number is out of range: " + devNo);
        }
        this.devMinor = devNo;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public long getRealSize() {
        return this.realSize;
    }

    public boolean isGNUSparse() {
        return this.linkFlag == 83;
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76 && "././@LongLink".equals(this.name);
    }

    public boolean isPaxHeader() {
        return this.linkFlag == 120 || this.linkFlag == 88;
    }

    public boolean isGlobalPaxHeader() {
        return this.linkFlag == 103;
    }

    public boolean isSymbolicLink() {
        return this.linkFlag == 50;
    }

    public boolean isLink() {
        return this.linkFlag == 49;
    }

    public boolean isCharacterDevice() {
        return this.linkFlag == 51;
    }

    public boolean isBlockDevice() {
        return this.linkFlag == 52;
    }

    public boolean isFIFO() {
        return this.linkFlag == 54;
    }

    public void parseTarHeader(byte[] header, ArchiveEntryEncoding encoding) throws IOException {
        this.parseTarHeader(header, encoding, false);
    }

    private void parseTarHeader(byte[] header, ArchiveEntryEncoding encoding, boolean oldStyle) throws IOException {
        int offset = 0;
        int type = this.evaluateType(header);
        this.name = this.parseFileName(header);
        this.mode = (int)this.parseOctalOrBinary(header, offset += 100, 8);
        this.userId = (int)this.parseOctalOrBinary(header, offset += 8, 8);
        this.groupId = (int)this.parseOctalOrBinary(header, offset += 8, 8);
        this.size = type == 0 ? this.getSize(header, offset, 12) : this.parseOctalOrBinary(header, offset += 8, 12);
        this.modTime = this.parseOctalOrBinary(header, offset += 12, 12);
        offset += 12;
        offset += 8;
        this.linkFlag = header[offset++];
        this.linkName = oldStyle ? this.parseName(header, offset, 100) : this.parseName(header, offset, 100, encoding);
        offset += 100;
        switch (type) {
            case 2: {
                offset += 12;
                offset += 12;
                offset += 12;
                offset += 4;
                ++offset;
                this.isExtended = this.parseBoolean(header, offset += 96);
                this.realSize = this.parseOctal(header, ++offset, 12);
                offset += 12;
                break;
            }
            case 3: {
                this.parseName(header, offset, 6);
                this.version = this.parseName(header, offset += 6, 2);
                this.userName = oldStyle ? this.parseName(header, offset, 32) : this.parseName(header, offset += 2, 32, encoding);
                this.groupName = oldStyle ? this.parseName(header, offset, 32) : this.parseName(header, offset += 32, 32, encoding);
                this.devMajor = (int)this.parseOctalOrBinary(header, offset += 32, 8);
                this.devMinor = (int)this.parseOctalOrBinary(header, offset += 8, 8);
                offset += 8;
            }
        }
    }

    private int evaluateType(byte[] header) {
        if (ArchiveUtils.matchAsciiBuffer("\u0000\u0000\u0000\u0000\u0000", header, 257, 6)) {
            return 2;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", header, 257, 6)) {
            return 3;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar ", header, 257, 6)) {
            return 0;
        }
        return 0;
    }

    private long parseOctal(byte[] buffer, int offset, int length) {
        int start;
        long result = 0L;
        int end = offset + length;
        if (length < 2) {
            throw new IllegalArgumentException("Length " + length + " must be at least 2");
        }
        if (buffer[start] == 0) {
            return 0L;
        }
        for (start = offset; start < end && buffer[start] == 32; ++start) {
        }
        byte trailer = buffer[end - 1];
        if (trailer != 0 && trailer != 32) {
            throw new IllegalArgumentException(this.exceptionMessage(buffer, offset, length, end - 1, trailer));
        }
        trailer = buffer[--end - 1];
        if (trailer == 0 || trailer == 32) {
            --end;
        }
        while (start < end) {
            byte currentByte = buffer[start];
            if (currentByte < 48 || currentByte > 55) {
                throw new IllegalArgumentException(this.exceptionMessage(buffer, offset, length, start, currentByte));
            }
            result = (result << 3) + (long)(currentByte - 48);
            ++start;
        }
        return result;
    }

    private long parseOctalOrBinary(byte[] buffer, int offset, int length) {
        boolean negative;
        if ((buffer[offset] & 0x80) == 0) {
            return this.parseOctal(buffer, offset, length);
        }
        boolean bl = negative = buffer[offset] == -1;
        if (length < 9) {
            return this.parseBinaryLong(buffer, offset, length, negative);
        }
        return this.parseBinaryBigInteger(buffer, offset, length, negative);
    }

    private long parseBinaryLong(byte[] buffer, int offset, int length, boolean negative) {
        if (length >= 9) {
            throw new IllegalArgumentException("At offset " + offset + ", " + length + " byte binary number" + " exceeds maximum signed long" + " value");
        }
        long val = 0L;
        for (int i = 1; i < length; ++i) {
            val = (val << 8) + (long)(buffer[offset + i] & 0xFF);
        }
        if (negative) {
            --val;
            val ^= (long)Math.pow(2.0, (length - 1) * 8) - 1L;
        }
        return negative ? -val : val;
    }

    private long parseBinaryBigInteger(byte[] buffer, int offset, int length, boolean negative) {
        byte[] remainder = new byte[length - 1];
        System.arraycopy(buffer, offset + 1, remainder, 0, length - 1);
        BigInteger val = new BigInteger(remainder);
        if (negative) {
            val = val.add(BigInteger.valueOf(-1L)).not();
        }
        if (val.bitLength() > 63) {
            throw new IllegalArgumentException("At offset " + offset + ", " + length + " byte binary number" + " exceeds maximum signed long" + " value");
        }
        return negative ? -val.longValue() : val.longValue();
    }

    private boolean parseBoolean(byte[] buffer, int offset) {
        return buffer[offset] == 1;
    }

    private String exceptionMessage(byte[] buffer, int offset, int length, int current, byte currentByte) {
        String string = new String(buffer, offset, length);
        string = string.replaceAll("\u0000", "{NUL}");
        return "Invalid byte " + currentByte + " at offset " + (current - offset) + " in '" + string + "' len=" + length;
    }

    private String parseName(byte[] buffer, int offset, int length) {
        try {
            return this.parseName(buffer, offset, length, ArchiveUtils.DEFAULT_ENCODING);
        }
        catch (IOException ex) {
            try {
                return this.parseName(buffer, offset, length, ArchiveUtils.FALLBACK_ENCODING);
            }
            catch (IOException ex2) {
                throw new RuntimeException(ex2);
            }
        }
    }

    private String parseName(byte[] buffer, int offset, int length, ArchiveEntryEncoding encoding) throws IOException {
        int len;
        for (len = length; len > 0 && buffer[offset + len - 1] == 0; --len) {
        }
        if (len > 0) {
            byte[] b = new byte[len];
            System.arraycopy(buffer, offset, b, 0, len);
            return encoding.decode(b);
        }
        return "";
    }

    private long getSize(byte[] header, int offset, int length) {
        long test = this.parseOctal(header, offset, length);
        if (test <= 0L && header[offset] == -128) {
            byte[] last = new byte[length];
            System.arraycopy(header, offset, last, 0, length);
            last[0] = 0;
            long rSize = new BigInteger(last).longValue();
            last = null;
            return rSize;
        }
        return test;
    }

    private String parseFileName(byte[] header) {
        int i;
        StringBuilder result = new StringBuilder(256);
        if (header[345] != 0) {
            for (i = 345; i < 500 && header[i] != 0; ++i) {
                result.append((char)header[i]);
            }
            result.append("/");
        }
        for (i = 0; i < 100 && header[i] != 0; ++i) {
            result.append((char)header[i]);
        }
        return result.toString();
    }
}

