/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive.tar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.xbib.io.archive.ArchiveInputStream;
import org.xbib.io.archive.entry.ArchiveEntryEncoding;
import org.xbib.io.archive.entry.ArchiveEntryEncodingHelper;
import org.xbib.io.archive.tar.TarArchiveInputEntry;
import org.xbib.io.archive.tar.TarConstants;

public class TarArchiveInputStream
extends ArchiveInputStream<TarArchiveInputEntry>
implements TarConstants {
    private final ArchiveEntryEncoding encoding = ArchiveEntryEncodingHelper.getEncoding(null);
    private final InputStream inStream;
    private final int blockSize;
    private final int recordSize;
    private final int recsPerBlock;
    private final byte[] blockBuffer;
    private byte[] readBuf = null;
    private boolean hasHitEOF = false;
    private long entrySize;
    private long entryOffset;
    private TarArchiveInputEntry entry;
    private int currRecIdx;

    public TarArchiveInputStream(InputStream is) {
        this.inStream = is;
        this.blockSize = 10240;
        this.recordSize = 512;
        this.recsPerBlock = this.blockSize / this.recordSize;
        this.blockBuffer = new byte[this.blockSize];
        this.currRecIdx = this.recsPerBlock;
    }

    @Override
    public void close() throws IOException {
        if (this.inStream != null && this.inStream != System.in) {
            this.inStream.close();
        }
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public int available() throws IOException {
        if (this.entrySize - this.entryOffset > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.entrySize - this.entryOffset);
    }

    @Override
    public long skip(long numToSkip) throws IOException {
        int realSkip;
        long skip;
        int numRead;
        byte[] skipBuf = new byte[1024];
        for (skip = numToSkip; skip > 0L && (numRead = this.read(skipBuf, 0, realSkip = (int)(skip > (long)skipBuf.length ? (long)skipBuf.length : skip))) != -1; skip -= (long)numRead) {
        }
        return numToSkip - skip;
    }

    @Override
    public void reset() {
    }

    public synchronized TarArchiveInputEntry getNextTarEntry() throws IOException {
        if (this.hasHitEOF) {
            return null;
        }
        if (this.entry != null) {
            long skipped;
            for (long numToSkip = this.entrySize - this.entryOffset; numToSkip > 0L; numToSkip -= skipped) {
                skipped = this.skip(numToSkip);
                if (skipped > 0L) continue;
                throw new RuntimeException("failed to skip current tar entry");
            }
            this.readBuf = null;
        }
        byte[] headerBuf = this.getRecord();
        if (this.hasHitEOF) {
            this.entry = null;
            return null;
        }
        try {
            this.entry = new TarArchiveInputEntry(headerBuf, this.encoding);
            this.entryOffset = 0L;
            this.entrySize = this.entry.getEntrySize();
        }
        catch (IllegalArgumentException e) {
            throw new IOException("error detected parsing the header", e);
        }
        if (this.entry.isGNULongNameEntry()) {
            int length;
            StringBuilder longName = new StringBuilder();
            byte[] buf = new byte[256];
            while ((length = this.read(buf)) >= 0) {
                longName.append(new String(buf, 0, length));
            }
            this.getNextEntry();
            if (this.entry == null) {
                return null;
            }
            if (longName.length() > 0 && longName.charAt(longName.length() - 1) == '\u0000') {
                longName.deleteCharAt(longName.length() - 1);
            }
            this.entry.setName(longName.toString());
        }
        if (this.entry.isPaxHeader()) {
            this.paxHeaders();
        }
        return this.entry;
    }

    private byte[] getRecord() throws IOException {
        if (this.hasHitEOF) {
            return null;
        }
        byte[] headerBuf = this.readRecord();
        if (headerBuf == null) {
            this.hasHitEOF = true;
        } else if (this.isEOFRecord(headerBuf)) {
            this.hasHitEOF = true;
        }
        return this.hasHitEOF ? null : headerBuf;
    }

    private byte[] readRecord() throws IOException {
        if (this.currRecIdx >= this.recsPerBlock && !this.readBlock()) {
            return null;
        }
        byte[] result = new byte[this.recordSize];
        System.arraycopy(this.blockBuffer, this.currRecIdx * this.recordSize, result, 0, this.recordSize);
        ++this.currRecIdx;
        return result;
    }

    private boolean readBlock() throws IOException {
        this.currRecIdx = 0;
        int offset = 0;
        int bytesNeeded = this.blockSize;
        while (bytesNeeded > 0) {
            long numBytes = this.inStream.read(this.blockBuffer, offset, bytesNeeded);
            if (numBytes == -1L) {
                if (offset == 0) {
                    return false;
                }
                Arrays.fill(this.blockBuffer, offset, offset + bytesNeeded, (byte)0);
                break;
            }
            offset = (int)((long)offset + numBytes);
            bytesNeeded = (int)((long)bytesNeeded - numBytes);
        }
        return true;
    }

    private boolean isEOFRecord(byte[] record) {
        int sz = this.getRecordSize();
        for (int i = 0; i < sz; ++i) {
            if (record[i] == 0) continue;
            return false;
        }
        return true;
    }

    private void paxHeaders() throws IOException {
        Map<String, String> headers = this.parsePaxHeaders(this);
        this.getNextEntry();
        this.applyPaxHeadersToCurrentEntry(headers);
    }

    private Map<String, String> parsePaxHeaders(InputStream i) throws IOException {
        int ch;
        HashMap<String, String> headers = new HashMap<String, String>();
        block0: do {
            int len = 0;
            int read = 0;
            while ((ch = i.read()) != -1) {
                ++read;
                if (ch == 32) {
                    ByteArrayOutputStream coll = new ByteArrayOutputStream();
                    while ((ch = i.read()) != -1) {
                        ++read;
                        if (ch == 61) {
                            String keyword = coll.toString("UTF-8");
                            byte[] rest = new byte[len - read];
                            int got = i.read(rest);
                            if (got != len - read) {
                                throw new IOException("Failed to read Paxheader. Expected " + (len - read) + " bytes, read " + got);
                            }
                            String value = new String(rest, 0, len - read - 1, Charset.forName("UTF-8"));
                            headers.put(keyword, value);
                            continue block0;
                        }
                        coll.write((byte)ch);
                    }
                    continue block0;
                }
                len *= 10;
                len += ch - 48;
            }
        } while (ch != -1);
        return headers;
    }

    private void applyPaxHeadersToCurrentEntry(Map<String, String> headers) {
        for (Map.Entry<String, String> ent : headers.entrySet()) {
            String key = ent.getKey();
            String val = ent.getValue();
            if ("path".equals(key)) {
                this.entry.setName(val);
                continue;
            }
            if ("linkpath".equals(key)) {
                this.entry.setLinkName(val);
                continue;
            }
            if ("gid".equals(key)) {
                this.entry.setGroupId(Integer.parseInt(val));
                continue;
            }
            if ("gname".equals(key)) {
                this.entry.setGroupName(val);
                continue;
            }
            if ("uid".equals(key)) {
                this.entry.setUserId(Integer.parseInt(val));
                continue;
            }
            if ("uname".equals(key)) {
                this.entry.setUserName(val);
                continue;
            }
            if ("size".equals(key)) {
                this.entry.setEntrySize(Long.parseLong(val));
                continue;
            }
            if ("mtime".equals(key)) {
                long mtime = (long)(Double.parseDouble(val) * 1000.0);
                this.entry.setLastModified(new Date(mtime));
                continue;
            }
            if ("SCHILY.devminor".equals(key)) {
                this.entry.setDevMinor(Integer.parseInt(val));
                continue;
            }
            if (!"SCHILY.devmajor".equals(key)) continue;
            this.entry.setDevMajor(Integer.parseInt(val));
        }
    }

    @Override
    public TarArchiveInputEntry getNextEntry() throws IOException {
        return this.getNextTarEntry();
    }

    @Override
    public int read(byte[] buf, int offset, int numToRead) throws IOException {
        int totalRead = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)numToRead + this.entryOffset > this.entrySize) {
            numToRead = (int)(this.entrySize - this.entryOffset);
        }
        if (this.readBuf != null) {
            int sz = numToRead > this.readBuf.length ? this.readBuf.length : numToRead;
            System.arraycopy(this.readBuf, 0, buf, offset, sz);
            if (sz >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                int newLen = this.readBuf.length - sz;
                byte[] newBuf = new byte[newLen];
                System.arraycopy(this.readBuf, sz, newBuf, 0, newLen);
                this.readBuf = newBuf;
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        while (numToRead > 0) {
            byte[] rec = this.readRecord();
            if (rec == null) {
                throw new IOException("unexpected EOF with " + numToRead + " bytes unread");
            }
            int recLen = rec.length;
            int sz = numToRead;
            if (recLen > sz) {
                System.arraycopy(rec, 0, buf, offset, sz);
                this.readBuf = new byte[recLen - sz];
                System.arraycopy(rec, sz, this.readBuf, 0, recLen - sz);
            } else {
                sz = recLen;
                System.arraycopy(rec, 0, buf, offset, recLen);
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        this.entryOffset += (long)totalRead;
        return totalRead;
    }
}

