/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive.tar;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.xbib.io.archive.ArchiveOutputStream;
import org.xbib.io.archive.entry.ArchiveEntryEncoding;
import org.xbib.io.archive.entry.ArchiveEntryEncodingHelper;
import org.xbib.io.archive.tar.TarArchiveOutputEntry;
import org.xbib.io.archive.tar.TarConstants;

public class TarArchiveOutputStream
extends ArchiveOutputStream<TarArchiveOutputEntry>
implements TarConstants {
    private static final ArchiveEntryEncoding ASCII = ArchiveEntryEncodingHelper.getEncoding("ASCII");
    private final ArchiveEntryEncoding encoding;
    private final OutputStream outStream;
    private final int blockSize;
    private final int recordSize;
    private final int recsPerBlock;
    private final byte[] blockBuffer;
    private final byte[] recordBuf;
    private final byte[] assemBuf;
    private int currRecIdx;
    private long currSize;
    private String currName;
    private long currBytes;
    private int assemLen;
    private int longFileMode = 2;
    private int bigNumberMode = 0;
    private boolean closed = false;
    private boolean haveUnclosedEntry = false;
    private boolean finished = false;
    private boolean addPaxHeadersForNonAsciiNames = false;

    public TarArchiveOutputStream(OutputStream os) {
        this(os, 10240, 512);
    }

    public TarArchiveOutputStream(OutputStream os, String encoding) {
        this(os, 10240, 512, encoding);
    }

    public TarArchiveOutputStream(OutputStream os, int blockSize) {
        this(os, blockSize, 512);
    }

    public TarArchiveOutputStream(OutputStream os, int blockSize, String encoding) {
        this(os, blockSize, 512, encoding);
    }

    public TarArchiveOutputStream(OutputStream os, int blockSize, int recordSize) {
        this(os, blockSize, recordSize, null);
    }

    public TarArchiveOutputStream(OutputStream os, int blockSize, int recordSize, String encoding) {
        this.encoding = ArchiveEntryEncodingHelper.getEncoding(encoding);
        this.assemLen = 0;
        this.assemBuf = new byte[recordSize];
        this.recordBuf = new byte[recordSize];
        this.outStream = os;
        this.blockSize = blockSize;
        this.recordSize = recordSize;
        this.recsPerBlock = this.blockSize / this.recordSize;
        this.blockBuffer = new byte[this.blockSize];
        this.currRecIdx = 0;
    }

    public void setLongFileMode(int longFileMode) {
        this.longFileMode = longFileMode;
    }

    public void setBigNumberMode(int bigNumberMode) {
        this.bigNumberMode = bigNumberMode;
    }

    public void setAddPaxHeadersForNonAsciiNames(boolean b) {
        this.addPaxHeadersForNonAsciiNames = b;
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.haveUnclosedEntry) {
            throw new IOException("This archives contains unclosed entries.");
        }
        this.writeEOFRecord();
        this.writeEOFRecord();
        this.flushBlock();
        this.finished = true;
    }

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            this.finish();
        }
        if (!this.closed) {
            if (this.outStream != null) {
                this.flushBlock();
                if (this.outStream != System.out && this.outStream != System.err) {
                    this.outStream.close();
                }
            }
            this.closed = true;
        }
    }

    private void flushBlock() throws IOException {
        if (this.outStream == null) {
            throw new IOException("writing to an input buffer");
        }
        if (this.currRecIdx > 0) {
            this.writeBlock();
        }
    }

    private void writeBlock() throws IOException {
        if (this.outStream == null) {
            throw new IOException("writing to an input buffer");
        }
        this.outStream.write(this.blockBuffer, 0, this.blockSize);
        this.outStream.flush();
        this.currRecIdx = 0;
        Arrays.fill(this.blockBuffer, (byte)0);
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public TarArchiveOutputEntry newArchiveEntry() {
        return new TarArchiveOutputEntry();
    }

    @Override
    public void putArchiveEntry(TarArchiveOutputEntry archiveEntry) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        HashMap<String, String> paxHeaders = new HashMap<String, String>();
        String entryName = archiveEntry.getName();
        byte[] nameBytes = this.encoding.encode(entryName).array();
        boolean paxHeaderContainsPath = false;
        if (nameBytes.length >= 100) {
            if (this.longFileMode == 3) {
                paxHeaders.put("path", entryName);
                paxHeaderContainsPath = true;
            } else if (this.longFileMode == 2) {
                TarArchiveOutputEntry longLinkEntry = new TarArchiveOutputEntry("././@LongLink", 76);
                longLinkEntry.setEntrySize(nameBytes.length + 1);
                this.putArchiveEntry(longLinkEntry);
                this.write(nameBytes);
                this.write(0);
                this.closeArchiveEntry();
            } else if (this.longFileMode != 1) {
                throw new RuntimeException("file name '" + entryName + "' is too long ( > " + 100 + " bytes)");
            }
        }
        if (this.bigNumberMode == 2) {
            this.addPaxHeadersForBigNumbers(paxHeaders, archiveEntry);
        } else if (this.bigNumberMode != 1) {
            this.failForBigNumbers(archiveEntry);
        }
        if (this.addPaxHeadersForNonAsciiNames && !paxHeaderContainsPath && !ASCII.canEncode(entryName)) {
            paxHeaders.put("path", entryName);
        }
        if (this.addPaxHeadersForNonAsciiNames && (archiveEntry.isLink() || archiveEntry.isSymbolicLink()) && !ASCII.canEncode(archiveEntry.getLinkName())) {
            paxHeaders.put("linkpath", archiveEntry.getLinkName());
        }
        if (paxHeaders.size() > 0) {
            this.writePaxHeaders(entryName, paxHeaders);
        }
        archiveEntry.writeEntryHeader(this.recordBuf, this.encoding, this.bigNumberMode == 1);
        this.writeRecord(this.recordBuf);
        this.currBytes = 0L;
        this.currSize = archiveEntry.isDirectory() ? 0L : archiveEntry.getEntrySize();
        this.currName = entryName;
        this.haveUnclosedEntry = true;
    }

    @Override
    public void closeArchiveEntry() throws IOException {
        if (this.finished) {
            throw new IOException("stream has already been finished");
        }
        if (!this.haveUnclosedEntry) {
            throw new IOException("no current entry to close");
        }
        if (this.assemLen > 0) {
            for (int i = this.assemLen; i < this.assemBuf.length; ++i) {
                this.assemBuf[i] = 0;
            }
            this.writeRecord(this.assemBuf);
            this.currBytes += (long)this.assemLen;
            this.assemLen = 0;
        }
        if (this.currBytes < this.currSize) {
            throw new IOException("entry '" + this.currName + "' closed at '" + this.currBytes + "' before the '" + this.currSize + "' bytes specified in the header were written");
        }
        this.haveUnclosedEntry = false;
    }

    @Override
    public void write(byte[] wBuf, int wOffset, int numToWrite) throws IOException {
        if (this.currBytes + (long)numToWrite > this.currSize) {
            throw new IOException("request to write '" + numToWrite + "' bytes exceeds size in header of '" + this.currSize + "' bytes for entry '" + this.currName + "'");
        }
        if (this.assemLen > 0) {
            if (this.assemLen + numToWrite >= this.recordBuf.length) {
                int aLen = this.recordBuf.length - this.assemLen;
                System.arraycopy(this.assemBuf, 0, this.recordBuf, 0, this.assemLen);
                System.arraycopy(wBuf, wOffset, this.recordBuf, this.assemLen, aLen);
                this.writeRecord(this.recordBuf);
                this.currBytes += (long)this.recordBuf.length;
                wOffset += aLen;
                numToWrite -= aLen;
                this.assemLen = 0;
            } else {
                System.arraycopy(wBuf, wOffset, this.assemBuf, this.assemLen, numToWrite);
                wOffset += numToWrite;
                this.assemLen += numToWrite;
                numToWrite = 0;
            }
        }
        while (numToWrite > 0) {
            if (numToWrite < this.recordBuf.length) {
                System.arraycopy(wBuf, wOffset, this.assemBuf, this.assemLen, numToWrite);
                this.assemLen += numToWrite;
                break;
            }
            this.writeRecord(wBuf, wOffset);
            int num = this.recordBuf.length;
            this.currBytes += (long)num;
            numToWrite -= num;
            wOffset += num;
        }
    }

    void writePaxHeaders(String entryName, Map<String, String> headers) throws IOException {
        String name = "./PaxHeaders.X/" + this.stripTo7Bits(entryName);
        if (name.length() >= 100) {
            name = name.substring(0, 99);
        }
        TarArchiveOutputEntry pex = new TarArchiveOutputEntry(name, 120);
        StringWriter w = new StringWriter();
        for (Map.Entry<String, String> h : headers.entrySet()) {
            String key = h.getKey();
            String value = h.getValue();
            int len = key.length() + value.length() + 3 + 2;
            String line = len + " " + key + "=" + value + "\n";
            int actualLength = line.getBytes(Charset.forName("UTF-8")).length;
            while (len != actualLength) {
                len = actualLength;
                line = len + " " + key + "=" + value + "\n";
                actualLength = line.getBytes(Charset.forName("UTF-8")).length;
            }
            w.write(line);
        }
        byte[] data = w.toString().getBytes(Charset.forName("UTF-8"));
        pex.setEntrySize(data.length);
        this.putArchiveEntry(pex);
        this.write(data);
        this.closeArchiveEntry();
    }

    private String stripTo7Bits(String name) {
        int length = name.length();
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char stripped = (char)(name.charAt(i) & 0x7F);
            if (stripped == '\u0000') continue;
            result.append(stripped);
        }
        return result.toString();
    }

    private void writeEOFRecord() throws IOException {
        for (int i = 0; i < this.recordBuf.length; ++i) {
            this.recordBuf[i] = 0;
        }
        this.writeRecord(this.recordBuf);
    }

    @Override
    public void flush() throws IOException {
        this.outStream.flush();
    }

    private void addPaxHeadersForBigNumbers(Map<String, String> paxHeaders, TarArchiveOutputEntry entry) {
        this.addPaxHeaderForBigNumber(paxHeaders, "size", entry.getEntrySize(), 0x1FFFFFFFFL);
        this.addPaxHeaderForBigNumber(paxHeaders, "gid", entry.getGroupId(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(paxHeaders, "mtime", entry.getLastModified().getTime() / 1000L, 0x1FFFFFFFFL);
        this.addPaxHeaderForBigNumber(paxHeaders, "uid", entry.getUserId(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(paxHeaders, "SCHILY.devmajor", entry.getDevMajor(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(paxHeaders, "SCHILY.devminor", entry.getDevMinor(), 0x1FFFFFL);
        this.failForBigNumber("mode", entry.getMode(), 0x1FFFFFL);
    }

    private void addPaxHeaderForBigNumber(Map<String, String> paxHeaders, String header, long value, long maxValue) {
        if (value < 0L || value > maxValue) {
            paxHeaders.put(header, String.valueOf(value));
        }
    }

    private void failForBigNumbers(TarArchiveOutputEntry entry) {
        this.failForBigNumber("entry size", entry.getEntrySize(), 0x1FFFFFFFFL);
        this.failForBigNumber("group id", entry.getGroupId(), 0x1FFFFFL);
        this.failForBigNumber("last modification time", entry.getLastModified().getTime() / 1000L, 0x1FFFFFFFFL);
        this.failForBigNumber("user id", entry.getUserId(), 0x1FFFFFL);
        this.failForBigNumber("mode", entry.getMode(), 0x1FFFFFL);
        this.failForBigNumber("major device number", entry.getDevMajor(), 0x1FFFFFL);
        this.failForBigNumber("minor device number", entry.getDevMinor(), 0x1FFFFFL);
    }

    private void failForBigNumber(String field, long value, long maxValue) {
        if (value < 0L || value > maxValue) {
            throw new RuntimeException(field + " '" + value + "' is too big ( > " + maxValue + " )");
        }
    }

    private void writeRecord(byte[] record) throws IOException {
        if (this.outStream == null) {
            throw new IOException("Output buffer is closed");
        }
        if (record.length != this.recordSize) {
            throw new IOException("record to write has length '" + record.length + "' which is not the record size of '" + this.recordSize + "'");
        }
        if (this.currRecIdx >= this.recsPerBlock) {
            this.writeBlock();
        }
        System.arraycopy(record, 0, this.blockBuffer, this.currRecIdx * this.recordSize, this.recordSize);
        ++this.currRecIdx;
    }

    private void writeRecord(byte[] buf, int offset) throws IOException {
        if (this.outStream == null) {
            throw new IOException("Output buffer is closed");
        }
        if (offset + this.recordSize > buf.length) {
            throw new IOException("record has length '" + buf.length + "' with offset '" + offset + "' which is less than the record size of '" + this.recordSize + "'");
        }
        if (this.currRecIdx >= this.recsPerBlock) {
            this.writeBlock();
        }
        System.arraycopy(buf, offset, this.blockBuffer, this.currRecIdx * this.recordSize, this.recordSize);
        ++this.currRecIdx;
    }
}

