/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.archive.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xbib.io.archive.ArchiveOutputStream;
import org.xbib.io.archive.zip.ZipArchiveEntry;

public class ZipArchiveOutputStream
extends ArchiveOutputStream<ZipArchiveEntry> {
    private final ZipOutputStream out;
    private ZipEntry zipEntry;
    private List<ByteBuffer> bytes;
    private CRC32 crc;
    private boolean finished;
    private boolean closed;

    public ZipArchiveOutputStream(OutputStream out) {
        this.out = new ZipOutputStream(out);
        this.bytes = new LinkedList<ByteBuffer>();
        this.crc = new CRC32();
    }

    @Override
    public ZipArchiveEntry newArchiveEntry() {
        return new ZipArchiveEntry();
    }

    @Override
    public void putArchiveEntry(ZipArchiveEntry entry) throws IOException {
        this.zipEntry = entry.getEntry();
    }

    @Override
    public void closeArchiveEntry() throws IOException {
        this.zipEntry.setCrc(this.crc.getValue());
        this.out.putNextEntry(this.zipEntry);
        WritableByteChannel channel = Channels.newChannel(this.out);
        for (ByteBuffer buffer : this.bytes) {
            channel.write(buffer);
        }
        this.bytes.clear();
        this.out.closeEntry();
    }

    @Override
    public void finish() throws IOException {
        this.out.finish();
        this.finished = true;
    }

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            this.finish();
        }
        if (!this.closed) {
            this.out.close();
            this.closed = true;
        }
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.getWatcher().updateBytesTransferred(length);
        this.crc.update(b, offset, length);
        this.bytes.add(ByteBuffer.wrap(b, offset, length));
    }
}

