/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import org.xbib.io.compress.CompressCodec;

public class CompressCodecService {
    private static final Map<String, CompressCodec> codecs = new WeakHashMap<String, CompressCodec>();
    private static final CompressCodecService instance = new CompressCodecService();

    private CompressCodecService() {
        ServiceLoader<CompressCodec> loader = ServiceLoader.load(CompressCodec.class);
        for (CompressCodec codec : loader) {
            if (codecs.containsKey(codec.getName())) continue;
            codecs.put(codec.getName(), codec);
        }
    }

    public static CompressCodecService getInstance() {
        return instance;
    }

    public CompressCodec getCodec(String suffix) {
        if (codecs.containsKey(suffix)) {
            return codecs.get(suffix);
        }
        throw new IllegalArgumentException("Stream codec for " + suffix + " not found in " + codecs);
    }

    public static Set<String> getCodecs() {
        return codecs.keySet();
    }
}

