/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.xbib.io.compress.bzip2.BZip2Exception;

public class BZip2BitInputStream {
    private final InputStream inputStream;
    private int bitBuffer;
    private int bitCount;

    public boolean readBoolean() throws IOException {
        int bitBuffer = this.bitBuffer;
        int bitCount = this.bitCount;
        if (bitCount > 0) {
            --bitCount;
        } else {
            int byteRead = this.inputStream.read();
            if (byteRead < 0) {
                throw new BZip2Exception("Insufficient data");
            }
            bitBuffer = bitBuffer << 8 | byteRead;
            bitCount += 7;
            this.bitBuffer = bitBuffer;
        }
        this.bitCount = bitCount;
        return (bitBuffer & 1 << bitCount) != 0;
    }

    public int readUnary() throws IOException {
        int bitBuffer = this.bitBuffer;
        int bitCount = this.bitCount;
        int unaryCount = 0;
        while (true) {
            if (bitCount > 0) {
                --bitCount;
            } else {
                int byteRead = this.inputStream.read();
                if (byteRead < 0) {
                    throw new BZip2Exception("Insufficient data");
                }
                bitBuffer = bitBuffer << 8 | byteRead;
                bitCount += 7;
            }
            if ((bitBuffer & 1 << bitCount) == 0) {
                this.bitBuffer = bitBuffer;
                this.bitCount = bitCount;
                return unaryCount;
            }
            ++unaryCount;
        }
    }

    public int readBits(int count) throws IOException {
        int bitBuffer = this.bitBuffer;
        int bitCount = this.bitCount;
        if (bitCount < count) {
            while (bitCount < count) {
                int byteRead = this.inputStream.read();
                if (byteRead < 0) {
                    throw new BZip2Exception("Insufficient data");
                }
                bitBuffer = bitBuffer << 8 | byteRead;
                bitCount += 8;
            }
            this.bitBuffer = bitBuffer;
        }
        this.bitCount = bitCount -= count;
        return bitBuffer >>> bitCount & (1 << count) - 1;
    }

    public int readInteger() throws IOException {
        return this.readBits(16) << 16 | this.readBits(16);
    }

    public BZip2BitInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }
}

