/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.bzip2;

import java.io.IOException;
import org.xbib.io.compress.bzip2.BZip2BitInputStream;
import org.xbib.io.compress.bzip2.BZip2Exception;
import org.xbib.io.compress.bzip2.BZip2HuffmanStageDecoder;
import org.xbib.io.compress.bzip2.CRC32;
import org.xbib.io.compress.bzip2.MoveToFront;

public class BZip2BlockDecompressor {
    private static final int[] RNUMS = new int[]{619, 720, 127, 481, 931, 816, 813, 233, 566, 247, 985, 724, 205, 454, 863, 491, 741, 242, 949, 214, 733, 859, 335, 708, 621, 574, 73, 654, 730, 472, 419, 436, 278, 496, 867, 210, 399, 680, 480, 51, 878, 465, 811, 169, 869, 675, 611, 697, 867, 561, 862, 687, 507, 283, 482, 129, 807, 591, 733, 623, 150, 238, 59, 379, 684, 877, 625, 169, 643, 105, 170, 607, 520, 932, 727, 476, 693, 425, 174, 647, 73, 122, 335, 530, 442, 853, 695, 249, 445, 515, 909, 545, 703, 919, 874, 474, 882, 500, 594, 612, 641, 801, 220, 162, 819, 984, 589, 513, 495, 799, 161, 604, 958, 533, 221, 400, 386, 867, 600, 782, 382, 596, 414, 171, 516, 375, 682, 485, 911, 276, 98, 553, 163, 354, 666, 933, 424, 341, 533, 870, 227, 730, 475, 186, 263, 647, 537, 686, 600, 224, 469, 68, 770, 919, 190, 373, 294, 822, 808, 206, 184, 943, 795, 384, 383, 461, 404, 758, 839, 887, 715, 67, 618, 276, 204, 918, 873, 777, 604, 560, 951, 160, 578, 722, 79, 804, 96, 409, 713, 940, 652, 934, 970, 447, 318, 353, 859, 672, 112, 785, 645, 863, 803, 350, 139, 93, 354, 99, 820, 908, 609, 772, 154, 274, 580, 184, 79, 626, 630, 742, 653, 282, 762, 623, 680, 81, 927, 626, 789, 125, 411, 521, 938, 300, 821, 78, 343, 175, 128, 250, 170, 774, 972, 275, 999, 639, 495, 78, 352, 126, 857, 956, 358, 619, 580, 124, 737, 594, 701, 612, 669, 112, 134, 694, 363, 992, 809, 743, 168, 974, 944, 375, 748, 52, 600, 747, 642, 182, 862, 81, 344, 805, 988, 739, 511, 655, 814, 334, 249, 515, 897, 955, 664, 981, 649, 113, 974, 459, 893, 228, 433, 837, 553, 268, 926, 240, 102, 654, 459, 51, 686, 754, 806, 760, 493, 403, 415, 394, 687, 700, 946, 670, 656, 610, 738, 392, 760, 799, 887, 653, 978, 321, 576, 617, 626, 502, 894, 679, 243, 440, 680, 879, 194, 572, 640, 724, 926, 56, 204, 700, 707, 151, 457, 449, 797, 195, 791, 558, 945, 679, 297, 59, 87, 824, 713, 663, 412, 693, 342, 606, 134, 108, 571, 364, 631, 212, 174, 643, 304, 329, 343, 97, 430, 751, 497, 314, 983, 374, 822, 928, 140, 206, 73, 263, 980, 736, 876, 478, 430, 305, 170, 514, 364, 692, 829, 82, 855, 953, 676, 246, 369, 970, 294, 750, 807, 827, 150, 790, 288, 923, 804, 378, 215, 828, 592, 281, 565, 555, 710, 82, 896, 831, 547, 261, 524, 462, 293, 465, 502, 56, 661, 821, 976, 991, 658, 869, 905, 758, 745, 193, 768, 550, 608, 933, 378, 286, 215, 979, 792, 961, 61, 688, 793, 644, 986, 403, 106, 366, 905, 644, 372, 567, 466, 434, 645, 210, 389, 550, 919, 135, 780, 773, 635, 389, 707, 100, 626, 958, 165, 504, 920, 176, 193, 713, 857, 265, 203, 50, 668, 108, 645, 990, 626, 197, 510, 357, 358, 850, 858, 364, 936, 638};
    private final BZip2BitInputStream bitInputStream;
    private final CRC32 crc = new CRC32();
    private final int blockCRC;
    private final boolean blockRandomised;
    private int huffmanEndOfBlockSymbol;
    private final byte[] huffmanSymbolMap = new byte[256];
    private final int[] bwtByteCounts = new int[256];
    private byte[] bwtBlock;
    private int[] bwtMergedPointers;
    private int bwtCurrentMergedPointer;
    private int bwtBlockLength;
    private int bwtBytesDecoded;
    private int rleLastDecodedByte = -1;
    private int rleAccumulator;
    private int rleRepeat;
    private int randomIndex = 0;
    private int randomCount = RNUMS[0] - 1;

    private BZip2HuffmanStageDecoder readHuffmanTables() throws IOException {
        int endOfBlockSymbol;
        BZip2BitInputStream bitInputStream = this.bitInputStream;
        byte[] huffmanSymbolMap = this.huffmanSymbolMap;
        byte[][] tableCodeLengths = new byte[6][258];
        int huffmanUsedRanges = bitInputStream.readBits(16);
        int huffmanSymbolCount = 0;
        for (int i = 0; i < 16; ++i) {
            if ((huffmanUsedRanges & 32768 >>> i) == 0) continue;
            int j = 0;
            int k = i << 4;
            while (j < 16) {
                if (bitInputStream.readBoolean()) {
                    huffmanSymbolMap[huffmanSymbolCount++] = (byte)k;
                }
                ++j;
                ++k;
            }
        }
        this.huffmanEndOfBlockSymbol = endOfBlockSymbol = huffmanSymbolCount + 1;
        int totalTables = bitInputStream.readBits(3);
        int totalSelectors = bitInputStream.readBits(15);
        if (totalTables < 2 || totalTables > 6 || totalSelectors < 1 || totalSelectors > 18001) {
            throw new BZip2Exception("BZip2 block Huffman tables invalid");
        }
        MoveToFront tableMTF = new MoveToFront();
        byte[] selectors = new byte[totalSelectors];
        for (int selector = 0; selector < totalSelectors; ++selector) {
            selectors[selector] = tableMTF.indexToFront(bitInputStream.readUnary());
        }
        for (int table = 0; table < totalTables; ++table) {
            int currentLength = bitInputStream.readBits(5);
            for (int i = 0; i <= endOfBlockSymbol; ++i) {
                while (bitInputStream.readBoolean()) {
                    currentLength += bitInputStream.readBoolean() ? -1 : 1;
                }
                tableCodeLengths[table][i] = (byte)currentLength;
            }
        }
        return new BZip2HuffmanStageDecoder(bitInputStream, endOfBlockSymbol + 1, tableCodeLengths, selectors);
    }

    private void decodeHuffmanData(BZip2HuffmanStageDecoder huffmanDecoder) throws IOException {
        byte[] bwtBlock = this.bwtBlock;
        byte[] huffmanSymbolMap = this.huffmanSymbolMap;
        int streamBlockSize = this.bwtBlock.length;
        int huffmanEndOfBlockSymbol = this.huffmanEndOfBlockSymbol;
        int[] bwtByteCounts = this.bwtByteCounts;
        MoveToFront symbolMTF = new MoveToFront();
        int bwtBlockLength = 0;
        int repeatCount = 0;
        int repeatIncrement = 1;
        int mtfValue = 0;
        while (true) {
            byte nextByte;
            int nextSymbol;
            if ((nextSymbol = huffmanDecoder.nextSymbol()) == 0) {
                repeatCount += repeatIncrement;
                repeatIncrement <<= 1;
                continue;
            }
            if (nextSymbol == 1) {
                repeatCount += repeatIncrement << 1;
                repeatIncrement <<= 1;
                continue;
            }
            if (repeatCount > 0) {
                if (bwtBlockLength + repeatCount > streamBlockSize) {
                    throw new BZip2Exception("BZip2 block exceeds declared block size");
                }
                nextByte = huffmanSymbolMap[mtfValue];
                int n = nextByte & 0xFF;
                bwtByteCounts[n] = bwtByteCounts[n] + repeatCount;
                while (--repeatCount >= 0) {
                    bwtBlock[bwtBlockLength++] = nextByte;
                }
                repeatCount = 0;
                repeatIncrement = 1;
            }
            if (nextSymbol == huffmanEndOfBlockSymbol) break;
            if (bwtBlockLength >= streamBlockSize) {
                throw new BZip2Exception("BZip2 block exceeds declared block size");
            }
            mtfValue = symbolMTF.indexToFront(nextSymbol - 1) & 0xFF;
            nextByte = huffmanSymbolMap[mtfValue];
            int n = nextByte & 0xFF;
            bwtByteCounts[n] = bwtByteCounts[n] + 1;
            bwtBlock[bwtBlockLength++] = nextByte;
        }
        this.bwtBlockLength = bwtBlockLength;
    }

    private void initialiseInverseBWT(int bwtStartPointer) throws IOException {
        int i;
        byte[] bwtBlock = this.bwtBlock;
        int[] bwtMergedPointers = new int[this.bwtBlockLength];
        int[] characterBase = new int[256];
        if (bwtStartPointer < 0 || bwtStartPointer >= this.bwtBlockLength) {
            throw new BZip2Exception("BZip2 start pointer invalid");
        }
        System.arraycopy(this.bwtByteCounts, 0, characterBase, 1, 255);
        for (i = 2; i <= 255; ++i) {
            int n = i;
            characterBase[n] = characterBase[n] + characterBase[i - 1];
        }
        for (i = 0; i < this.bwtBlockLength; ++i) {
            int value;
            int n = value = bwtBlock[i] & 0xFF;
            int n2 = characterBase[n];
            characterBase[n] = n2 + 1;
            bwtMergedPointers[n2] = (i << 8) + value;
        }
        this.bwtBlock = null;
        this.bwtMergedPointers = bwtMergedPointers;
        this.bwtCurrentMergedPointer = bwtMergedPointers[bwtStartPointer];
    }

    private int decodeNextBWTByte() {
        int mergedPointer = this.bwtCurrentMergedPointer;
        int nextDecodedByte = mergedPointer & 0xFF;
        this.bwtCurrentMergedPointer = this.bwtMergedPointers[mergedPointer >>> 8];
        if (this.blockRandomised && --this.randomCount == 0) {
            nextDecodedByte ^= 1;
            this.randomIndex = (this.randomIndex + 1) % 512;
            this.randomCount = RNUMS[this.randomIndex];
        }
        ++this.bwtBytesDecoded;
        return nextDecodedByte;
    }

    public int read() {
        while (this.rleRepeat < 1) {
            if (this.bwtBytesDecoded == this.bwtBlockLength) {
                return -1;
            }
            int nextByte = this.decodeNextBWTByte();
            if (nextByte != this.rleLastDecodedByte) {
                this.rleLastDecodedByte = nextByte;
                this.rleRepeat = 1;
                this.rleAccumulator = 1;
                this.crc.updateCRC(nextByte);
                continue;
            }
            if (++this.rleAccumulator == 4) {
                int rleRepeat;
                this.rleRepeat = rleRepeat = this.decodeNextBWTByte() + 1;
                this.rleAccumulator = 0;
                this.crc.updateCRC(nextByte, rleRepeat);
                continue;
            }
            this.rleRepeat = 1;
            this.crc.updateCRC(nextByte);
        }
        --this.rleRepeat;
        return this.rleLastDecodedByte;
    }

    public int read(byte[] destination, int offset, int length) {
        int i = 0;
        while (i < length) {
            int decoded = this.read();
            if (decoded == -1) {
                return i == 0 ? -1 : i;
            }
            destination[offset] = (byte)decoded;
            ++i;
            ++offset;
        }
        return i;
    }

    public int checkCRC() throws IOException {
        if (this.blockCRC != this.crc.getCRC()) {
            throw new BZip2Exception("BZip2 block CRC error");
        }
        return this.crc.getCRC();
    }

    public BZip2BlockDecompressor(BZip2BitInputStream bitInputStream, int blockSize) throws IOException {
        this.bitInputStream = bitInputStream;
        this.bwtBlock = new byte[blockSize];
        this.blockCRC = this.bitInputStream.readInteger();
        this.blockRandomised = this.bitInputStream.readBoolean();
        int bwtStartPointer = this.bitInputStream.readBits(24);
        BZip2HuffmanStageDecoder huffmanDecoder = this.readHuffmanTables();
        this.decodeHuffmanData(huffmanDecoder);
        this.initialiseInverseBWT(bwtStartPointer);
    }
}

