/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import org.xbib.io.compress.bzip2.BZip2BitOutputStream;
import org.xbib.io.compress.bzip2.BZip2BlockCompressor;
import org.xbib.io.compress.bzip2.BZip2Exception;

public class BZip2OutputStream
extends OutputStream {
    private OutputStream outputStream;
    private BZip2BitOutputStream bitOutputStream;
    private boolean streamFinished = false;
    private final int streamBlockSize;
    private int streamCRC = 0;
    private BZip2BlockCompressor blockCompressor;

    public BZip2OutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 9);
    }

    public BZip2OutputStream(OutputStream outputStream, int blockSizeMultiplier) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null output stream");
        }
        if (blockSizeMultiplier < 1 || blockSizeMultiplier > 9) {
            throw new IllegalArgumentException("Invalid BZip2 block size" + blockSizeMultiplier);
        }
        this.streamBlockSize = blockSizeMultiplier * 100000;
        this.outputStream = outputStream;
        this.bitOutputStream = new BZip2BitOutputStream(this.outputStream);
        this.bitOutputStream.writeBits(16, 16986);
        this.bitOutputStream.writeBits(8, 104);
        this.bitOutputStream.writeBits(8, 48 + blockSizeMultiplier);
        this.initialiseNextBlock();
    }

    @Override
    public void write(int value) throws IOException {
        if (this.outputStream == null) {
            throw new BZip2Exception("Stream closed");
        }
        if (this.streamFinished) {
            throw new BZip2Exception("Write beyond end of stream");
        }
        if (!this.blockCompressor.write(value & 0xFF)) {
            this.closeBlock();
            this.initialiseNextBlock();
            this.blockCompressor.write(value & 0xFF);
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.outputStream == null) {
            throw new BZip2Exception("Stream closed");
        }
        if (this.streamFinished) {
            throw new BZip2Exception("Write beyond end of stream");
        }
        while (length > 0) {
            int bytesWritten = this.blockCompressor.write(data, offset, length);
            if (bytesWritten < length) {
                this.closeBlock();
                this.initialiseNextBlock();
            }
            offset += bytesWritten;
            length -= bytesWritten;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.finish();
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    private void initialiseNextBlock() {
        this.blockCompressor = new BZip2BlockCompressor(this.bitOutputStream, this.streamBlockSize);
    }

    private void closeBlock() throws IOException {
        if (this.blockCompressor.isEmpty()) {
            return;
        }
        this.blockCompressor.close();
        int blockCRC = this.blockCompressor.getCRC();
        this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ blockCRC;
    }

    public void finish() throws IOException {
        if (!this.streamFinished) {
            this.streamFinished = true;
            try {
                this.closeBlock();
                this.bitOutputStream.writeBits(24, 1536581);
                this.bitOutputStream.writeBits(24, 3690640);
                this.bitOutputStream.writeInteger(this.streamCRC);
                this.bitOutputStream.flush();
                this.outputStream.flush();
            }
            finally {
                this.blockCompressor = null;
            }
        }
    }
}

