/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.lzf;

import org.xbib.io.compress.lzf.ChunkDecoder;
import org.xbib.io.compress.lzf.VanillaChunkDecoder;

public class ChunkDecoderFactory {
    private static final ChunkDecoderFactory _instance;
    private final Class<? extends ChunkDecoder> _implClass;

    private ChunkDecoderFactory(Class<?> imp) {
        this._implClass = imp;
    }

    public static ChunkDecoder optimalInstance() {
        try {
            return ChunkDecoderFactory._instance._implClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load a ChunkDecoder instance (" + e.getClass().getName() + "): " + e.getMessage(), e);
        }
    }

    public static ChunkDecoder safeInstance() {
        return new VanillaChunkDecoder();
    }

    static {
        Class<VanillaChunkDecoder> impl = VanillaChunkDecoder.class;
        _instance = new ChunkDecoderFactory(impl);
    }
}

